/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.operations.CompositeOperationAwareTransformer;
import org.jboss.as.controller.operations.OperationAttachments;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.ChainedParameterValidator;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayContentDefinition;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentOverlayContentAdd
extends AbstractAddStepHandler {
    protected final ContentRepository contentRepository;
    private final DeploymentFileRepository remoteRepository;
    protected final ParametersValidator validator = new ParametersValidator();
    protected final ParametersValidator managedContentValidator = new ParametersValidator();

    public DeploymentOverlayContentAdd(ContentRepository contentRepository, DeploymentFileRepository remoteRepository) {
        this.contentRepository = contentRepository;
        this.remoteRepository = remoteRepository;
        ParametersValidator contentValidator = new ParametersValidator();
        contentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        contentValidator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1, true));
        this.validator.registerValidator("content", ChainedParameterValidator.chain((ParameterValidator[])new ParameterValidator[]{new ListValidator((ParameterValidator)new ParametersOfValidator(contentValidator)), new AbstractParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                DeploymentOverlayContentAdd.validateOnePieceOfContent(value);
            }
        }}));
        this.managedContentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        byte[] hash;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String path = address.getLastElement().getValue();
        String name = address.getElement(address.size() - 2).getValue();
        ModelNode content = operation.get("content");
        if (content.hasDefined("hash")) {
            this.managedContentValidator.validate(content);
            hash = content.require("hash").asBytes();
            this.addFromHash(hash, name, path, context);
        } else {
            hash = this.addFromContentAdditionParameter(context, content);
            ModelNode slave = operation.clone();
            slave.get("content").clear();
            slave.get("content").get("hash").set(hash);
            ArrayList<CompositeOperationAwareTransformer> transformers = (ArrayList<CompositeOperationAwareTransformer>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS);
            if (transformers == null) {
                transformers = new ArrayList<CompositeOperationAwareTransformer>();
                context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS, transformers);
            }
            transformers.add(new CompositeOperationAwareTransformer(slave));
        }
        ModelNode modified = operation.clone();
        modified.get("content").clone();
        modified.get("content").set(hash);
        for (AttributeDefinition attr : DeploymentOverlayContentDefinition.attributes()) {
            attr.validateAndSet(modified, resource.getModel());
        }
        if (!this.contentRepository.syncContent(hash)) {
            throw ServerLogger.ROOT_LOGGER.noSuchDeploymentContent(Arrays.toString(hash));
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    protected static void validateOnePieceOfContent(ModelNode content) throws OperationFailedException {
        if (content.asList().size() != 1) {
            throw ServerLogger.ROOT_LOGGER.multipleContentItemsNotSupported();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] addFromHash(byte[] hash, String deploymentOverlayName, String contentName, OperationContext context) throws OperationFailedException {
        if (this.remoteRepository != null) {
            this.remoteRepository.getDeploymentFiles(hash);
        }
        if (this.contentRepository.syncContent(hash)) return hash;
        if (!context.isBooting()) throw ServerLogger.ROOT_LOGGER.noSuchDeploymentOverlayContent(HashUtil.bytesToHexString((byte[])hash));
        if (context.getRunningMode() != RunningMode.ADMIN_ONLY) throw ServerLogger.ROOT_LOGGER.noSuchDeploymentOverlayContentAtBoot(HashUtil.bytesToHexString((byte[])hash), deploymentOverlayName, contentName);
        ServerLogger.DEPLOYMENT_LOGGER.reportAdminOnlyMissingDeploymentOverlayContent(HashUtil.bytesToHexString((byte[])hash), deploymentOverlayName, contentName);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        byte[] hash;
        InputStream in = DeploymentOverlayContentAdd.getInputStream(context, contentItemNode);
        try {
            try {
                hash = this.contentRepository.addContent(in);
            }
            catch (IOException e) {
                throw DeploymentOverlayContentAdd.createFailureException(e.toString());
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
        return hash;
    }

    protected static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(msg);
    }

    protected static InputStream getInputStream(OperationContext context, ModelNode operation) throws OperationFailedException {
        InputStream in = null;
        if (operation.hasDefined("input-stream-index")) {
            int maxIndex;
            int streamIndex = operation.get("input-stream-index").asInt();
            if (streamIndex > (maxIndex = context.getAttachmentStreamCount())) {
                throw ServerLogger.ROOT_LOGGER.invalidStreamIndex("input-stream-index", streamIndex, maxIndex);
            }
            in = context.getAttachmentStream(streamIndex);
        } else {
            if (operation.hasDefined("bytes")) {
                try {
                    in = new ByteArrayInputStream(operation.get("bytes").asBytes());
                }
                catch (IllegalArgumentException iae) {
                    throw ServerLogger.ROOT_LOGGER.invalidStreamBytes("bytes");
                }
            }
            if (operation.hasDefined("url")) {
                String urlSpec = operation.get("url").asString();
                try {
                    in = new URL(urlSpec).openStream();
                }
                catch (MalformedURLException e) {
                    throw ServerLogger.ROOT_LOGGER.invalidStreamURL(e, urlSpec);
                }
                catch (IOException e) {
                    throw ServerLogger.ROOT_LOGGER.invalidStreamURL(e, urlSpec);
                }
            }
        }
        if (in == null) {
            throw new IllegalStateException();
        }
        return in;
    }
}

