/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.server.deployment.Attachable;
import org.jboss.as.server.deployment.AttachableDependency;
import org.jboss.as.server.deployment.AttachedDependency;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentPhaseContextImpl;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.ListAttachmentKey;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.RegisteredDeploymentUnitProcessor;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.DelegatingServiceRegistry;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

final class DeploymentUnitPhaseService<T>
implements Service<T> {
    private static final AttachmentKey<AttachmentList<DeploymentUnit>> UNVISITED_DEFERRED_MODULES = AttachmentKey.createList(DeploymentUnit.class);
    private final InjectedValue<DeployerChains> deployerChainsInjector = new InjectedValue();
    private final DeploymentUnit deploymentUnit;
    private final Phase phase;
    private final AttachmentKey<T> valueKey;
    private final List<AttachedDependency> injectedAttachedDependencies = new ArrayList<AttachedDependency>();
    private final AtomicBoolean runOnce = new AtomicBoolean();

    private DeploymentUnitPhaseService(DeploymentUnit deploymentUnit, Phase phase, AttachmentKey<T> valueKey) {
        this.deploymentUnit = deploymentUnit;
        this.phase = phase;
        this.valueKey = valueKey;
    }

    private static <T> DeploymentUnitPhaseService<T> create(DeploymentUnit deploymentUnit, Phase phase, AttachmentKey<T> valueKey) {
        return new DeploymentUnitPhaseService<T>(deploymentUnit, phase, valueKey);
    }

    static DeploymentUnitPhaseService<?> create(DeploymentUnit deploymentUnit, Phase phase) {
        return DeploymentUnitPhaseService.create(deploymentUnit, phase, phase.getPhaseKey());
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceBuilder phaseServiceBuilder;
        DeploymentUnitPhaseService<?> phaseService;
        boolean allowRestart = this.restartAllowed();
        if (this.runOnce.get() && !allowRestart) {
            ServerLogger.DEPLOYMENT_LOGGER.deploymentRestartDetected(this.deploymentUnit.getName());
            ServiceName serviceName = this.deploymentUnit.getParent() == null ? this.deploymentUnit.getServiceName() : this.deploymentUnit.getParent().getServiceName();
            ServiceController controller = context.getController().getServiceContainer().getRequiredService(serviceName);
            controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
                    if (transition.getAfter().equals((Object)ServiceController.Substate.DOWN)) {
                        controller.setMode(ServiceController.Mode.ACTIVE);
                        controller.removeListener((ServiceListener)this);
                    }
                }
            });
            controller.setMode(ServiceController.Mode.NEVER);
            return;
        }
        this.runOnce.set(true);
        DeployerChains chains = (DeployerChains)this.deployerChainsInjector.getValue();
        DeploymentUnit deploymentUnit = this.deploymentUnit;
        List<RegisteredDeploymentUnitProcessor> list = chains.getChain(this.phase);
        ListIterator<RegisteredDeploymentUnitProcessor> iterator = list.listIterator();
        ServiceContainer container = context.getController().getServiceContainer();
        ServiceTarget serviceTarget = context.getChildTarget().subTarget();
        Phase nextPhase = this.phase.next();
        String name = deploymentUnit.getName();
        DeploymentUnit parent = deploymentUnit.getParent();
        if (nextPhase != null) {
            ServiceName serviceName = DeploymentUtils.getDeploymentUnitPhaseServiceName(deploymentUnit, nextPhase);
            phaseService = DeploymentUnitPhaseService.create(deploymentUnit, nextPhase);
            phaseServiceBuilder = serviceTarget.addService(serviceName, phaseService);
        } else {
            phaseServiceBuilder = null;
            phaseService = null;
        }
        DeploymentPhaseContextImpl processorContext = new DeploymentPhaseContextImpl(serviceTarget, (ServiceRegistry)new DelegatingServiceRegistry((ServiceRegistry)container), phaseServiceBuilder, deploymentUnit, this.phase);
        for (AttachedDependency attachedDependency : this.injectedAttachedDependencies) {
            Attachable target = attachedDependency.isDeploymentUnit() ? deploymentUnit : processorContext;
            if (attachedDependency.getAttachmentKey() instanceof ListAttachmentKey) {
                target.addToAttachmentList(attachedDependency.getAttachmentKey(), attachedDependency.getValue().getValue());
                continue;
            }
            target.putAttachment(attachedDependency.getAttachmentKey(), attachedDependency.getValue().getValue());
        }
        while (iterator.hasNext()) {
            RegisteredDeploymentUnitProcessor processor = iterator.next();
            try {
                if (!DeploymentUnitPhaseService.shouldRun(deploymentUnit, processor)) continue;
                processor.getProcessor().deploy(processorContext);
            }
            catch (Throwable e) {
                while (iterator.hasPrevious()) {
                    RegisteredDeploymentUnitProcessor prev = iterator.previous();
                    DeploymentUnitPhaseService.safeUndeploy(deploymentUnit, this.phase, prev);
                }
                throw ServerLogger.ROOT_LOGGER.deploymentPhaseFailed(this.phase, deploymentUnit, e);
            }
        }
        if (nextPhase != null) {
            ServiceController.Mode initialMode;
            List nextPhaseAttachableDeps;
            phaseServiceBuilder.addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, phaseService.getDeployerChainsInjector());
            phaseServiceBuilder.addDependency(context.getController().getName());
            List nextPhaseDeps = processorContext.getAttachment(Attachments.NEXT_PHASE_DEPS);
            if (nextPhaseDeps != null) {
                phaseServiceBuilder.addDependencies((Iterable)nextPhaseDeps);
            }
            if ((nextPhaseAttachableDeps = (List)processorContext.getAttachment(Attachments.NEXT_PHASE_ATTACHABLE_DEPS)) != null) {
                for (AttachableDependency attachableDep : nextPhaseAttachableDeps) {
                    AttachedDependency result = new AttachedDependency(attachableDep.getAttachmentKey(), attachableDep.isDeploymentUnit());
                    phaseServiceBuilder.addDependency(attachableDep.getServiceName(), result.getValue());
                    phaseService.injectedAttachedDependencies.add(result);
                }
            }
            if (parent != null) {
                phaseServiceBuilder.addDependencies(new ServiceName[]{Services.deploymentUnitName(parent.getName(), nextPhase)});
            }
            List<DeploymentUnit> subDeployments = deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
            for (DeploymentUnit du : subDeployments) {
                phaseServiceBuilder.addDependencies(new ServiceName[]{du.getServiceName().append(new String[]{this.phase.name()})});
            }
            List<String> deferredModules = DeploymentUtils.getDeferredModules(deploymentUnit);
            if (nextPhase == Phase.FIRST_MODULE_USE && (initialMode = this.getDeferableInitialMode(deploymentUnit, deferredModules)) != ServiceController.Mode.ACTIVE) {
                ServerLogger.DEPLOYMENT_LOGGER.infoDeferDeploymentPhase(nextPhase, name, initialMode);
                phaseServiceBuilder.setInitialMode(initialMode);
            }
            phaseServiceBuilder.install();
        }
    }

    private Boolean restartAllowed() {
        DeploymentUnit parent = this.deploymentUnit.getParent() == null ? this.deploymentUnit : this.deploymentUnit.getParent();
        Boolean allowed = parent.getAttachment(Attachments.ALLOW_PHASE_RESTART);
        return allowed != null && allowed != false;
    }

    public synchronized void stop(StopContext context) {
        DeploymentUnit deploymentUnitContext = this.deploymentUnit;
        DeployerChains chains = (DeployerChains)this.deployerChainsInjector.getValue();
        List<RegisteredDeploymentUnitProcessor> list = chains.getChain(this.phase);
        ListIterator<RegisteredDeploymentUnitProcessor> iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            RegisteredDeploymentUnitProcessor prev = iterator.previous();
            DeploymentUnitPhaseService.safeUndeploy(deploymentUnitContext, this.phase, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceController.Mode getDeferableInitialMode(DeploymentUnit deploymentUnit, List<String> deferredModules) {
        ServiceController.Mode initialMode;
        block8: {
            List<DeploymentUnit> unvisited;
            DeploymentUnit parent;
            block7: {
                if (deferredModules.contains(deploymentUnit.getName())) {
                    return ServiceController.Mode.NEVER;
                }
                initialMode = ServiceController.Mode.ACTIVE;
                parent = DeploymentUtils.getTopDeploymentUnit(deploymentUnit);
                if (parent != deploymentUnit) break block7;
                List<DeploymentUnit> subDeployments = parent.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
                for (DeploymentUnit du : subDeployments) {
                    if (!du.hasAttachment(Attachments.OSGI_MANIFEST)) continue;
                    initialMode = ServiceController.Mode.LAZY;
                    break;
                }
                if (initialMode != ServiceController.Mode.LAZY) break block8;
                for (DeploymentUnit du : subDeployments) {
                    parent.addToAttachmentList(UNVISITED_DEFERRED_MODULES, du);
                }
                break block8;
            }
            List<DeploymentUnit> list = unvisited = parent.getAttachmentList(UNVISITED_DEFERRED_MODULES);
            synchronized (list) {
                unvisited.remove(deploymentUnit);
                if (!deferredModules.isEmpty() || !unvisited.isEmpty()) {
                    initialMode = ServiceController.Mode.PASSIVE;
                }
            }
        }
        return initialMode;
    }

    private static void safeUndeploy(DeploymentUnit deploymentUnit, Phase phase, RegisteredDeploymentUnitProcessor prev) {
        try {
            if (DeploymentUnitPhaseService.shouldRun(deploymentUnit, prev)) {
                prev.getProcessor().undeploy(deploymentUnit);
            }
        }
        catch (Throwable t) {
            ServerLogger.DEPLOYMENT_LOGGER.caughtExceptionUndeploying(t, prev.getProcessor(), phase, deploymentUnit);
        }
    }

    public synchronized T getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentUnit.getAttachment(this.valueKey);
    }

    InjectedValue<DeployerChains> getDeployerChainsInjector() {
        return this.deployerChainsInjector;
    }

    private static boolean shouldRun(DeploymentUnit unit, RegisteredDeploymentUnitProcessor deployer) {
        Set<String> shouldNotRun = unit.getAttachment(Attachments.EXCLUDED_SUBSYSTEMS);
        if (shouldNotRun == null) {
            if (unit.getParent() != null) {
                shouldNotRun = unit.getParent().getAttachment(Attachments.EXCLUDED_SUBSYSTEMS);
            }
            if (shouldNotRun == null) {
                return true;
            }
        }
        return !shouldNotRun.contains(deployer.getSubsystemName());
    }
}

