/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.ProcessEnvironmentSystemPropertyUpdater;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentSystemPropertyUpdater;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.controller.resources.SecurityActions;
import org.jboss.as.server.operations.SystemPropertyAddHandler;
import org.jboss.as.server.operations.SystemPropertyRemoveHandler;
import org.jboss.as.server.operations.SystemPropertyValueWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SystemPropertyResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"system-property");
    public static final SimpleAttributeDefinition VALUE = SimpleAttributeDefinitionBuilder.create((String)"value", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(0, true, true)).build();
    public static final SimpleAttributeDefinition BOOT_TIME = SimpleAttributeDefinitionBuilder.create((String)"boot-time", (ModelType)ModelType.BOOLEAN, (boolean)true).setValidator((ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true)).setDefaultValue(new ModelNode(true)).setAllowExpression(true).build();
    static final AttributeDefinition[] ALL_ATTRIBUTES = new AttributeDefinition[]{VALUE, BOOT_TIME};
    static final AttributeDefinition[] SERVER_ATTRIBUTES = new AttributeDefinition[]{VALUE};
    final ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater;
    final boolean useBoottime;
    private final List<AccessConstraintDefinition> sensitivity;

    private SystemPropertyResourceDefinition(Location location, ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater, boolean useBoottime) {
        super(PATH, (ResourceDescriptionResolver)new ReplaceResourceNameResourceDescriptionResolver(location, "system-property"), (OperationStepHandler)new SystemPropertyAddHandler(systemPropertyUpdater, useBoottime, useBoottime ? ALL_ATTRIBUTES : SERVER_ATTRIBUTES), (OperationStepHandler)new SystemPropertyRemoveHandler(systemPropertyUpdater));
        this.systemPropertyUpdater = systemPropertyUpdater;
        this.useBoottime = useBoottime;
        SensitiveTargetAccessConstraintDefinition acd = new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SYSTEM_PROPERTY);
        this.sensitivity = Collections.singletonList(acd);
    }

    public static SystemPropertyResourceDefinition createForStandaloneServer(ServerEnvironment processEnvironment) {
        return new SystemPropertyResourceDefinition(Location.STANDALONE, new ServerEnvironmentSystemPropertyUpdater(processEnvironment), false);
    }

    public static SystemPropertyResourceDefinition createForDomainOrHost(Location location) {
        return new SystemPropertyResourceDefinition(location, null, true);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)VALUE, null, (OperationStepHandler)new SystemPropertyValueWriteAttributeHandler(this.systemPropertyUpdater, (AttributeDefinition)VALUE));
        if (this.useBoottime) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)BOOT_TIME, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{BOOT_TIME}));
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.sensitivity;
    }

    public static enum Location {
        STANDALONE("server"),
        DOMAIN("domain"),
        HOST("host"),
        SERVER_CONFIG("server-config"),
        SERVER_GROUP("server-group");

        private String suffix;

        private Location(String suffix) {
            this.suffix = suffix;
        }

        String getSuffix() {
            return this.suffix;
        }
    }

    private static class ReplaceResourceNameResourceDescriptionResolver
    extends StandardResourceDescriptionResolver {
        Location location;

        public ReplaceResourceNameResourceDescriptionResolver(Location location, String keyPrefix) {
            super(keyPrefix, ServerDescriptions.RESOURCE_NAME, SecurityActions.getClassLoader(ServerDescriptions.class), true, false);
            this.location = location;
        }

        public String getResourceDescription(Locale locale, ResourceBundle bundle) {
            return bundle.getString("system-property." + this.location.getSuffix());
        }
    }
}

