/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.server.suspend.CountingRequestCountCallback;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestControllerState;
import org.wildfly.extension.requestcontroller.RunResult;
import org.wildfly.extension.requestcontroller.logging.RequestControllerLogger;

public class RequestController
implements Service<RequestController>,
ServerActivity {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "global-request-controller"});
    private static final AtomicIntegerFieldUpdater<RequestController> activeRequestCountUpdater = AtomicIntegerFieldUpdater.newUpdater(RequestController.class, "activeRequestCount");
    private static final AtomicReferenceFieldUpdater<RequestController, ServerActivityCallback> listenerUpdater = AtomicReferenceFieldUpdater.newUpdater(RequestController.class, ServerActivityCallback.class, "listener");
    private volatile int maxRequestCount = -1;
    private volatile int activeRequestCount = 0;
    private volatile boolean paused = false;
    private final Map<ControlPointIdentifier, ControlPoint> entryPoints = new HashMap<ControlPointIdentifier, ControlPoint>();
    private final InjectedValue<SuspendController> shutdownControllerInjectedValue = new InjectedValue();
    private volatile ServerActivityCallback listener = null;
    private Timer timer;
    private final Deque<QueuedTask> taskQueue = new LinkedBlockingDeque<QueuedTask>();

    public void preSuspend(ServerActivityCallback listener) {
        listener.done();
    }

    public synchronized void suspened(ServerActivityCallback requestCountListener) {
        this.paused = true;
        listenerUpdater.set(this, requestCountListener);
        if (activeRequestCountUpdater.get(this) == 0 && listenerUpdater.compareAndSet(this, requestCountListener, null)) {
            requestCountListener.done();
        }
    }

    public synchronized void resume() {
        this.paused = false;
        ServerActivityCallback listener = listenerUpdater.get(this);
        if (listener != null) {
            listenerUpdater.compareAndSet(this, listener, null);
        }
        while (!(this.taskQueue.isEmpty() || this.activeRequestCount >= this.maxRequestCount && this.maxRequestCount >= 0)) {
            this.runQueuedTask(false);
        }
    }

    public synchronized void pauseDeployment(String deployment, ServerActivityCallback listener) {
        ArrayList<ControlPoint> eps = new ArrayList<ControlPoint>();
        for (ControlPoint ep : this.entryPoints.values()) {
            if (!ep.getDeployment().equals(deployment) || ep.isPaused()) continue;
            eps.add(ep);
        }
        CountingRequestCountCallback realListener = new CountingRequestCountCallback(eps.size(), listener);
        for (ControlPoint ep : eps) {
            ep.pause((ServerActivityCallback)realListener);
        }
    }

    public synchronized void resumeDeployment(String deployment) {
        for (ControlPoint ep : this.entryPoints.values()) {
            if (!ep.getDeployment().equals(deployment)) continue;
            ep.resume();
        }
    }

    public synchronized void pauseControlPoint(String controlPoint, ServerActivityCallback listener) {
        ArrayList<ControlPoint> eps = new ArrayList<ControlPoint>();
        for (ControlPoint ep : this.entryPoints.values()) {
            if (!ep.getEntryPoint().equals(controlPoint) || ep.isPaused()) continue;
            eps.add(ep);
        }
        if (eps.isEmpty() && listener != null) {
            listener.done();
        }
        CountingRequestCountCallback realListener = new CountingRequestCountCallback(eps.size(), listener);
        for (ControlPoint ep : eps) {
            ep.pause((ServerActivityCallback)realListener);
        }
    }

    public synchronized void resumeControlPoint(String entryPoint) {
        for (ControlPoint ep : this.entryPoints.values()) {
            if (!ep.getEntryPoint().equals(entryPoint)) continue;
            ep.resume();
        }
    }

    public synchronized RequestControllerState getState() {
        ArrayList<RequestControllerState.EntryPointState> eps = new ArrayList<RequestControllerState.EntryPointState>();
        for (ControlPoint controlPoint : this.entryPoints.values()) {
            eps.add(new RequestControllerState.EntryPointState(controlPoint.getDeployment(), controlPoint.getEntryPoint(), controlPoint.isPaused(), controlPoint.getActiveRequestCount()));
        }
        return new RequestControllerState(this.paused, this.activeRequestCount, this.maxRequestCount, eps);
    }

    RunResult beginRequest() {
        int maxRequests = this.maxRequestCount;
        int active = activeRequestCountUpdater.get(this);
        boolean success = false;
        while (!(maxRequests > 0 && active >= maxRequests || this.paused)) {
            if (activeRequestCountUpdater.compareAndSet(this, active, active + 1)) {
                success = true;
                break;
            }
            active = activeRequestCountUpdater.get(this);
        }
        if (success) {
            if (this.paused) {
                this.requestComplete();
                return RunResult.REJECTED;
            }
            return RunResult.RUN;
        }
        return RunResult.REJECTED;
    }

    void requestComplete() {
        this.runQueuedTask(true);
    }

    private void decrementRequestCount() {
        ServerActivityCallback listener;
        int result = activeRequestCountUpdater.decrementAndGet(this);
        if (this.paused && this.paused && result == 0 && (listener = listenerUpdater.get(this)) != null && listenerUpdater.compareAndSet(this, listener, null)) {
            listener.done();
        }
    }

    public synchronized ControlPoint getControlPoint(String deploymentName, String entryPointName) {
        ControlPointIdentifier id = new ControlPointIdentifier(deploymentName, entryPointName);
        ControlPoint ep = this.entryPoints.get(id);
        if (ep == null) {
            ep = new ControlPoint(this, deploymentName, entryPointName);
            this.entryPoints.put(id, ep);
        }
        ep.increaseReferenceCount();
        return ep;
    }

    public synchronized void removeControlPoint(ControlPoint controlPoint) {
        if (controlPoint.decreaseReferenceCount() == 0) {
            ControlPointIdentifier id = new ControlPointIdentifier(controlPoint.getDeployment(), controlPoint.getEntryPoint());
            this.entryPoints.remove(id);
        }
    }

    public int getMaxRequestCount() {
        return this.maxRequestCount;
    }

    public void setMaxRequestCount(int maxRequestCount) {
        this.maxRequestCount = maxRequestCount;
        while (!(this.taskQueue.isEmpty() || this.activeRequestCount >= maxRequestCount && maxRequestCount >= 0)) {
            this.runQueuedTask(false);
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void start(StartContext startContext) throws StartException {
        ((SuspendController)this.shutdownControllerInjectedValue.getValue()).registerActivity((ServerActivity)this);
        this.timer = new Timer();
    }

    public void stop(StopContext stopContext) {
        ((SuspendController)this.shutdownControllerInjectedValue.getValue()).unRegisterActivity((ServerActivity)this);
        this.timer.cancel();
        this.timer = null;
        while (!this.taskQueue.isEmpty()) {
            QueuedTask t = this.taskQueue.poll();
            if (t == null) continue;
            t.run();
        }
    }

    public RequestController getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<SuspendController> getShutdownControllerInjectedValue() {
        return this.shutdownControllerInjectedValue;
    }

    public int getActiveRequestCount() {
        return this.activeRequestCount;
    }

    void queueTask(ControlPoint controlPoint, Runnable task, Executor taskExecutor, long timeout, Runnable timeoutTask, boolean rejectOnSuspend) {
        if (this.paused && rejectOnSuspend) {
            taskExecutor.execute(timeoutTask);
            return;
        }
        QueuedTask queuedTask = new QueuedTask(taskExecutor, task, timeoutTask, controlPoint);
        this.taskQueue.add(queuedTask);
        this.runQueuedTask(false);
        if (queuedTask.isQueued() && timeout > 0L) {
            this.timer.schedule((TimerTask)queuedTask, timeout);
        }
    }

    private void runQueuedTask(boolean hasPermit) {
        if (!hasPermit && this.beginRequest() == RunResult.REJECTED) {
            return;
        }
        QueuedTask task = this.taskQueue.poll();
        if (task != null) {
            if (!task.runRequest()) {
                this.decrementRequestCount();
            }
        } else {
            this.decrementRequestCount();
        }
    }

    private static final class QueuedTask
    extends TimerTask {
        private final Executor executor;
        private final Runnable task;
        private final Runnable cancelTask;
        private final ControlPoint controlPoint;
        private final AtomicInteger state = new AtomicInteger(0);

        private QueuedTask(Executor executor, Runnable task, Runnable cancelTask, ControlPoint controlPoint) {
            this.executor = executor;
            this.task = task;
            this.cancelTask = cancelTask;
            this.controlPoint = controlPoint;
        }

        @Override
        public void run() {
            if (this.state.compareAndSet(0, 2) && this.cancelTask != null) {
                try {
                    this.executor.execute(this.cancelTask);
                }
                catch (Exception e) {
                    RequestControllerLogger.ROOT_LOGGER.failedToCancelTask(this.cancelTask, e);
                }
            }
        }

        public boolean runRequest() {
            if (this.state.compareAndSet(0, 1)) {
                this.cancel();
                this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            QueuedTask.this.controlPoint.beginExistingRequest();
                            QueuedTask.this.task.run();
                        }
                        finally {
                            QueuedTask.this.controlPoint.requestComplete();
                        }
                    }
                });
                return true;
            }
            return false;
        }

        boolean isQueued() {
            return this.state.get() == 0;
        }
    }

    private static final class ControlPointIdentifier {
        private final String deployment;
        private final String name;

        private ControlPointIdentifier(String deployment, String name) {
            this.deployment = deployment;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ControlPointIdentifier that = (ControlPointIdentifier)o;
            if (this.deployment != null ? !this.deployment.equals(that.deployment) : that.deployment != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.deployment != null ? this.deployment.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return super.toString();
        }
    }
}

