/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.requestcontroller.RequestControllerDeploymentUnitProcessor;
import org.wildfly.extension.requestcontroller.RequestControllerRootDefinition;

class RequestControllerSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private final RequestController requestController;

    RequestControllerSubsystemAdd(RequestController requestController) {
        super(RequestControllerRootDefinition.ATTRIBUTES);
        this.requestController = requestController;
    }

    public void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("request-controller", Phase.STRUCTURE, 8192, (DeploymentUnitProcessor)new RequestControllerDeploymentUnitProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        int maxRequests = RequestControllerRootDefinition.MAX_REQUESTS.resolveModelAttribute(context, resource.getModel()).asInt();
        this.requestController.setMaxRequestCount(maxRequests);
        context.getServiceTarget().addService(RequestController.SERVICE_NAME, (Service)this.requestController).addDependency(SuspendController.SERVICE_NAME, SuspendController.class, this.requestController.getShutdownControllerInjectedValue()).install();
    }
}

