/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.requestcontroller.ActiveRequestsReadHandler;
import org.wildfly.extension.requestcontroller.MaxRequestsWriteHandler;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.requestcontroller.RequestControllerExtension;
import org.wildfly.extension.requestcontroller.RequestControllerSubsystemAdd;

class RequestControllerRootDefinition
extends PersistentResourceDefinition {
    static final PersistentResourceDefinition[] CHILDREN = new PersistentResourceDefinition[0];
    private final RequestController requestController;
    public static final SimpleAttributeDefinition MAX_REQUESTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-requests", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).build();
    public static final SimpleAttributeDefinition ACTIVE_REQUESTS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"active-requests", (ModelType)ModelType.INT, (boolean)true).setStorageRuntime()).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MAX_REQUESTS};
    static final RequestControllerRootDefinition INSTANCE = new RequestControllerRootDefinition(new RequestController());

    private RequestControllerRootDefinition(RequestController requestController) {
        super(RequestControllerExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)RequestControllerExtension.getResolver(new String[0]), (OperationStepHandler)new RequestControllerSubsystemAdd(requestController), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.requestController = requestController;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Collections.singletonList(MAX_REQUESTS);
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Arrays.asList(CHILDREN);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        MaxRequestsWriteHandler handler = new MaxRequestsWriteHandler((AttributeDefinition)MAX_REQUESTS, this.requestController);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)MAX_REQUESTS, null, (OperationStepHandler)handler);
        resourceRegistration.registerMetric((AttributeDefinition)ACTIVE_REQUESTS, (OperationStepHandler)new ActiveRequestsReadHandler(this.requestController));
    }
}

