/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import io.undertow.server.ListenerRegistry;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import java.io.IOException;
import java.util.function.Consumer;
import javax.security.sasl.SaslServerFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.as.remoting.SimpleHttpUpgradeHandshake;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.spi.ExternalConnectionProvider;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.sasl.anonymous.AnonymousServerFactory;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;

public class RemotingHttpUpgradeService
implements Service<RemotingHttpUpgradeService> {
    public static final String JBOSS_REMOTING = "jboss-remoting";
    public static final String MAGIC_NUMBER = "CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD";
    public static final String SEC_JBOSS_REMOTING_KEY = "Sec-JbossRemoting-Key";
    public static final String SEC_JBOSS_REMOTING_ACCEPT = "Sec-JbossRemoting-Accept";
    public static final ServiceName HTTP_UPGRADE_REGISTRY = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry"});
    public static final ServiceName UPGRADE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"remoting", "remoting-http-upgrade-service"});
    private final String httpConnectorName;
    private final String endpointName;
    private final InjectedValue<ChannelUpgradeHandler> injectedRegistry = new InjectedValue();
    private final InjectedValue<ListenerRegistry> listenerRegistry = new InjectedValue();
    private final InjectedValue<Endpoint> injectedEndpoint = new InjectedValue();
    private final InjectedValue<org.jboss.as.domain.management.SecurityRealm> injectedSecurityRealm = new InjectedValue();
    private final InjectedValue<SaslAuthenticationFactory> injectedSaslAuthenticationFactory = new InjectedValue();
    private final OptionMap connectorPropertiesOptionMap;
    private ListenerRegistry.HttpUpgradeMetadata httpUpgradeMetadata;

    public RemotingHttpUpgradeService(String httpConnectorName, String endpointName, OptionMap connectorPropertiesOptionMap) {
        this.httpConnectorName = httpConnectorName;
        this.endpointName = endpointName;
        this.connectorPropertiesOptionMap = connectorPropertiesOptionMap;
    }

    public static void installServices(OperationContext context, String remotingConnectorName, String httpConnectorName, ServiceName endpointName, OptionMap connectorPropertiesOptionMap, String securityRealm, String saslAuthenticationFactory) {
        ServiceTarget serviceTarget = context.getServiceTarget();
        RemotingHttpUpgradeService service = new RemotingHttpUpgradeService(httpConnectorName, endpointName.getSimpleName(), connectorPropertiesOptionMap);
        ServiceBuilder serviceBuilder = serviceTarget.addService(UPGRADE_SERVICE_NAME.append(new String[]{remotingConnectorName}), (Service)service).setInitialMode(ServiceController.Mode.PASSIVE).addDependency(HTTP_UPGRADE_REGISTRY.append(new String[]{httpConnectorName}), ChannelUpgradeHandler.class, service.injectedRegistry).addDependency(HttpListenerRegistryService.SERVICE_NAME, ListenerRegistry.class, service.listenerRegistry).addDependency(endpointName, Endpoint.class, service.injectedEndpoint);
        if (securityRealm != null) {
            serviceBuilder.addDependency(SecurityRealm.ServiceUtil.createServiceName((String)securityRealm), org.jboss.as.domain.management.SecurityRealm.class, service.injectedSecurityRealm);
        }
        if (saslAuthenticationFactory != null) {
            serviceBuilder.addDependency(context.getCapabilityServiceName("org.wildfly.security.sasl-authentication-factory", saslAuthenticationFactory, SaslAuthenticationFactory.class), SaslAuthenticationFactory.class, service.injectedSaslAuthenticationFactory);
        }
        serviceBuilder.install();
    }

    public synchronized void start(StartContext context) throws StartException {
        Endpoint endpoint = (Endpoint)this.injectedEndpoint.getValue();
        OptionMap.Builder builder = OptionMap.builder();
        ListenerRegistry.Listener listenerInfo = ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpConnectorName);
        assert (listenerInfo != null);
        this.httpUpgradeMetadata = new ListenerRegistry.HttpUpgradeMetadata(JBOSS_REMOTING, this.endpointName);
        listenerInfo.addHttpUpgradeMetadata(this.httpUpgradeMetadata);
        RemotingConnectorBindingInfoService.install(context.getChildTarget(), context.getController().getName().getSimpleName(), (SocketBinding)listenerInfo.getContextInformation("socket-binding"), listenerInfo.getProtocol().equals("https") ? Protocol.REMOTE_HTTPS : Protocol.REMOTE_HTTP);
        if (this.connectorPropertiesOptionMap != null) {
            builder.addAll(this.connectorPropertiesOptionMap);
        }
        OptionMap resultingMap = builder.getMap();
        try {
            ExternalConnectionProvider provider = (ExternalConnectionProvider)endpoint.getConnectionProviderInterface(Protocol.HTTP_REMOTING.toString(), ExternalConnectionProvider.class);
            SaslAuthenticationFactory saslAuthenticationFactory = (SaslAuthenticationFactory)this.injectedSaslAuthenticationFactory.getOptionalValue();
            org.jboss.as.domain.management.SecurityRealm securityRealm = null;
            if (saslAuthenticationFactory == null && (securityRealm = (org.jboss.as.domain.management.SecurityRealm)this.injectedSecurityRealm.getOptionalValue()) != null) {
                saslAuthenticationFactory = securityRealm.getSaslAuthenticationFactory();
            }
            if (saslAuthenticationFactory == null) {
                RemotingLogger.ROOT_LOGGER.warn("****** All authentication is ANONYMOUS for " + this.getClass().getName());
                SecurityDomain.Builder domainBuilder = SecurityDomain.builder();
                domainBuilder.addRealm("default", SecurityRealm.EMPTY_REALM).build();
                domainBuilder.setDefaultRealmName("default");
                domainBuilder.setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance());
                SaslAuthenticationFactory.Builder authBuilder = SaslAuthenticationFactory.builder();
                authBuilder.setSecurityDomain(domainBuilder.build());
                authBuilder.setFactory((SaslServerFactory)new AnonymousServerFactory());
                authBuilder.setMechanismConfigurationSelector(mechanismInformation -> MechanismConfiguration.EMPTY);
                saslAuthenticationFactory = authBuilder.build();
            }
            final Consumer adaptor = provider.createConnectionAdaptor(resultingMap, saslAuthenticationFactory);
            ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).addProtocol(JBOSS_REMOTING, (ChannelListener)new ChannelListener<StreamConnection>(){

                public void handleEvent(StreamConnection channel) {
                    adaptor.accept(channel);
                }
            }, (HttpUpgradeHandshake)new SimpleHttpUpgradeHandshake(MAGIC_NUMBER, SEC_JBOSS_REMOTING_KEY, SEC_JBOSS_REMOTING_ACCEPT));
        }
        catch (UnknownURISchemeException e) {
            throw new StartException((Throwable)e);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpConnectorName).removeHttpUpgradeMetadata(this.httpUpgradeMetadata);
        this.httpUpgradeMetadata = null;
        ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).removeProtocol(JBOSS_REMOTING);
    }

    public synchronized RemotingHttpUpgradeService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

