/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.MatchRule;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;

public class RemoteOutboundConnectionService
extends AbstractOutboundConnectionService<RemoteOutboundConnectionService> {
    public static final ServiceName REMOTE_OUTBOUND_CONNECTION_BASE_SERVICE_NAME = RemotingServices.SUBSYSTEM_ENDPOINT.append(new String[]{"remote-outbound-connection"});
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final InjectedValue<OutboundSocketBinding> destinationOutboundSocketBindingInjectedValue = new InjectedValue();
    private final InjectedValue<SecurityRealm> securityRealmInjectedValue = new InjectedValue();
    private final InjectedValue<AuthenticationContext> authenticationContext = new InjectedValue();
    private final String username;
    private final String protocol;

    public RemoteOutboundConnectionService(String connectionName, OptionMap connectionCreationOptions, String username, String protocol) {
        super(connectionName, connectionCreationOptions);
        this.username = username;
        this.protocol = protocol;
    }

    @Override
    public IoFuture<Connection> connect() throws IOException {
        URI uri;
        try {
            uri = this.getConnectionURI();
        }
        catch (URISyntaxException e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotConnect(e);
        }
        Endpoint endpoint = (Endpoint)this.endpointInjectedValue.getValue();
        AuthenticationContext authenticationContext = (AuthenticationContext)this.authenticationContext.getOptionalValue();
        OptionMap.Builder builder = OptionMap.builder();
        if (authenticationContext == null) {
            CallbackHandlerFactory cbhFactory;
            AuthenticationContext captured = AuthenticationContext.captureCurrent();
            AuthenticationConfiguration mergedConfiguration = AUTH_CONFIGURATION_CLIENT.getAuthenticationConfiguration(uri, captured);
            SSLContext sslContext = null;
            SecurityRealm realm = (SecurityRealm)this.securityRealmInjectedValue.getOptionalValue();
            CallbackHandler callbackHandler = realm != null && (cbhFactory = realm.getSecretCallbackHandlerFactory()) != null && this.username != null ? cbhFactory.getCallbackHandler(this.username) : null;
            if (realm != null) {
                sslContext = realm.getSSLContext();
            }
            if (callbackHandler != null) {
                mergedConfiguration = mergedConfiguration.useCallbackHandler(callbackHandler);
            }
            builder.set(Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE);
            builder.set(Options.SASL_POLICY_NOPLAINTEXT, (Object)Boolean.FALSE);
            builder.set(Options.SASL_DISALLOWED_MECHANISMS, (Object)Sequence.of((Object[])new String[]{JBOSS_LOCAL_USER}));
            Protocol protocol = Protocol.forName(uri.getScheme());
            switch (protocol) {
                case HTTP_REMOTING: 
                case REMOTE_HTTP: {
                    builder.set(Options.SSL_ENABLED, false);
                    break;
                }
                case HTTPS_REMOTING: 
                case REMOTE_HTTPS: {
                    builder.set(Options.SSL_ENABLED, true);
                    builder.set(Options.SSL_STARTTLS, false);
                    break;
                }
                default: {
                    builder.set(Options.SSL_ENABLED, true);
                    builder.set(Options.SSL_STARTTLS, true);
                }
            }
            authenticationContext = AuthenticationContext.empty().with(MatchRule.ALL, mergedConfiguration);
            if (sslContext != null) {
                SSLContext theSslConect = sslContext;
                authenticationContext = authenticationContext.withSsl(MatchRule.ALL, () -> theSslConect);
            }
        }
        builder.addAll(this.connectionCreationOptions);
        return endpoint.connect(uri, builder.getMap(), authenticationContext);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    Injector<OutboundSocketBinding> getDestinationOutboundSocketBindingInjector() {
        return this.destinationOutboundSocketBindingInjectedValue;
    }

    Injector<SecurityRealm> getSecurityRealmInjector() {
        return this.securityRealmInjectedValue;
    }

    Injector<AuthenticationContext> getAuthenticationContextInjector() {
        return this.authenticationContext;
    }

    private synchronized URI getConnectionURI() throws IOException, URISyntaxException {
        OutboundSocketBinding destinationOutboundSocket = (OutboundSocketBinding)this.destinationOutboundSocketBindingInjectedValue.getValue();
        InetAddress destinationAddress = destinationOutboundSocket.getResolvedDestinationAddress();
        int port = destinationOutboundSocket.getDestinationPort();
        return new URI(this.protocol + "://" + NetworkUtils.formatPossibleIpv6Address((String)destinationAddress.getHostAddress()) + ":" + port);
    }

    public RemoteOutboundConnectionService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

