/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.EndpointConfigFactory;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

class RemotingSubsystemAdd
extends AbstractAddStepHandler {
    RemotingSubsystemAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        if (context.getProcessType().isServer()) {
            ModelNode model = resource.getModel();
            String workerName = RemotingSubsystemRootResource.WORKER.resolveModelAttribute(context, model).asStringOrNull();
            CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(RemotingSubsystemRootResource.REMOTING_ENDPOINT_CAPABILITY);
            Consumer endpointConsumer = builder.provides(RemotingSubsystemRootResource.REMOTING_ENDPOINT_CAPABILITY);
            OptionMap map = EndpointConfigFactory.populate((ExpressionResolver)context, model);
            String nodeName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
            Supplier workerSupplier = builder.requiresCapability("org.wildfly.io.worker", XnioWorker.class, new String[]{workerName});
            builder.setInstance((Service)new EndpointService(endpointConsumer, workerSupplier, nodeName, EndpointService.EndpointType.SUBSYSTEM, map)).install();
        }
    }
}

