/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLDescriptionReader;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.GenericOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.HttpConnectorResource;
import org.jboss.as.remoting.LocalOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.PropertyResource;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemotingSubsystemModel;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.RemotingSubsystemSchema;
import org.jboss.as.remoting.SaslPolicyResource;
import org.jboss.as.remoting.SaslResource;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.IntVersion;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class RemotingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "remoting";
    private static final String RESOURCE_NAME = RemotingExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final String NODE_NAME_PROPERTY = "jboss.node.name";
    private static final SensitivityClassification REMOTING_SECURITY = new SensitivityClassification("remoting", "remoting-security", false, true, true);
    static final SensitiveTargetAccessConstraintDefinition REMOTING_SECURITY_DEF = new SensitiveTargetAccessConstraintDefinition(REMOTING_SECURITY);
    private static final String IO_EXTENSION_MODULE = "org.wildfly.extension.io";
    private final PersistentResourceXMLDescription currentXMLDescription = RemotingSubsystemSchema.CURRENT.getXMLDescription();

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, RemotingExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, RemotingSubsystemModel.CURRENT.getVersion());
        registration.registerXMLElementWriter((XMLElementWriter)new PersistentResourceXMLDescriptionWriter(this.currentXMLDescription));
        RemotingSubsystemRootResource root = new RemotingSubsystemRootResource();
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel((ResourceDefinition)root);
        subsystem.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ManagementResourceRegistration connector = subsystem.registerSubModel((ResourceDefinition)new ConnectorResource());
        PropertyResource connectorPropertyResourceDefinition = new PropertyResource("connector");
        connector.registerSubModel((ResourceDefinition)connectorPropertyResourceDefinition);
        ManagementResourceRegistration sasl = connector.registerSubModel((ResourceDefinition)new SaslResource("connector"));
        sasl.registerSubModel((ResourceDefinition)new SaslPolicyResource("connector"));
        sasl.registerSubModel((ResourceDefinition)connectorPropertyResourceDefinition);
        ManagementResourceRegistration httpConnector = subsystem.registerSubModel((ResourceDefinition)new HttpConnectorResource());
        PropertyResource httpConnectorPropertyResourceDefinition = new PropertyResource("http-connector");
        httpConnector.registerSubModel((ResourceDefinition)httpConnectorPropertyResourceDefinition);
        ManagementResourceRegistration httpSasl = httpConnector.registerSubModel((ResourceDefinition)new SaslResource("http-connector"));
        httpSasl.registerSubModel((ResourceDefinition)new SaslPolicyResource("http-connector"));
        httpSasl.registerSubModel((ResourceDefinition)httpConnectorPropertyResourceDefinition);
        subsystem.registerSubModel((ResourceDefinition)new RemoteOutboundConnectionResourceDefinition());
        subsystem.registerSubModel((ResourceDefinition)new LocalOutboundConnectionResourceDefinition());
        subsystem.registerSubModel((ResourceDefinition)new GenericOutboundConnectionResourceDefinition());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMappings(SUBSYSTEM_NAME, EnumSet.complementOf(EnumSet.of(RemotingSubsystemSchema.CURRENT)));
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, RemotingSubsystemSchema.CURRENT.getNamespace().getUri(), (XMLElementReader)new PersistentResourceXMLDescriptionReader(this.currentXMLDescription));
        if (context.getProcessType().isServer()) {
            context.setProfileParsingCompletionHandler((ProfileParsingCompletionHandler)new IOCompletionHandler());
        }
    }

    private static class IOCompletionHandler
    implements ProfileParsingCompletionHandler {
        private IOCompletionHandler() {
        }

        public void handleProfileParsingCompletion(Map<String, List<ModelNode>> profileBootOperations, List<ModelNode> otherBootOperations) {
            String legacyNS = null;
            List<ModelNode> legacyRemotingOps = null;
            for (Object schema : EnumSet.allOf(RemotingSubsystemSchema.class)) {
                String string;
                if (((IntVersion)schema.getNamespace().getVersion()).major() != 1 || (legacyRemotingOps = profileBootOperations.get(string = schema.getNamespace().getUri())) == null) continue;
                legacyNS = string;
                break;
            }
            if (legacyRemotingOps != null) {
                boolean foundIO = false;
                for (String string : profileBootOperations.keySet()) {
                    if (!string.startsWith("urn:jboss:domain:io:")) continue;
                    foundIO = true;
                    break;
                }
                if (!foundIO) {
                    boolean hasIoExtension = false;
                    for (ModelNode op : otherBootOperations) {
                        PathAddress pa = PathAddress.pathAddress((ModelNode)op.get("address"));
                        if (pa.size() != 1 || !"extension".equals(pa.getElement(0).getKey()) || !RemotingExtension.IO_EXTENSION_MODULE.equals(pa.getElement(0).getValue())) continue;
                        hasIoExtension = true;
                        break;
                    }
                    if (!hasIoExtension) {
                        ModelNode modelNode = Util.createAddOperation((PathAddress)PathAddress.pathAddress((String)"extension", (String)RemotingExtension.IO_EXTENSION_MODULE));
                        modelNode.get("module").set(RemotingExtension.IO_EXTENSION_MODULE);
                        otherBootOperations.add(modelNode);
                    }
                    PathAddress pathAddress = PathAddress.pathAddress((String)"subsystem", (String)"io");
                    legacyRemotingOps.add(Util.createAddOperation((PathAddress)pathAddress));
                    legacyRemotingOps.add(Util.createAddOperation((PathAddress)pathAddress.append("worker", "default")));
                    legacyRemotingOps.add(Util.createAddOperation((PathAddress)pathAddress.append("buffer-pool", "default")));
                    RemotingLogger.ROOT_LOGGER.addingIOSubsystem(legacyNS);
                }
            }
        }
    }
}

