/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.ConnectorUtils;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.xnio.OptionMap;

public class ConnectorAdd
extends AbstractAddStepHandler {
    static final ConnectorAdd INSTANCE = new ConnectorAdd();

    private ConnectorAdd() {
        super(ConnectorResource.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String connectorName = context.getCurrentAddressValue();
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        this.launchServices(context, connectorName, fullModel);
    }

    void launchServices(OperationContext context, String connectorName, ModelNode fullModel) throws OperationFailedException {
        OptionMap optionMap = ConnectorUtils.getFullOptions(context, fullModel);
        ServiceTarget target = context.getServiceTarget();
        String socketName = ConnectorResource.SOCKET_BINDING.resolveModelAttribute(context, fullModel).asString();
        ServiceName socketBindingName = context.getCapabilityServiceName("org.wildfly.network.socket-binding", socketName, SocketBinding.class);
        ModelNode securityRealmModel = ConnectorResource.SECURITY_REALM.resolveModelAttribute(context, fullModel);
        if (securityRealmModel.isDefined()) {
            throw RemotingLogger.ROOT_LOGGER.runtimeSecurityRealmUnsupported();
        }
        ModelNode saslAuthenticationFactoryModel = ConnectorResource.SASL_AUTHENTICATION_FACTORY.resolveModelAttribute(context, fullModel);
        ServiceName saslAuthenticationFactoryName = saslAuthenticationFactoryModel.isDefined() ? context.getCapabilityServiceName("org.wildfly.security.sasl-authentication-factory", saslAuthenticationFactoryModel.asString(), SaslAuthenticationFactory.class) : null;
        ModelNode sslContextModel = ConnectorResource.SSL_CONTEXT.resolveModelAttribute(context, fullModel);
        ServiceName sslContextName = sslContextModel.isDefined() ? context.getCapabilityServiceName("org.wildfly.security.ssl-context", sslContextModel.asString(), SSLContext.class) : null;
        ServiceName sbmName = context.getCapabilityServiceName("org.wildfly.management.socket-binding-manager", SocketBindingManager.class);
        RemotingServices.installConnectorServicesForSocketBinding(target, RemotingServices.SUBSYSTEM_ENDPOINT, connectorName, socketBindingName, optionMap, saslAuthenticationFactoryName, sslContextName, sbmName);
    }
}

