/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting.logging;

import java.io.IOException;
import java.net.BindException;
import java.net.URISyntaxException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYRMT", length=4)
public interface RemotingLogger
extends BasicLogger {
    public static final RemotingLogger ROOT_LOGGER = (RemotingLogger)Logger.getMessageLogger(RemotingLogger.class, (String)"org.jboss.as.remoting");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Listening on %s")
    public void listeningOnSocket(String var1);

    @Message(id=2, value="Could not start channel listener")
    public StartException couldNotStartChanelListener(@Cause Exception var1);

    @Message(id=4, value="%s")
    public StartException couldNotBindToSocket(String var1, @Cause BindException var2);

    @Message(id=5, value="Failed to start service")
    public StartException couldNotStart(@Cause Exception var1);

    @Message(id=6, value="Endpoint is null")
    public IllegalStateException endpointEmpty();

    @Message(id=7, value="Connection name cannot be null or empty")
    public IllegalStateException connectionNameEmpty();

    @Message(id=8, value="Connection URI cannot be null for connection named: %s")
    public IllegalStateException connectionUriEmpty(String var1);

    @Message(id=9, value="Outbound socket binding reference cannot be null or empty for connection named: %s")
    public IllegalStateException outboundSocketBindingEmpty(String var1);

    @Message(id=10, value="Destination URI cannot be null while creating an outbound remote connection service")
    public IllegalStateException destinationUriEmpty();

    @Message(id=11, value="A security realm has been specified but no supported mechanism identified")
    public IllegalStateException noSupportingMechanismsForRealm();

    @Message(id=12, value="ANONYMOUS mechanism so not expecting a callback")
    public UnsupportedCallbackException anonymousMechanismNotExpected(@Param Callback var1);

    @Message(id=13, value="Unable to create tmp dir for auth tokens as file already exists.")
    public StartException unableToCreateTempDirForAuthTokensFileExists();

    @Message(id=14, value="Unable to create auth dir %s.")
    public StartException unableToCreateAuthDir(String var1);

    @Message(id=15, value="Could not connect")
    public RuntimeException couldNotConnect(@Cause URISyntaxException var1);

    @Message(id=16, value="Invalid QOP value: %s")
    public IllegalStateException invalidQOPV(String var1);

    @Message(id=17, value="Invalid Strength value: %s")
    public IllegalStateException invalidStrength(String var1);

    @Message(id=18, value="Cannot create a valid URI from %s -- %s")
    public OperationFailedException couldNotCreateURI(String var1, String var2);

    @Message(id=19, value="Unsupported Callback")
    public UnsupportedCallbackException unsupportedCallback(@Param Callback var1);

    @Message(id=20, value="Invalid Strength '%s' string given")
    public IllegalArgumentException illegalStrength(String var1);

    @Message(id=21, value="HTTP Upgrade request missing Sec-JbossRemoting-Key header")
    public IOException upgradeRequestMissingKey();

    @Message(id=22, value="Worker configuration is no longer used, please use endpoint worker configuration")
    public OperationFailedException workerConfigurationIgnored();

    @Message(id=23, value="Only one of '%s' configuration or '%s' configuration is allowed")
    public String workerThreadsEndpointConfigurationChoiceRequired(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=24, value="The remoting subsystem is present but no io subsystem was found. An io subsystem was not required when remoting schema '%s' was current but now is, so a default subsystem is being added.")
    public void addingIOSubsystem(String var1);
}

