/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting.management;

import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.as.protocol.mgmt.support.ManagementChannelShutdownHandle;
import org.jboss.as.remoting.AbstractChannelOpenListenerService;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

class ManagementChannelOpenListenerService
extends AbstractChannelOpenListenerService {
    private final Supplier<ManagementChannelInitialization> operationHandlerFactorySupplier;
    private final Supplier<ExecutorService> executorServiceSupplier;

    ManagementChannelOpenListenerService(Supplier<ManagementChannelInitialization> operationHandlerFactorySupplier, Supplier<ExecutorService> executorServiceSupplier, Supplier<Endpoint> endpointSupplier, Supplier<ManagementChannelRegistryService> registrySupplier, String channelName, OptionMap optionMap) {
        super(endpointSupplier, registrySupplier, channelName, optionMap);
        this.operationHandlerFactorySupplier = operationHandlerFactorySupplier;
        this.executorServiceSupplier = executorServiceSupplier;
    }

    @Override
    protected ManagementChannelShutdownHandle handleChannelOpened(Channel channel) {
        ManagementChannelInitialization initialization = this.operationHandlerFactorySupplier.get();
        RemotingLogger.ROOT_LOGGER.tracef("Opened %s: %s with handler %s", this.channelName, channel, initialization);
        return initialization.startReceiving(channel);
    }

    @Override
    protected void execute(Runnable runnable) {
        this.executorServiceSupplier.get().execute(runnable);
    }
}

