/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import io.undertow.server.ListenerRegistry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.InjectedNetworkBindingStreamServerService;
import org.jboss.as.remoting.InjectedSocketBindingStreamServerService;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

public class RemotingServices {
    public static final ServiceName REMOTING_BASE = ServiceName.JBOSS.append(new String[]{"remoting"});
    public static final ServiceName SUBSYSTEM_ENDPOINT = RemotingSubsystemRootResource.REMOTING_ENDPOINT_CAPABILITY.getCapabilityServiceName(Endpoint.class);
    private static final ServiceName CONNECTOR_BASE = REMOTING_BASE.append(new String[]{"connector"});
    private static final ServiceName SERVER_BASE = REMOTING_BASE.append(new String[]{"server"});
    public static final ServiceName HTTP_LISTENER_REGISTRY = RemotingSubsystemRootResource.HTTP_LISTENER_REGISTRY_CAPABILITY.getCapabilityServiceName(ListenerRegistry.class);

    public static ServiceName connectorServiceName(String connectorName) {
        return CONNECTOR_BASE.append(new String[]{connectorName});
    }

    public static ServiceName serverServiceName(String connectorName) {
        return SERVER_BASE.append(new String[]{connectorName});
    }

    public static ServiceName channelServiceName(ServiceName endpointName, String channelName) {
        return endpointName.append(new String[]{"channel"}).append(new String[]{channelName});
    }

    public static void installRemotingManagementEndpoint(ServiceTarget serviceTarget, ServiceName endpointName, String hostName, EndpointService.EndpointType type) {
        RemotingServices.installRemotingManagementEndpoint(serviceTarget, endpointName, hostName, type, OptionMap.EMPTY);
    }

    public static void installRemotingManagementEndpoint(ServiceTarget serviceTarget, ServiceName endpointName, String hostName, EndpointService.EndpointType type, OptionMap options) {
        ServiceBuilder builder = serviceTarget.addService(endpointName);
        Consumer endpointConsumer = builder.provides(new ServiceName[]{endpointName});
        Supplier workerSupplier = builder.requires(ServiceName.JBOSS.append(new String[]{"serverManagement", "controller", "management", "worker"}));
        builder.setInstance((Service)new EndpointService(endpointConsumer, workerSupplier, hostName, type, options));
        builder.install();
    }

    @Deprecated
    public static void installConnectorServicesForNetworkInterfaceBinding(ServiceTarget serviceTarget, ServiceName endpointName, String connectorName, ServiceName networkInterfaceBindingName, int port, OptionMap connectorPropertiesOptionMap, ServiceName saslAuthenticationFactory, ServiceName sslContext, ServiceName socketBindingManager) {
        ServiceName serviceName = RemotingServices.serverServiceName(connectorName);
        ServiceBuilder builder = serviceTarget.addService(serviceName);
        Consumer streamServerConsumer = builder.provides(new ServiceName[]{serviceName});
        Supplier eSupplier = builder.requires(endpointName);
        Supplier safSupplier = saslAuthenticationFactory != null ? builder.requires(saslAuthenticationFactory) : null;
        Supplier scSupplier = sslContext != null ? builder.requires(sslContext) : null;
        Supplier sbmSupplier = socketBindingManager != null ? builder.requires(socketBindingManager) : null;
        Supplier ibSupplier = builder.requires(networkInterfaceBindingName);
        builder.setInstance((Service)new InjectedNetworkBindingStreamServerService(streamServerConsumer, eSupplier, safSupplier, scSupplier, sbmSupplier, ibSupplier, connectorPropertiesOptionMap, port));
        builder.install();
    }

    public static void installConnectorServicesForSocketBinding(ServiceTarget serviceTarget, ServiceName endpointName, String connectorName, ServiceName socketBindingName, OptionMap connectorPropertiesOptionMap, ServiceName saslAuthenticationFactory, ServiceName sslContext, ServiceName socketBindingManager) {
        ServiceName serviceName = RemotingServices.serverServiceName(connectorName);
        ServiceBuilder builder = serviceTarget.addService(serviceName);
        Consumer streamServerConsumer = builder.provides(new ServiceName[]{serviceName});
        Supplier eSupplier = builder.requires(endpointName);
        Supplier safSupplier = saslAuthenticationFactory != null ? builder.requires(saslAuthenticationFactory) : null;
        Supplier scSupplier = sslContext != null ? builder.requires(sslContext) : null;
        Supplier sbmSupplier = builder.requires(socketBindingManager);
        Supplier sbSupplier = builder.requires(socketBindingName);
        builder.setInstance((Service)new InjectedSocketBindingStreamServerService(streamServerConsumer, eSupplier, safSupplier, scSupplier, sbmSupplier, sbSupplier, connectorPropertiesOptionMap));
        builder.install();
    }

    public static void removeConnectorServices(OperationContext context, String connectorName) {
        context.removeService(RemotingServices.serverServiceName(connectorName));
    }
}

