/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.protocol.GeneralTimeoutHandler;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.ProtocolTimeoutHandler;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class ProtocolConnectionUtils {
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    private static final Map<String, String> QUIET_LOCAL_AUTH = Collections.singletonMap("wildfly.sasl.local-user.quiet-auth", "true");
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    public static IoFuture<Connection> connect(ProtocolConnectionConfiguration configuration) throws IOException {
        return ProtocolConnectionUtils.connect(configuration.getCallbackHandler(), configuration);
    }

    public static IoFuture<Connection> connect(ProtocolConnectionConfiguration configuration, CallbackHandler handler) throws IOException {
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy(configuration);
        config.setCallbackHandler(handler);
        return ProtocolConnectionUtils.connect(config);
    }

    public static IoFuture<Connection> connect(ProtocolConnectionConfiguration configuration, CallbackHandler handler, Map<String, String> saslOptions, SSLContext sslContext) throws IOException {
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy(configuration);
        config.setCallbackHandler(handler);
        config.setSaslOptions(saslOptions);
        config.setSslContext(sslContext);
        return ProtocolConnectionUtils.connect(config);
    }

    public static Connection connectSync(ProtocolConnectionConfiguration configuration) throws IOException {
        CallbackHandler actualHandler;
        long timeoutMillis = configuration.getConnectionTimeout();
        CallbackHandler handler = configuration.getCallbackHandler();
        ProtocolTimeoutHandler timeoutHandler = configuration.getTimeoutHandler();
        if (timeoutHandler == null) {
            GeneralTimeoutHandler defaultTimeoutHandler = new GeneralTimeoutHandler();
            actualHandler = handler != null ? new WrapperCallbackHandler(defaultTimeoutHandler, handler) : null;
            timeoutHandler = defaultTimeoutHandler;
        } else {
            actualHandler = handler;
        }
        IoFuture<Connection> future = ProtocolConnectionUtils.connect(actualHandler, configuration);
        IoFuture.Status status = timeoutHandler.await(future, timeoutMillis);
        if (status == IoFuture.Status.DONE) {
            return (Connection)future.get();
        }
        if (status == IoFuture.Status.FAILED) {
            throw ProtocolLogger.ROOT_LOGGER.failedToConnect(configuration.getUri(), future.getException());
        }
        throw ProtocolLogger.ROOT_LOGGER.couldNotConnect(configuration.getUri());
    }

    public static Connection connectSync(ProtocolConnectionConfiguration configuration, CallbackHandler handler) throws IOException {
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy(configuration);
        config.setCallbackHandler(handler);
        return ProtocolConnectionUtils.connectSync(config);
    }

    public static Connection connectSync(ProtocolConnectionConfiguration configuration, CallbackHandler handler, Map<String, String> saslOptions, SSLContext sslContext) throws IOException {
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy(configuration);
        config.setCallbackHandler(handler);
        config.setSaslOptions(saslOptions);
        config.setSslContext(sslContext);
        return ProtocolConnectionUtils.connectSync(config);
    }

    private static IoFuture<Connection> connect(CallbackHandler handler, ProtocolConnectionConfiguration configuration) throws IOException {
        SSLContext sslContext;
        configuration.validate();
        Endpoint endpoint = configuration.getEndpoint();
        URI uri = configuration.getUri();
        String clientBindAddress = configuration.getClientBindAddress();
        AuthenticationContext captured = AuthenticationContext.captureCurrent();
        AuthenticationConfiguration mergedConfiguration = AUTH_CONFIGURATION_CLIENT.getAuthenticationConfiguration(uri, captured);
        if (handler != null) {
            mergedConfiguration = mergedConfiguration.useCallbackHandler(handler);
        }
        Map<String, String> saslOptions = configuration.getSaslOptions();
        mergedConfiguration = ProtocolConnectionUtils.configureSaslMechanisms(saslOptions, ProtocolConnectionUtils.isLocal(uri), mergedConfiguration);
        if (saslOptions != null) {
            saslOptions = new HashMap<String, String>(saslOptions);
            saslOptions.remove(Options.SASL_DISALLOWED_MECHANISMS.getName());
            mergedConfiguration = mergedConfiguration.useMechanismProperties(saslOptions);
        }
        if ((sslContext = configuration.getSslContext()) == null) {
            try {
                sslContext = AUTH_CONFIGURATION_CLIENT.getSSLContext(uri, captured);
            }
            catch (GeneralSecurityException e) {
                throw ProtocolLogger.ROOT_LOGGER.failedToConnect(uri, e);
            }
        }
        OptionMap.Builder builder = OptionMap.builder();
        OptionMap optionMap = configuration.getOptionMap();
        for (Option option : optionMap) {
            builder.set(option, optionMap.get(option));
        }
        if (optionMap.get(Options.SSL_ENABLED) == null) {
            builder.set(Options.SSL_ENABLED, configuration.isSslEnabled());
        }
        if (optionMap.get(Options.SSL_STARTTLS) == null) {
            builder.set(Options.SSL_STARTTLS, configuration.isUseStartTLS());
        }
        AuthenticationContext authenticationContext = AuthenticationContext.empty();
        authenticationContext = authenticationContext.with(MatchRule.ALL, mergedConfiguration);
        SSLContext finalSslContext = sslContext;
        authenticationContext = authenticationContext.withSsl(MatchRule.ALL, () -> finalSslContext);
        if (clientBindAddress == null) {
            return endpoint.connect(uri, builder.getMap(), authenticationContext);
        }
        InetSocketAddress bindAddr = new InetSocketAddress(clientBindAddress, 0);
        return endpoint.connect(uri, bindAddr, builder.getMap(), authenticationContext);
    }

    private static AuthenticationConfiguration configureSaslMechanisms(Map<String, String> saslOptions, boolean isLocal, AuthenticationConfiguration authenticationConfiguration) {
        String listed;
        String[] mechanisms = null;
        if (saslOptions != null && (listed = saslOptions.get(Options.SASL_DISALLOWED_MECHANISMS.getName())) != null) {
            String[] split = listed.split(" ");
            if (isLocal) {
                mechanisms = new String[split.length + 1];
                mechanisms[0] = JBOSS_LOCAL_USER;
                System.arraycopy(split, 0, mechanisms, 1, split.length);
            } else {
                mechanisms = split;
            }
        } else if (!isLocal) {
            mechanisms = new String[]{JBOSS_LOCAL_USER};
        }
        return mechanisms != null && mechanisms.length > 0 ? authenticationConfiguration.setSaslMechanismSelector(SaslMechanismSelector.DEFAULT.forbidMechanisms(mechanisms)) : authenticationConfiguration;
    }

    private static boolean isLocal(URI uri) {
        try {
            NetworkInterface nic;
            String hostName = uri.getHost();
            InetAddress address = InetAddress.getByName(hostName);
            if (address.isLinkLocalAddress()) {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                nic = null;
                while (interfaces.hasMoreElements() && nic == null) {
                    NetworkInterface current = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = current.getInetAddresses();
                    while (addresses.hasMoreElements() && nic == null) {
                        InetAddress currentAddress = addresses.nextElement();
                        if (!address.equals(currentAddress)) continue;
                        nic = current;
                    }
                }
            } else {
                nic = NetworkInterface.getByInetAddress(address);
            }
            return address.isLoopbackAddress() || nic != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final class WrapperCallbackHandler
    implements CallbackHandler {
        private final GeneralTimeoutHandler timeoutHandler;
        private final CallbackHandler wrapped;

        WrapperCallbackHandler(GeneralTimeoutHandler timeoutHandler, CallbackHandler toWrap) {
            this.timeoutHandler = timeoutHandler;
            this.wrapped = toWrap;
        }

        @Override
        public void handle(final Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            try {
                this.timeoutHandler.suspendAndExecute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            wrapped.handle(callbacks);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        catch (UnsupportedCallbackException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof UnsupportedCallbackException) {
                    throw (UnsupportedCallbackException)e.getCause();
                }
                throw e;
            }
        }
    }
}

