/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.ManagementBatchIdManager;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.remoting3.Channel;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.xnio.Cancellable;

class ActiveOperationSupport {
    private static final Executor directExecutor = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    private static final ActiveOperation.CompletedCallback<?> NO_OP_CALLBACK = new ActiveOperation.CompletedCallback<Object>(){

        @Override
        public void completed(Object result) {
        }

        @Override
        public void failed(Exception e) {
        }

        @Override
        public void cancelled() {
        }
    };
    private final ConcurrentMap<Integer, ActiveOperationImpl<?, ?>> activeRequests = new ConcurrentHashMap(16, 0.75f, Runtime.getRuntime().availableProcessors());
    private final ManagementBatchIdManager operationIdManager = new ManagementBatchIdManager.DefaultManagementBatchIdManager();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private int activeCount = 0;
    private volatile boolean shutdown = false;
    private static final List<Cancellable> CANCEL_REQUESTED = Collections.emptyList();

    protected ActiveOperationSupport() {
    }

    static <T> ActiveOperation.CompletedCallback<T> getDefaultCallback() {
        return NO_OP_CALLBACK;
    }

    static <T> ActiveOperation.CompletedCallback<T> getCheckedCallback(ActiveOperation.CompletedCallback<T> callback) {
        if (callback == null) {
            return ActiveOperationSupport.getDefaultCallback();
        }
        return callback;
    }

    protected <T, A> ActiveOperation<T, A> registerActiveOperation(A attachment) {
        ActiveOperation.CompletedCallback<T> callback = ActiveOperationSupport.getDefaultCallback();
        return this.registerActiveOperation(attachment, callback);
    }

    protected <T, A> ActiveOperation<T, A> registerActiveOperation(A attachment, ActiveOperation.CompletedCallback<T> callback) {
        return this.registerActiveOperation(null, attachment, callback);
    }

    protected <T, A> ActiveOperation<T, A> registerActiveOperation(Integer id, A attachment) {
        ActiveOperation.CompletedCallback<T> callback = ActiveOperationSupport.getDefaultCallback();
        return this.registerActiveOperation(id, attachment, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, A> ActiveOperation<T, A> registerActiveOperation(Integer id, A attachment, ActiveOperation.CompletedCallback<T> callback) {
        this.lock.lock();
        try {
            Integer operationId;
            assert (!this.shutdown);
            if (id == null) {
                operationId = this.operationIdManager.createBatchId();
            } else {
                if (!this.operationIdManager.lockBatchId(id)) {
                    throw ProtocolLogger.ROOT_LOGGER.operationIdAlreadyExists(id);
                }
                operationId = id;
            }
            ActiveOperationImpl request = new ActiveOperationImpl(operationId, attachment, ActiveOperationSupport.getCheckedCallback(callback));
            ActiveOperation existing = this.activeRequests.putIfAbsent(operationId, request);
            if (existing != null) {
                throw ProtocolLogger.ROOT_LOGGER.operationIdAlreadyExists(operationId);
            }
            ++this.activeCount;
            ActiveOperationImpl activeOperationImpl = request;
            return activeOperationImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected <T, A> ActiveOperation<T, A> getActiveOperation(ManagementRequestHeader header) {
        return this.getActiveOperation(header.getBatchId());
    }

    protected <T, A> ActiveOperation<T, A> getActiveOperation(Integer id) {
        return (ActiveOperation)this.activeRequests.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, A> ActiveOperation<T, A> removeActiveOperation(Integer id) {
        this.lock.lock();
        try {
            ActiveOperation removed = (ActiveOperation)this.activeRequests.remove(id);
            if (removed != null) {
                --this.activeCount;
                this.operationIdManager.freeBatchId(id);
                this.condition.signalAll();
            }
            ActiveOperation activeOperation = removed;
            return activeOperation;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void handleChannelClosed(Channel closed, IOException e) {
        for (ActiveOperationImpl activeOperation : this.activeRequests.values()) {
            if (activeOperation.channel != closed) continue;
            activeOperation.getResultHandler().cancel();
        }
    }

    protected List<Integer> cancelAllActiveOperations() {
        ArrayList<Integer> operations = new ArrayList<Integer>();
        for (ActiveOperationImpl activeOperation : this.activeRequests.values()) {
            activeOperation.asyncCancel(false);
            operations.add(activeOperation.getOperationId());
        }
        return operations;
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        this.lock.lock();
        try {
            this.shutdown = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = unit.toMillis(timeout) + System.currentTimeMillis();
        this.lock.lock();
        try {
            assert (this.shutdown);
            while (this.activeCount != 0) {
                long remaining = deadline - System.currentTimeMillis();
                if (remaining <= 0L) {
                    boolean bl = this.activeCount == 0;
                    return bl;
                }
                this.condition.await(remaining, TimeUnit.MILLISECONDS);
            }
            boolean bl = this.activeCount == 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    static void updateChannelRef(ActiveOperation<?, ?> operation, Channel channel) {
        ActiveOperationImpl a;
        if (operation instanceof ActiveOperationImpl && (a = (ActiveOperationImpl)operation).channel == null) {
            a.channel = channel;
        }
    }

    protected class ActiveOperationImpl<T, A>
    extends AsyncFutureTask<T>
    implements ActiveOperation<T, A> {
        private final A attachment;
        private final Integer operationId;
        private List<Cancellable> cancellables;
        private volatile Channel channel;
        private final ActiveOperation.ResultHandler<T> completionHandler;

        private ActiveOperationImpl(final Integer operationId, A attachment, final ActiveOperation.CompletedCallback<T> callback) {
            super(directExecutor);
            this.completionHandler = new ActiveOperation.ResultHandler<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean done(T result) {
                    try {
                        boolean bl = ActiveOperationImpl.this.setResult(result);
                        return bl;
                    }
                    finally {
                        ActiveOperationSupport.this.removeActiveOperation(ActiveOperationImpl.this.operationId);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean failed(Exception e) {
                    try {
                        boolean failed = ActiveOperationImpl.this.setFailed(e);
                        if (failed) {
                            ProtocolLogger.ROOT_LOGGER.debugf(e, "active-op (%d) failed %s", ActiveOperationImpl.this.operationId, ActiveOperationImpl.this.attachment);
                        }
                        boolean bl = failed;
                        return bl;
                    }
                    finally {
                        ActiveOperationSupport.this.removeActiveOperation(ActiveOperationImpl.this.operationId);
                    }
                }

                @Override
                public void cancel() {
                    ProtocolLogger.CONNECTION_LOGGER.debugf("Operation (%d) cancelled", ActiveOperationImpl.this.operationId);
                    ActiveOperationImpl.this.cancel();
                }
            };
            this.operationId = operationId;
            this.attachment = attachment;
            this.addListener(new AsyncFuture.Listener<T, Object>(){

                public void handleComplete(AsyncFuture<? extends T> asyncFuture, Object attachment) {
                    try {
                        callback.completed(asyncFuture.get());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void handleFailed(AsyncFuture<? extends T> asyncFuture, Throwable cause, Object attachment) {
                    if (cause instanceof Exception) {
                        callback.failed((Exception)cause);
                    } else {
                        callback.failed(new RuntimeException(cause));
                    }
                }

                public void handleCancelled(AsyncFuture<? extends T> asyncFuture, Object attachment) {
                    ActiveOperationSupport.this.removeActiveOperation(operationId);
                    callback.cancelled();
                    ProtocolLogger.ROOT_LOGGER.debugf("cancelled operation (%d) attachment: (%s) this: %s.", ActiveOperationImpl.this.getOperationId(), ActiveOperationImpl.this.getAttachment(), ActiveOperationSupport.this);
                }
            }, null);
        }

        @Override
        public Integer getOperationId() {
            return this.operationId;
        }

        @Override
        public ActiveOperation.ResultHandler<T> getResultHandler() {
            return this.completionHandler;
        }

        @Override
        public A getAttachment() {
            return this.attachment;
        }

        @Override
        public AsyncFuture<T> getResult() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void asyncCancel(boolean interruptionDesired) {
            List<Cancellable> cancellables;
            ActiveOperationImpl activeOperationImpl = this;
            synchronized (activeOperationImpl) {
                cancellables = this.cancellables;
                if (cancellables == CANCEL_REQUESTED) {
                    return;
                }
                this.cancellables = CANCEL_REQUESTED;
                if (cancellables == null) {
                    this.setCancelled();
                    return;
                }
            }
            for (Cancellable cancellable : cancellables) {
                cancellable.cancel();
            }
            this.setCancelled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCancellable(Cancellable cancellable) {
            ActiveOperationImpl activeOperationImpl = this;
            synchronized (activeOperationImpl) {
                switch (this.getStatus()) {
                    case CANCELLED: {
                        break;
                    }
                    case WAITING: {
                        List<Cancellable> cancellables = this.cancellables;
                        if (cancellables == CANCEL_REQUESTED) break;
                        (cancellables == null ? (this.cancellables = new ArrayList<Cancellable>()) : cancellables).add(cancellable);
                    }
                    default: {
                        return;
                    }
                }
            }
            cancellable.cancel();
        }

        public boolean cancel() {
            return super.cancel(true);
        }
    }
}

