/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.net.ServerSocketFactory;
import org.jboss.as.process.logging.ProcessLogger;
import org.jboss.as.process.protocol.Connection;
import org.jboss.as.process.protocol.ConnectionHandler;
import org.jboss.as.process.protocol.ConnectionImpl;
import org.jboss.as.process.protocol.MessageHandler;
import org.jboss.as.process.protocol.StreamUtils;
import org.wildfly.common.Assert;

public final class ProtocolServer {
    private final ThreadFactory threadFactory;
    private final ServerSocketFactory socketFactory;
    private final ConnectionHandler connectionHandler;
    private final InetSocketAddress bindAddress;
    private final int backlog;
    private final int readTimeout;
    private final Executor readExecutor;
    private volatile boolean stop;
    private volatile Thread thread;
    private volatile ServerSocket serverSocket;
    private volatile InetSocketAddress boundAddress;
    private final Connection.ClosedCallback callback;

    public ProtocolServer(Configuration configuration) throws IOException {
        this.threadFactory = configuration.getThreadFactory();
        this.socketFactory = configuration.getSocketFactory();
        this.connectionHandler = configuration.getConnectionHandler();
        this.bindAddress = configuration.getBindAddress();
        this.backlog = configuration.getBacklog();
        this.readTimeout = configuration.getReadTimeout();
        this.readExecutor = configuration.getReadExecutor();
        this.callback = configuration.getClosedCallback();
        Assert.checkNotNullParam((String)"bindAddress", (Object)this.bindAddress);
        Assert.checkNotNullParam((String)"connectionHandler", (Object)this.connectionHandler);
    }

    public void start() throws IOException {
        ServerSocket serverSocket;
        this.stop = false;
        this.serverSocket = serverSocket = this.socketFactory.createServerSocket();
        this.thread = this.threadFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (!serverSocket.isClosed() && !ProtocolServer.this.stop) {
                        try {
                            Socket socket = serverSocket.accept();
                            boolean ok = false;
                            try {
                                socket.setSoTimeout(ProtocolServer.this.readTimeout);
                                ok = true;
                            }
                            finally {
                                if (!ok) {
                                    try {
                                        socket.close();
                                    }
                                    catch (IOException e) {
                                        ProcessLogger.PROTOCOL_CLIENT_LOGGER.failedToCloseSocket(e);
                                    }
                                }
                            }
                            ProtocolServer.this.safeHandleConnection(socket);
                        }
                        catch (SocketException e) {
                            if (ProtocolServer.this.stop) continue;
                            ProcessLogger.PROTOCOL_CLIENT_LOGGER.failedToAcceptConnection(e);
                        }
                        catch (IOException e) {
                            ProcessLogger.PROTOCOL_CLIENT_LOGGER.failedToAcceptConnection(e);
                        }
                    }
                }
                finally {
                    StreamUtils.safeClose(serverSocket);
                }
            }
        });
        if (this.thread == null) {
            throw ProcessLogger.ROOT_LOGGER.failedToCreateServerThread();
        }
        this.thread.setName("Accept thread");
        serverSocket.setReuseAddress(true);
        serverSocket.bind(this.bindAddress, this.backlog);
        this.boundAddress = (InetSocketAddress)serverSocket.getLocalSocketAddress();
        this.thread.start();
    }

    public void stop() {
        this.stop = true;
        Thread thread = this.thread;
        this.boundAddress = null;
        if (thread != null) {
            thread.interrupt();
        }
        StreamUtils.safeClose(this.serverSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeHandleConnection(Socket socket) {
        boolean ok = false;
        try {
            ConnectionImpl connection = new ConnectionImpl(socket, MessageHandler.NULL, this.readExecutor, this.callback);
            connection.setMessageHandler(this.connectionHandler.handleConnected(connection));
            Thread thread = this.threadFactory.newThread(connection.getReadTask());
            if (thread == null) {
                throw ProcessLogger.ROOT_LOGGER.threadCreationRefused();
            }
            thread.setName("Read thread for " + socket.getRemoteSocketAddress());
            thread.start();
            ok = true;
        }
        catch (IOException e) {
            ProcessLogger.PROTOCOL_CLIENT_LOGGER.failedToHandleIncomingConnection(e);
        }
        finally {
            if (!ok) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    ProcessLogger.PROTOCOL_CLIENT_LOGGER.failedToCloseSocket(e);
                }
            }
        }
    }

    public InetSocketAddress getBoundAddress() {
        return this.boundAddress;
    }

    public static final class Configuration {
        private ThreadFactory threadFactory;
        private ServerSocketFactory socketFactory;
        private ConnectionHandler connectionHandler;
        private MessageHandler messageHandler;
        private InetSocketAddress bindAddress;
        private int backlog;
        private int readTimeout;
        private Executor readExecutor;
        private Connection.ClosedCallback closedCallback;

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        public void setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        public ServerSocketFactory getSocketFactory() {
            return this.socketFactory;
        }

        public void setSocketFactory(ServerSocketFactory socketFactory) {
            this.socketFactory = socketFactory;
        }

        public ConnectionHandler getConnectionHandler() {
            return this.connectionHandler;
        }

        public void setConnectionHandler(ConnectionHandler connectionHandler) {
            this.connectionHandler = connectionHandler;
        }

        public MessageHandler getMessageHandler() {
            return this.messageHandler;
        }

        public void setMessageHandler(MessageHandler messageHandler) {
            this.messageHandler = messageHandler;
        }

        public InetSocketAddress getBindAddress() {
            return this.bindAddress;
        }

        public void setBindAddress(InetSocketAddress bindAddress) {
            this.bindAddress = bindAddress;
        }

        public int getBacklog() {
            return this.backlog;
        }

        public void setBacklog(int backlog) {
            this.backlog = backlog;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Executor getReadExecutor() {
            return this.readExecutor;
        }

        public void setReadExecutor(Executor readExecutor) {
            this.readExecutor = readExecutor;
        }

        public Connection.ClosedCallback getClosedCallback() {
            return this.closedCallback;
        }

        public void setCallback(Connection.ClosedCallback closedCallback) {
            this.closedCallback = closedCallback;
        }
    }
}

