/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process.logging;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import org.jboss.as.process.logging.ProcessLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

public class ProcessLogger_$logger
extends DelegatingBasicLogger
implements ProcessLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProcessLogger_$logger.class.getName();
    private static final String attemptToReconnectNonExistentProcess = "WFLYPC0001: Attempted to reconnect non-existent process '%s'";
    private static final String attemptToRemoveNonExistentProcess = "WFLYPC0002: Attempted to remove non-existent process '%s'";
    private static final String attemptToStartNonExistentProcess = "WFLYPC0003: Attempted to start non-existent process '%s'";
    private static final String attemptToStopNonExistentProcess = "WFLYPC0004: Attempted to stop non-existent process '%s'";
    private static final String duplicateProcessName = "WFLYPC0005: Attempted to register duplicate named process '%s'";
    private static final String failedToSendAuthKey = "WFLYPC0006: Failed to send authentication key to process '%s': %s";
    private static final String failedToSendDataBytes = "WFLYPC0007: Failed to send data bytes to process '%s' input stream";
    private static final String failedToSendReconnect = "WFLYPC0008: Failed to send reconnect message to process '%s' input stream";
    private static final String failedToStartProcess = "WFLYPC0009: Failed to start process '%s'";
    private static final String failedToWriteMessage = "WFLYPC0010: Failed to write %s message to connection: %s";
    private static final String processFinished = "WFLYPC0011: Process '%s' finished with an exit status of %d";
    private static final String receivedInvalidVersion = "WFLYPC0012: Received connection with invalid version from %s";
    private static final String receivedUnknownGreetingCode = "WFLYPC0013: Received unrecognized greeting code 0x%02x from %s";
    private static final String receivedUnknownCredentials = "WFLYPC0014: Received connection with unknown credentials from %s";
    private static final String receivedUnknownMessageCode = "WFLYPC0015: Received unknown message with code 0x%02x";
    private static final String shutdownComplete = "WFLYPC0016: All processes finished; exiting";
    private static final String shuttingDown = "WFLYPC0017: Shutting down process controller";
    private static final String startingProcess = "WFLYPC0018: Starting process '%s'";
    private static final String stoppingProcess = "WFLYPC0019: Stopping process '%s'";
    private static final String streamProcessingFailed = "WFLYPC0020: Stream processing failed for process '%s': %s";
    private static final String waitingToRestart = "WFLYPC0021: Waiting %d seconds until trying to restart process %s.";
    private static final String failedToKillProcess = "WFLYPC0022: Failed to kill process '%s', trying to destroy the process instead.";
    private static final String argUsage = "Usage: %s [args...]%nwhere args include:";
    private static final String argBackup = "Keep a copy of the persistent domain configuration even if this host is not the Domain Controller. If ignore-unused-configuration is unset in host.xml, then the complete domain configuration will be stored, otherwise the configured value of ignore-unused-configuration will be used.";
    private static final String argCachedDc = "If this host is not the Domain Controller and cannot contact the Domain Controller at boot, a locally cached copy of the domain configuration is used for boot (if available, see --backup.) The Domain Controller is background polled until it becomes available. Note that starting a host with --cached-dc when the Domain Controller is available will cache a copy of the domain configuration even if --backup is not used.";
    private static final String argDomainConfig = "Name of the domain configuration file to use (default is \"domain.xml\") (Same as -c)";
    private static final String argShortDomainConfig = "Name of the domain configuration file to use (default is \"domain.xml\") (Same as --domain-config)";
    private static final String argReadOnlyDomainConfig = "Name of the domain configuration file to use. This differs from '--domain-config', '-c' and '-domain-config' in that the initial file is never overwritten.";
    private static final String argHelp = "Display this message and exit";
    private static final String argInterProcessHcAddress = "Address on which the host controller should listen for communication from the process controller";
    private static final String argInterProcessHcPort = "Port on which the host controller should listen for communication from the process controller";
    private static final String argHostConfig = "Name of the host configuration file to use (default is \"host.xml\")";
    private static final String argReadOnlyHostConfig = "Name of the host configuration file to use. This differs from '--host-config' in that the initial file is never overwritten.";
    private static final String argPcAddress = "Address on which the process controller listens for communication from processes it controls";
    private static final String argPcPort = "Port on which the process controller listens for communication from processes it controls";
    private static final String argProperties = "Load system properties from the given url";
    private static final String argSystem = "Set a system property";
    private static final String argVersion = "Print version and exit";
    private static final String argPublicBindAddress = "Set system property jboss.bind.address to the given value";
    private static final String argInterfaceBindAddress = "Set system property jboss.bind.address.<interface> to the given value";
    private static final String argDefaultMulticastAddress = "Set system property jboss.default.multicast.address to the given value";
    private static final String argAdminOnly = "Set the host controller's running type to ADMIN_ONLY causing it to open administrative interfaces and accept management requests but not start servers or, if this host controller is the master for the domain, accept incoming connections from slave host controllers.";
    private static final String argMasterAddress = "Set system property jboss.domain.master.address to the given value. In a default slave Host Controller config, this is used to configure the address of the master Host Controller.";
    private static final String argMasterPort = "Set system property jboss.domain.master.port to the given value. In a default slave Host Controller config, this is used to configure the port used for native management communication by the master Host Controller.";
    private static final String argSecMgr = "Runs the server with a security manager installed.";
    private static final String noArgValue = "WFLYPC0023: No value was provided for argument %s";
    private static final String cannotFindJavaExe = "WFLYPC0024: Could not find java executable under %s.";
    private static final String invalidAuthKeyLen = "WFLYPC0025: Authentication key must be 24 bytes long";
    private static final String invalidCommandLen = "WFLYPC0026: cmd must have at least one entry";
    private static final String invalidJavaHome = "WFLYPC0027: Java home '%s' does not exist.";
    private static final String invalidJavaHomeBin = "WFLYPC0028: Java home's bin '%s' does not exist. The home directory was determined to be %s.";
    private static final String invalidLength = "WFLYPC0029: %s length is invalid";
    private static final String invalidOption = "WFLYPC0030: Invalid option: %s";
    private static final String nullCommandComponent = "WFLYPC0031: Command contains a null component";
    private static final String failedToAcceptConnection = "WFLYPC0033: Failed to accept a connection";
    private static final String failedToCloseResource = "WFLYPC0034: Failed to close resource %s";
    private static final String failedToCloseServerSocket = "WFLYPC0035: Failed to close the server socket %s";
    private static final String failedToCloseSocket = "WFLYPC0036: Failed to close a socket";
    private static final String failedToFinishMarshaller = "WFLYPC0037: Failed to finish the marshaller %s";
    private static final String failedToFinishUnmarshaller = "WFLYPC0038: Failed to finish the unmarshaller %s";
    private static final String failedToHandleIncomingConnection = "WFLYPC0039: Failed to handle incoming connection";
    private static final String failedToHandleSocketFailure = "WFLYPC0040: Failed to handle socket failure condition";
    private static final String failedToHandleSocketFinished = "WFLYPC0041: Failed to handle socket finished condition";
    private static final String failedToHandleSocketShutdown = "WFLYPC0042: Failed to handle socket shut down condition";
    private static final String failedToReadMessage = "WFLYPC0043: Failed to read a message";
    private static final String leakedMessageOutputStream = "WFLYPC0044: Leaked a message output stream; cleaning";
    private static final String failedToCreateServerThread = "WFLYPC0045: Failed to create server thread";
    private static final String failedToReadObject = "WFLYPC0046: Failed to read object";
    private static final String invalidByte0 = "WFLYPC0047: Invalid byte";
    private static final String invalidByte2 = "WFLYPC0048: Invalid byte:%s(%d)";
    private static final String invalidByteToken = "WFLYPC0049: Invalid byte token.  Expecting '%s' received '%s'";
    private static final String invalidCommandByte = "WFLYPC0050: Invalid command byte read: %s";
    private static final String invalidStartChunk = "WFLYPC0051: Invalid start chunk start [%s]";
    private static final String readBytes = "WFLYPC0056: Read %d bytes.";
    private static final String streamClosed = "WFLYPC0058: Stream closed";
    private static final String threadCreationRefused = "WFLYPC0059: Thread creation was refused";
    private static final String unexpectedEndOfStream = "WFLYPC0060: Unexpected end of stream";
    private static final String writeChannelClosed = "WFLYPC0061: Write channel closed";
    private static final String writesAlreadyShutdown = "WFLYPC0062: Writes are already shut down";

    public ProcessLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void attemptToReconnectNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.attemptToReconnectNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToReconnectNonExistentProcess$str() {
        return attemptToReconnectNonExistentProcess;
    }

    @Override
    public final void attemptToRemoveNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.attemptToRemoveNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToRemoveNonExistentProcess$str() {
        return attemptToRemoveNonExistentProcess;
    }

    @Override
    public final void attemptToStartNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.attemptToStartNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToStartNonExistentProcess$str() {
        return attemptToStartNonExistentProcess;
    }

    @Override
    public final void attemptToStopNonExistentProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.attemptToStopNonExistentProcess$str(), (Object)processName);
    }

    protected String attemptToStopNonExistentProcess$str() {
        return attemptToStopNonExistentProcess;
    }

    @Override
    public final void duplicateProcessName(String processName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.duplicateProcessName$str(), (Object)processName);
    }

    protected String duplicateProcessName$str() {
        return duplicateProcessName;
    }

    @Override
    public final void failedToSendAuthKey(String processName, Throwable error) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToSendAuthKey$str(), (Object)processName, (Object)error);
    }

    protected String failedToSendAuthKey$str() {
        return failedToSendAuthKey;
    }

    @Override
    public final void failedToSendDataBytes(Throwable cause, String processName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToSendDataBytes$str(), (Object)processName);
    }

    protected String failedToSendDataBytes$str() {
        return failedToSendDataBytes;
    }

    @Override
    public final void failedToSendReconnect(Throwable cause, String processName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToSendReconnect$str(), (Object)processName);
    }

    protected String failedToSendReconnect$str() {
        return failedToSendReconnect;
    }

    @Override
    public final void failedToStartProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failedToStartProcess$str(), (Object)processName);
    }

    protected String failedToStartProcess$str() {
        return failedToStartProcess;
    }

    @Override
    public final void failedToWriteMessage(String messageType, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failedToWriteMessage$str(), (Object)messageType, (Object)t);
    }

    protected String failedToWriteMessage$str() {
        return failedToWriteMessage;
    }

    @Override
    public final void processFinished(String processName, int exitCode) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.processFinished$str(), (Object)processName, (Object)exitCode);
    }

    protected String processFinished$str() {
        return processFinished;
    }

    @Override
    public final void receivedInvalidVersion(InetAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.receivedInvalidVersion$str(), (Object)address);
    }

    protected String receivedInvalidVersion$str() {
        return receivedInvalidVersion;
    }

    @Override
    public final void receivedUnknownGreetingCode(int code, InetAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.receivedUnknownGreetingCode$str(), (Object)code, (Object)address);
    }

    protected String receivedUnknownGreetingCode$str() {
        return receivedUnknownGreetingCode;
    }

    @Override
    public final void receivedUnknownCredentials(InetAddress address) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.receivedUnknownCredentials$str(), (Object)address);
    }

    protected String receivedUnknownCredentials$str() {
        return receivedUnknownCredentials;
    }

    @Override
    public final void receivedUnknownMessageCode(int code) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.receivedUnknownMessageCode$str(), (Object)code);
    }

    protected String receivedUnknownMessageCode$str() {
        return receivedUnknownMessageCode;
    }

    @Override
    public final void shutdownComplete() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shutdownComplete$str(), new Object[0]);
    }

    protected String shutdownComplete$str() {
        return shutdownComplete;
    }

    @Override
    public final void shuttingDown() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shuttingDown$str(), new Object[0]);
    }

    protected String shuttingDown$str() {
        return shuttingDown;
    }

    @Override
    public final void startingProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingProcess$str(), (Object)processName);
    }

    protected String startingProcess$str() {
        return startingProcess;
    }

    @Override
    public final void stoppingProcess(String processName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stoppingProcess$str(), (Object)processName);
    }

    protected String stoppingProcess$str() {
        return stoppingProcess;
    }

    @Override
    public final void streamProcessingFailed(String processName, Throwable error) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.streamProcessingFailed$str(), (Object)processName, (Object)error);
    }

    protected String streamProcessingFailed$str() {
        return streamProcessingFailed;
    }

    @Override
    public final void waitingToRestart(int seconds, String processName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.waitingToRestart$str(), (Object)seconds, (Object)processName);
    }

    protected String waitingToRestart$str() {
        return waitingToRestart;
    }

    @Override
    public final void failedToKillProcess(String process) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToKillProcess$str(), (Object)process);
    }

    protected String failedToKillProcess$str() {
        return failedToKillProcess;
    }

    protected String argUsage$str() {
        return argUsage;
    }

    @Override
    public final String argUsage(String executableName) {
        return String.format(this.argUsage$str(), executableName);
    }

    protected String argBackup$str() {
        return argBackup;
    }

    @Override
    public final String argBackup() {
        return String.format(this.argBackup$str(), new Object[0]);
    }

    protected String argCachedDc$str() {
        return argCachedDc;
    }

    @Override
    public final String argCachedDc() {
        return String.format(this.argCachedDc$str(), new Object[0]);
    }

    protected String argDomainConfig$str() {
        return argDomainConfig;
    }

    @Override
    public final String argDomainConfig() {
        return String.format(this.argDomainConfig$str(), new Object[0]);
    }

    protected String argShortDomainConfig$str() {
        return argShortDomainConfig;
    }

    @Override
    public final String argShortDomainConfig() {
        return String.format(this.argShortDomainConfig$str(), new Object[0]);
    }

    protected String argReadOnlyDomainConfig$str() {
        return argReadOnlyDomainConfig;
    }

    @Override
    public final String argReadOnlyDomainConfig() {
        return String.format(this.argReadOnlyDomainConfig$str(), new Object[0]);
    }

    protected String argHelp$str() {
        return argHelp;
    }

    @Override
    public final String argHelp() {
        return String.format(this.argHelp$str(), new Object[0]);
    }

    protected String argInterProcessHcAddress$str() {
        return argInterProcessHcAddress;
    }

    @Override
    public final String argInterProcessHcAddress() {
        return String.format(this.argInterProcessHcAddress$str(), new Object[0]);
    }

    protected String argInterProcessHcPort$str() {
        return argInterProcessHcPort;
    }

    @Override
    public final String argInterProcessHcPort() {
        return String.format(this.argInterProcessHcPort$str(), new Object[0]);
    }

    protected String argHostConfig$str() {
        return argHostConfig;
    }

    @Override
    public final String argHostConfig() {
        return String.format(this.argHostConfig$str(), new Object[0]);
    }

    protected String argReadOnlyHostConfig$str() {
        return argReadOnlyHostConfig;
    }

    @Override
    public final String argReadOnlyHostConfig() {
        return String.format(this.argReadOnlyHostConfig$str(), new Object[0]);
    }

    protected String argPcAddress$str() {
        return argPcAddress;
    }

    @Override
    public final String argPcAddress() {
        return String.format(this.argPcAddress$str(), new Object[0]);
    }

    protected String argPcPort$str() {
        return argPcPort;
    }

    @Override
    public final String argPcPort() {
        return String.format(this.argPcPort$str(), new Object[0]);
    }

    protected String argProperties$str() {
        return argProperties;
    }

    @Override
    public final String argProperties() {
        return String.format(this.argProperties$str(), new Object[0]);
    }

    protected String argSystem$str() {
        return argSystem;
    }

    @Override
    public final String argSystem() {
        return String.format(this.argSystem$str(), new Object[0]);
    }

    protected String argVersion$str() {
        return argVersion;
    }

    @Override
    public final String argVersion() {
        return String.format(this.argVersion$str(), new Object[0]);
    }

    protected String argPublicBindAddress$str() {
        return argPublicBindAddress;
    }

    @Override
    public final String argPublicBindAddress() {
        return String.format(this.argPublicBindAddress$str(), new Object[0]);
    }

    protected String argInterfaceBindAddress$str() {
        return argInterfaceBindAddress;
    }

    @Override
    public final String argInterfaceBindAddress() {
        return String.format(this.argInterfaceBindAddress$str(), new Object[0]);
    }

    protected String argDefaultMulticastAddress$str() {
        return argDefaultMulticastAddress;
    }

    @Override
    public final String argDefaultMulticastAddress() {
        return String.format(this.argDefaultMulticastAddress$str(), new Object[0]);
    }

    protected String argAdminOnly$str() {
        return argAdminOnly;
    }

    @Override
    public final String argAdminOnly() {
        return String.format(this.argAdminOnly$str(), new Object[0]);
    }

    protected String argMasterAddress$str() {
        return argMasterAddress;
    }

    @Override
    public final String argMasterAddress() {
        return String.format(this.argMasterAddress$str(), new Object[0]);
    }

    protected String argMasterPort$str() {
        return argMasterPort;
    }

    @Override
    public final String argMasterPort() {
        return String.format(this.argMasterPort$str(), new Object[0]);
    }

    protected String argSecMgr$str() {
        return argSecMgr;
    }

    @Override
    public final String argSecMgr() {
        return String.format(this.argSecMgr$str(), new Object[0]);
    }

    protected String noArgValue$str() {
        return noArgValue;
    }

    @Override
    public final String noArgValue(String argument) {
        return String.format(this.noArgValue$str(), argument);
    }

    protected String cannotFindJavaExe$str() {
        return cannotFindJavaExe;
    }

    @Override
    public final IllegalStateException cannotFindJavaExe(String binDir) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotFindJavaExe$str(), binDir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAuthKeyLen$str() {
        return invalidAuthKeyLen;
    }

    @Override
    public final IllegalArgumentException invalidAuthKeyLen() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidAuthKeyLen$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCommandLen$str() {
        return invalidCommandLen;
    }

    @Override
    public final IllegalArgumentException invalidCommandLen() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidCommandLen$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJavaHome$str() {
        return invalidJavaHome;
    }

    @Override
    public final IllegalStateException invalidJavaHome(String dir) {
        IllegalStateException result = new IllegalStateException(String.format(this.invalidJavaHome$str(), dir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJavaHomeBin$str() {
        return invalidJavaHomeBin;
    }

    @Override
    public final IllegalStateException invalidJavaHomeBin(String binDir, String javaHomeDir) {
        IllegalStateException result = new IllegalStateException(String.format(this.invalidJavaHomeBin$str(), binDir, javaHomeDir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidLength$str() {
        return invalidLength;
    }

    @Override
    public final IllegalArgumentException invalidLength(String parameterName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidLength$str(), parameterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidOption$str() {
        return invalidOption;
    }

    @Override
    public final IllegalArgumentException invalidOption(String option) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidOption$str(), option));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullCommandComponent$str() {
        return nullCommandComponent;
    }

    @Override
    public final IllegalArgumentException nullCommandComponent() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullCommandComponent$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void failedToAcceptConnection(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToAcceptConnection$str(), new Object[0]);
    }

    protected String failedToAcceptConnection$str() {
        return failedToAcceptConnection;
    }

    @Override
    public final void failedToCloseResource(Throwable cause, Object resource) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseResource$str(), resource);
    }

    protected String failedToCloseResource$str() {
        return failedToCloseResource;
    }

    @Override
    public final void failedToCloseServerSocket(Throwable cause, ServerSocket socket) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseServerSocket$str(), (Object)socket);
    }

    protected String failedToCloseServerSocket$str() {
        return failedToCloseServerSocket;
    }

    @Override
    public final void failedToCloseSocket(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseSocket$str(), new Object[0]);
    }

    protected String failedToCloseSocket$str() {
        return failedToCloseSocket;
    }

    @Override
    public final void failedToFinishMarshaller(Throwable cause, Marshaller marshaller) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToFinishMarshaller$str(), (Object)marshaller);
    }

    protected String failedToFinishMarshaller$str() {
        return failedToFinishMarshaller;
    }

    @Override
    public final void failedToFinishUnmarshaller(Throwable cause, Unmarshaller unmarshaller) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToFinishUnmarshaller$str(), (Object)unmarshaller);
    }

    protected String failedToFinishUnmarshaller$str() {
        return failedToFinishUnmarshaller;
    }

    @Override
    public final void failedToHandleIncomingConnection(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToHandleIncomingConnection$str(), new Object[0]);
    }

    protected String failedToHandleIncomingConnection$str() {
        return failedToHandleIncomingConnection;
    }

    @Override
    public final void failedToHandleSocketFailure(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToHandleSocketFailure$str(), new Object[0]);
    }

    protected String failedToHandleSocketFailure$str() {
        return failedToHandleSocketFailure;
    }

    @Override
    public final void failedToHandleSocketFinished(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToHandleSocketFinished$str(), new Object[0]);
    }

    protected String failedToHandleSocketFinished$str() {
        return failedToHandleSocketFinished;
    }

    @Override
    public final void failedToHandleSocketShutdown(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToHandleSocketShutdown$str(), new Object[0]);
    }

    protected String failedToHandleSocketShutdown$str() {
        return failedToHandleSocketShutdown;
    }

    @Override
    public final void failedToReadMessage(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToReadMessage$str(), new Object[0]);
    }

    protected String failedToReadMessage$str() {
        return failedToReadMessage;
    }

    @Override
    public final void leakedMessageOutputStream() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.leakedMessageOutputStream$str(), new Object[0]);
    }

    protected String leakedMessageOutputStream$str() {
        return leakedMessageOutputStream;
    }

    protected String failedToCreateServerThread$str() {
        return failedToCreateServerThread;
    }

    @Override
    public final IOException failedToCreateServerThread() {
        IOException result = new IOException(String.format(this.failedToCreateServerThread$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToReadObject$str() {
        return failedToReadObject;
    }

    @Override
    public final IOException failedToReadObject(Throwable cause) {
        IOException result = new IOException(String.format(this.failedToReadObject$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidByte0$str() {
        return invalidByte0;
    }

    @Override
    public final UTFDataFormatException invalidByte() {
        UTFDataFormatException result = new UTFDataFormatException(String.format(this.invalidByte0$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidByte2$str() {
        return invalidByte2;
    }

    @Override
    public final UTFDataFormatException invalidByte(char c, int i) {
        UTFDataFormatException result = new UTFDataFormatException(String.format(this.invalidByte2$str(), Character.valueOf(c), i));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidByteToken$str() {
        return invalidByteToken;
    }

    @Override
    public final IOException invalidByteToken(int expected, byte actual) {
        IOException result = new IOException(String.format(this.invalidByteToken$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCommandByte$str() {
        return invalidCommandByte;
    }

    @Override
    public final IOException invalidCommandByte(int commandByte) {
        IOException result = new IOException(String.format(this.invalidCommandByte$str(), commandByte));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidStartChunk$str() {
        return invalidStartChunk;
    }

    @Override
    public final IOException invalidStartChunk(int chunk) {
        IOException result = new IOException(String.format(this.invalidStartChunk$str(), chunk));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String readBytes$str() {
        return readBytes;
    }

    @Override
    public final EOFException readBytes(int bytesRead) {
        EOFException result = new EOFException(String.format(this.readBytes$str(), bytesRead));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String streamClosed$str() {
        return streamClosed;
    }

    @Override
    public final IOException streamClosed() {
        IOException result = new IOException(String.format(this.streamClosed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String threadCreationRefused$str() {
        return threadCreationRefused;
    }

    @Override
    public final IllegalStateException threadCreationRefused() {
        IllegalStateException result = new IllegalStateException(String.format(this.threadCreationRefused$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedEndOfStream$str() {
        return unexpectedEndOfStream;
    }

    @Override
    public final EOFException unexpectedEndOfStream() {
        EOFException result = new EOFException(String.format(this.unexpectedEndOfStream$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String writeChannelClosed$str() {
        return writeChannelClosed;
    }

    @Override
    public final IOException writeChannelClosed() {
        IOException result = new IOException(String.format(this.writeChannelClosed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String writesAlreadyShutdown$str() {
        return writesAlreadyShutdown;
    }

    @Override
    public final IOException writesAlreadyShutdown() {
        IOException result = new IOException(String.format(this.writesAlreadyShutdown$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

