/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.RollbackPatch;
import org.jboss.as.patching.runner.IdentityPatchContext;
import org.jboss.as.patching.runner.PatchUtils;

class IdentityApplyCallback
implements IdentityPatchContext.FinalizeCallback {
    private final String patchId;
    private final Patch original;
    private final DirectoryStructure structure;

    public IdentityApplyCallback(Patch original, DirectoryStructure structure) {
        this.patchId = original.getPatchId();
        this.original = original;
        this.structure = structure;
    }

    @Override
    public Patch getPatch() {
        return this.original;
    }

    @Override
    public void finishPatch(Patch processedPatch, RollbackPatch rollbackPatch, IdentityPatchContext context) throws Exception {
        File historyDir = this.structure.getInstalledImage().getPatchHistoryDir(this.patchId);
        if (!historyDir.exists()) {
            historyDir.mkdirs();
        }
        File timestamp = new File(historyDir, "timestamp");
        PatchUtils.writeRef(timestamp, PatchUtils.generateTimestamp());
        File backupPatchXml = new File(historyDir, "patch.xml");
        IdentityPatchContext.writePatch(processedPatch, backupPatchXml);
        File rollbackPatchXml = new File(historyDir, "rollback.xml");
        IdentityPatchContext.writePatch(rollbackPatch, rollbackPatchXml);
        context.backupConfiguration();
    }

    @Override
    public void completed(IdentityPatchContext context) {
    }

    @Override
    public void operationCancelled(IdentityPatchContext context) {
        InstalledImage image = this.structure.getInstalledImage();
        IoUtils.recursiveDelete(image.getPatchHistoryDir(this.patchId));
        IoUtils.recursiveDelete(this.structure.getBundlesPatchDirectory(this.patchId));
        IoUtils.recursiveDelete(this.structure.getModulePatchDirectory(this.patchId));
        for (PatchElement element : this.original.getElements()) {
            boolean addOn = element.getProvider().isAddOn();
            IdentityPatchContext.PatchEntry entry = context.getEntry(element.getProvider().getName(), addOn);
            DirectoryStructure structure = entry.getDirectoryStructure();
            IoUtils.recursiveDelete(structure.getBundlesPatchDirectory(element.getId()));
            IoUtils.recursiveDelete(structure.getModulePatchDirectory(element.getId()));
        }
    }
}

