/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.runner.IdentityPatchContext;
import org.jboss.as.patching.runner.PatchUtils;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.wildfly.security.manager.WildFlySecurityManager;

class PatchModuleInvalidationUtils {
    private static final boolean ENABLE_INVALIDATION = Boolean.parseBoolean(WildFlySecurityManager.getPropertyPrivileged((String)"org.wildfly.patching.jar.invalidation", (String)"false"));
    public static final long LOCSIG = 67324752L;
    public static final long EXTSIG = 134695760L;
    public static final long CENSIG = 33639248L;
    public static final int GOOD_ENDSIG = 101010256;
    public static final int CRIPPLED_ENDSIG = 117787472;
    public static final int LOCLEN = 30;
    public static final int CENLEN = 46;
    public static final int ENDLEN = 22;
    public static final int LOC_FILENAMELEN = 26;
    public static final int LOC_EXTFLDLEN = 28;
    public static final int CENSIZ = 20;
    public static final int CEN_LOC_OFFSET = 32;
    public static final int END_CENSTART = 16;
    public static final long ZIP64_MARKER = 0xFFFFFFFFL;
    public static final int END_COMMENTLEN = 20;
    private static final int MAX_REVERSE_SCAN = 65558;
    private static final int CHUNK_SIZE = 4096;
    private static final int ALPHABET_SIZE = 256;
    private static final byte[] GOOD_ENDSIG_PATTERN = new byte[]{6, 5, 75, 80};
    private static final byte[] CRIPPLED_ENDSIG_PATTERN = new byte[]{7, 5, 75, 80};
    private static final int SIG_PATTERN_LENGTH = 4;
    private static final int[] BAD_BYTE_SKIP = new int[256];
    private static final byte[] LOCSIG_PATTERN = new byte[]{80, 75, 3, 4};
    private static final int[] LOC_BAD_BYTE_SKIP = new int[256];

    private PatchModuleInvalidationUtils() {
    }

    static void processFile(IdentityPatchContext context, File file, PatchingTaskContext.Mode mode) throws IOException {
        if (mode == PatchingTaskContext.Mode.APPLY) {
            if (ENABLE_INVALIDATION) {
                PatchModuleInvalidationUtils.updateJar(file, GOOD_ENDSIG_PATTERN, BAD_BYTE_SKIP, 117787472, 101010256);
                PatchModuleInvalidationUtils.backup(context, file);
            }
        } else if (mode == PatchingTaskContext.Mode.ROLLBACK) {
            PatchModuleInvalidationUtils.updateJar(file, CRIPPLED_ENDSIG_PATTERN, BAD_BYTE_SKIP, 101010256, 117787472);
            PatchModuleInvalidationUtils.restore(context, file);
        } else {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateJar(File file, byte[] searchPattern, int[] badSkipBytes, int newSig, int endSig) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            FileChannel channel = raf.getChannel();
            try {
                long pos = channel.size() - 22L;
                ScanContext context = newSig == 117787472 ? new ScanContext(GOOD_ENDSIG_PATTERN, CRIPPLED_ENDSIG_PATTERN) : (newSig == 101010256 ? new ScanContext(CRIPPLED_ENDSIG_PATTERN, GOOD_ENDSIG_PATTERN) : null);
                if (!PatchModuleInvalidationUtils.validateEndRecord(file, channel, pos, endSig)) {
                    pos = PatchModuleInvalidationUtils.scanForEndSig(file, channel, context);
                }
                if (pos == -1L) {
                    if (context.state == State.NOT_FOUND) {
                        PatchLogger.ROOT_LOGGER.cannotInvalidateZip(file.getAbsolutePath());
                    }
                    return;
                }
                channel.position(pos);
                ByteBuffer buffer = ByteBuffer.allocate(4);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putInt(newSig);
                buffer.flip();
                while (buffer.hasRemaining()) {
                    channel.write(buffer);
                }
            }
            finally {
                PatchModuleInvalidationUtils.safeClose(channel);
            }
        }
        finally {
            PatchModuleInvalidationUtils.safeClose(raf);
        }
    }

    private static void backup(IdentityPatchContext context, File file) {
        File targetFile;
        String fileName = file.getName();
        if (fileName.endsWith(".jar") && !file.renameTo(targetFile = PatchUtils.getRenamedFileName(file))) {
            if (context != null) {
                context.failedToRenameFile(file, targetFile);
            } else {
                throw PatchLogger.ROOT_LOGGER.cannotRenameFileDuringBackup(file.getAbsolutePath());
            }
        }
    }

    private static void restore(IdentityPatchContext context, File file) {
        File targetFile;
        String fileName = file.getName();
        if (fileName.endsWith(".jar.patched") && !file.renameTo(targetFile = PatchUtils.getRenamedFileName(file))) {
            if (context != null) {
                context.failedToRenameFile(file, targetFile);
            } else {
                throw PatchLogger.ROOT_LOGGER.cannotRenameFileDuringRestore(file.getAbsolutePath());
            }
        }
    }

    private static boolean validateEndRecord(File file, FileChannel channel, long startEndRecord, long endSig) throws IOException {
        try {
            channel.position(startEndRecord);
            ByteBuffer endDirHeader = PatchModuleInvalidationUtils.getByteBuffer(22);
            PatchModuleInvalidationUtils.read(endDirHeader, channel);
            if (endDirHeader.limit() < 22) {
                return false;
            }
            if (PatchModuleInvalidationUtils.getUnsignedInt(endDirHeader, 0) != endSig) {
                return false;
            }
            long pos = PatchModuleInvalidationUtils.getUnsignedInt(endDirHeader, 16);
            if (pos == 0xFFFFFFFFL) {
                return false;
            }
            ByteBuffer cdfhBuffer = PatchModuleInvalidationUtils.getByteBuffer(46);
            PatchModuleInvalidationUtils.read(cdfhBuffer, channel, pos);
            long header = PatchModuleInvalidationUtils.getUnsignedInt(cdfhBuffer, 0);
            if (header == 33639248L) {
                int commentLen;
                long commentEnd;
                long firstLoc = PatchModuleInvalidationUtils.getUnsignedInt(cdfhBuffer, 32);
                long firstSize = PatchModuleInvalidationUtils.getUnsignedInt(cdfhBuffer, 20);
                if (firstLoc == 0L) {
                    if (!PatchModuleInvalidationUtils.validateLocalFileRecord(channel, 0L, firstSize)) {
                        return false;
                    }
                } else {
                    long fileFirstLoc = PatchModuleInvalidationUtils.scanForLocSig(channel);
                    if (firstLoc != fileFirstLoc) {
                        if (fileFirstLoc == 0L) {
                            return false;
                        }
                        return false;
                    }
                }
                return (commentEnd = startEndRecord + 22L + (long)(commentLen = PatchModuleInvalidationUtils.getUnsignedShort(endDirHeader, 20))) <= channel.size();
            }
            return false;
        }
        catch (EOFException eof) {
            return false;
        }
    }

    private static long scanForEndSig(File file, FileChannel channel, ScanContext context) throws IOException {
        long channelPos;
        ByteBuffer bb = PatchModuleInvalidationUtils.getByteBuffer(4096);
        long start = channel.size();
        long end = Math.max(0L, start - 65558L);
        long lastChannelPos = channelPos = Math.max(0L, start - 4096L);
        while (lastChannelPos >= end) {
            PatchModuleInvalidationUtils.read(bb, channel, channelPos);
            int actualRead = bb.limit();
            int bufferPos = actualRead - 1;
            block5: while (bufferPos >= 4) {
                int patternPos;
                for (patternPos = 3; patternPos >= 0 && context.matches(patternPos, bb.get(bufferPos - patternPos)); --patternPos) {
                }
                switch (patternPos) {
                    case -1: {
                        State state = context.state;
                        long startEndRecord = channelPos + (long)bufferPos - 4L + 1L;
                        if (PatchModuleInvalidationUtils.validateEndRecord(file, channel, startEndRecord, context.getSig())) {
                            if (state == State.FOUND) {
                                return startEndRecord;
                            }
                            return -1L;
                        }
                        bufferPos -= 4;
                        continue block5;
                    }
                    case 3: {
                        int idx = bb.get(bufferPos - patternPos) - -128;
                        bufferPos -= BAD_BYTE_SKIP[idx];
                        continue block5;
                    }
                }
                bufferPos -= 4;
            }
            if (channelPos <= (long)bufferPos) break;
            lastChannelPos = channelPos;
            channelPos -= Math.min(channelPos - (long)bufferPos, (long)(4096 - bufferPos));
        }
        return -1L;
    }

    private static long scanForLocSig(FileChannel channel) throws IOException {
        channel.position(0L);
        ByteBuffer bb = PatchModuleInvalidationUtils.getByteBuffer(4096);
        long end = channel.size();
        while (channel.position() <= end) {
            PatchModuleInvalidationUtils.read(bb, channel);
            int bufferPos = 0;
            block5: while (bufferPos <= bb.limit() - 4) {
                int patternPos;
                for (patternPos = 3; patternPos >= 0 && LOCSIG_PATTERN[patternPos] == bb.get(bufferPos + patternPos); --patternPos) {
                }
                switch (patternPos) {
                    case -1: {
                        long startLocRecord = channel.position() - (long)bb.limit() + (long)bufferPos;
                        long currentPos = channel.position();
                        if (PatchModuleInvalidationUtils.validateLocalFileRecord(channel, startLocRecord, -1L)) {
                            return startLocRecord;
                        }
                        channel.position(currentPos);
                        bufferPos += 4;
                        continue block5;
                    }
                    case 3: {
                        int idx = bb.get(bufferPos + patternPos) - -128;
                        bufferPos += LOC_BAD_BYTE_SKIP[idx];
                        continue block5;
                    }
                }
                bufferPos += 4;
            }
        }
        return -1L;
    }

    private static boolean validateLocalFileRecord(FileChannel channel, long startLocRecord, long compressedSize) throws IOException {
        ByteBuffer lfhBuffer = PatchModuleInvalidationUtils.getByteBuffer(30);
        PatchModuleInvalidationUtils.read(lfhBuffer, channel, startLocRecord);
        if (lfhBuffer.limit() < 30 || PatchModuleInvalidationUtils.getUnsignedInt(lfhBuffer, 0) != 67324752L) {
            return false;
        }
        if (compressedSize == -1L) {
            return true;
        }
        int fnLen = PatchModuleInvalidationUtils.getUnsignedShort(lfhBuffer, 26);
        int extFieldLen = PatchModuleInvalidationUtils.getUnsignedShort(lfhBuffer, 28);
        long nextSigPos = startLocRecord + 30L + compressedSize + (long)fnLen + (long)extFieldLen;
        PatchModuleInvalidationUtils.read(lfhBuffer, channel, nextSigPos);
        long header = PatchModuleInvalidationUtils.getUnsignedInt(lfhBuffer, 0);
        return header == 67324752L || header == 134695760L || header == 33639248L;
    }

    private static ByteBuffer getByteBuffer(int capacity) {
        ByteBuffer b = ByteBuffer.allocate(capacity);
        b.order(ByteOrder.LITTLE_ENDIAN);
        return b;
    }

    private static void read(ByteBuffer bb, FileChannel ch) throws IOException {
        bb.clear();
        ch.read(bb);
        bb.flip();
    }

    private static void read(ByteBuffer bb, FileChannel ch, long pos) throws IOException {
        bb.clear();
        ch.read(bb, pos);
        bb.flip();
    }

    private static long getUnsignedInt(ByteBuffer bb, int offset) {
        return (long)bb.getInt(offset) & 0xFFFFFFFFL;
    }

    private static int getUnsignedShort(ByteBuffer bb, int offset) {
        return bb.getShort(offset) & 0xFFFF;
    }

    private static void computeBadByteSkipArray(byte[] pattern, int[] badByteArray) {
        for (int a = 0; a < 256; ++a) {
            badByteArray[a] = pattern.length;
        }
        for (int j = 0; j < pattern.length - 1; ++j) {
            badByteArray[pattern[j] - -128] = pattern.length - j - 1;
        }
    }

    private static void computeBadByteSkipArray(byte[] patterOne, byte[] patternTwo, int[] badByteArray) {
        int j;
        assert (patterOne.length == patternTwo.length);
        for (int a = 0; a < 256; ++a) {
            badByteArray[a] = patterOne.length;
        }
        for (j = 0; j < patternTwo.length - 1; ++j) {
            badByteArray[patterOne[j] - -128] = patterOne.length - j - 1;
        }
        for (j = 0; j < patternTwo.length - 1; ++j) {
            badByteArray[patternTwo[j] - -128] = patternTwo.length - j - 1;
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        PatchModuleInvalidationUtils.computeBadByteSkipArray(GOOD_ENDSIG_PATTERN, CRIPPLED_ENDSIG_PATTERN, BAD_BYTE_SKIP);
        PatchModuleInvalidationUtils.computeBadByteSkipArray(LOCSIG_PATTERN, LOC_BAD_BYTE_SKIP);
    }

    static class ScanContext {
        private byte good;
        private byte bad;
        private byte[] pattern;
        private State state = State.NOT_FOUND;

        private ScanContext(byte[] good, byte[] bad) {
            assert (good.length == bad.length);
            this.good = good[0];
            this.bad = bad[0];
            assert (this.good != this.bad);
            this.pattern = new byte[good.length];
            for (int i = 1; i < good.length; ++i) {
                assert (good[i] == bad[i]);
                this.pattern[i] = good[i];
            }
        }

        boolean matches(int pos, byte b) {
            if (pos == 0) {
                if (b == this.good) {
                    this.state = State.FOUND;
                    return true;
                }
                if (b == this.bad) {
                    this.state = State.NOTHING_TODO;
                    return true;
                }
                return false;
            }
            return this.pattern[pos] == b;
        }

        int getSig() {
            byte b;
            if (this.state == State.FOUND) {
                b = this.good;
            } else if (this.state == State.NOTHING_TODO) {
                b = this.bad;
            } else {
                throw new IllegalStateException();
            }
            return (b << 24) + (this.pattern[1] << 16) + (this.pattern[2] << 8) + (this.pattern[3] << 0);
        }
    }

    static enum State {
        FOUND,
        NOTHING_TODO,
        NOT_FOUND;

    }
}

