/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.io.File;
import org.jboss.as.patching.validation.AbstractArtifact;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.as.patching.validation.PatchingArtifactProcessor;
import org.jboss.as.patching.validation.PatchingArtifactValidationContext;

public interface PatchingFileArtifact<P extends PatchingArtifact.ArtifactState, S extends FileArtifactState>
extends PatchingArtifact<P, S> {

    public static class DirectoryArtifactState
    extends FileArtifactState {
        public DirectoryArtifactState(File file, PatchingFileArtifact artifact) {
            super(file, artifact);
        }

        @Override
        protected boolean validate0(PatchingArtifactValidationContext context) {
            if (!this.file.isDirectory()) {
                context.getErrorHandler().addInconsistent(this.artifact, this);
                return false;
            }
            return true;
        }
    }

    public static class FileArtifactState
    implements PatchingArtifact.ArtifactState,
    FileState {
        protected final File file;
        protected final PatchingFileArtifact artifact;

        protected FileArtifactState(File file, PatchingFileArtifact artifact) {
            this.file = file;
            this.artifact = artifact;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public boolean isValid(PatchingArtifactValidationContext context) {
            if (this.file == null) {
                context.getErrorHandler().addError(this.artifact, this);
                return false;
            }
            if (!this.file.exists()) {
                context.getErrorHandler().addMissing(this.artifact, this);
                return false;
            }
            return this.validate0(context);
        }

        protected boolean validate0(PatchingArtifactValidationContext context) {
            if (this.file.isDirectory()) {
                context.getErrorHandler().addInconsistent(this.artifact, this);
                return false;
            }
            return true;
        }

        public String toString() {
            if (this.file != null) {
                return this.file.getAbsolutePath();
            }
            return this.artifact.getClass().getName();
        }
    }

    public static class ConcreteDirectoryArtifact
    extends AbstractArtifact<DirectoryArtifactState, DirectoryArtifactState>
    implements PatchingFileArtifact<DirectoryArtifactState, DirectoryArtifactState> {
        private final String fileName;

        public ConcreteDirectoryArtifact(String fileName, PatchingArtifact<DirectoryArtifactState, ? extends PatchingArtifact.ArtifactState> ... artifacts) {
            super(artifacts);
            this.fileName = fileName;
        }

        @Override
        public boolean process(DirectoryArtifactState parent, PatchingArtifactProcessor processor) {
            File file = new File(parent.getFile(), this.fileName);
            DirectoryArtifactState state = new DirectoryArtifactState(file, this);
            return processor.process(this, state);
        }
    }

    public static class ConcreteFileArtifact
    extends AbstractArtifact<DirectoryArtifactState, FileArtifactState>
    implements PatchingFileArtifact<DirectoryArtifactState, FileArtifactState> {
        private final String fileName;

        public ConcreteFileArtifact(String fileName, PatchingArtifact<FileArtifactState, ? extends PatchingArtifact.ArtifactState> ... artifacts) {
            super(artifacts);
            this.fileName = fileName;
        }

        @Override
        public boolean process(DirectoryArtifactState parent, PatchingArtifactProcessor processor) {
            File file = new File(parent.getFile(), this.fileName);
            FileArtifactState state = new FileArtifactState(file, this);
            return processor.process(this, state);
        }
    }

    public static interface FileState {
        public File getFile();
    }
}

