/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipFile;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.logging.PatchLogger;

public class IoUtils {
    public static byte[] NO_CONTENT = new byte[0];
    private static final int DEFAULT_BUFFER_SIZE = 65536;

    public static void copyStreamAndClose(InputStream is, OutputStream os) throws IOException {
        try {
            IoUtils.copyStream(is, os, 65536);
            is.close();
            os.close();
        }
        finally {
            IoUtils.safeClose(is);
            IoUtils.safeClose(os);
        }
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        IoUtils.copyStream(is, os, 65536);
    }

    private static void copyStream(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int rc;
        if (is == null) {
            throw PatchLogger.ROOT_LOGGER.nullInputStream();
        }
        if (os == null) {
            throw PatchLogger.ROOT_LOGGER.nullOutputStream();
        }
        byte[] buff = new byte[bufferSize];
        while ((rc = is.read(buff)) != -1) {
            os.write(buff, 0, rc);
        }
        os.flush();
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        if (sourceFile.isDirectory()) {
            IoUtils.copyDir(sourceFile, targetFile);
        } else {
            File parent = targetFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw PatchLogger.ROOT_LOGGER.cannotCreateDirectory(parent.getAbsolutePath());
            }
            FileInputStream is = new FileInputStream(sourceFile);
            FileOutputStream os = new FileOutputStream(targetFile);
            IoUtils.copyStreamAndClose(is, os);
        }
    }

    private static void copyDir(File sourceDir, File targetDir) throws IOException {
        File[] children;
        if (targetDir.exists()) {
            if (!targetDir.isDirectory()) {
                throw PatchLogger.ROOT_LOGGER.notADirectory(targetDir.getAbsolutePath());
            }
        } else if (!targetDir.mkdirs()) {
            throw PatchLogger.ROOT_LOGGER.cannotCreateDirectory(targetDir.getAbsolutePath());
        }
        if ((children = sourceDir.listFiles()) != null) {
            for (File child : children) {
                IoUtils.copyFile(child, new File(targetDir, child.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] copy(InputStream is, File target) throws IOException {
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        FileOutputStream os = new FileOutputStream(target);
        try {
            byte[] nh = HashUtils.copyAndGetHash(is, os);
            ((OutputStream)os).close();
            byte[] byArray = nh;
            return byArray;
        }
        finally {
            IoUtils.safeClose(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] copy(File source, File target) throws IOException {
        FileInputStream is = new FileInputStream(source);
        try {
            byte[] backupHash = IoUtils.copy(is, target);
            is.close();
            byte[] byArray = backupHash;
            return byArray;
        }
        finally {
            IoUtils.safeClose(is);
        }
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safeClose(ZipFile closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean recursiveDelete(File root) {
        if (root == null) {
            return true;
        }
        boolean ok = true;
        if (root.isDirectory()) {
            File[] files;
            for (File file : files = root.listFiles()) {
                ok &= IoUtils.recursiveDelete(file);
            }
            return ok && (root.delete() || !root.exists());
        }
        return ok &= root.delete() || !root.exists();
    }

    public static File mkdir(File parent, String ... segments) throws IOException {
        File dir = parent;
        for (String segment : segments) {
            dir = new File(dir, segment);
        }
        dir.mkdirs();
        return dir;
    }

    public static File newFile(File baseDir, String ... segments) {
        File f = baseDir;
        for (String segment : segments) {
            f = new File(f, segment);
        }
        return f;
    }
}

