/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.runner.AbstractModuleTask;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchUtils;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

class ModuleUpdateTask
extends AbstractModuleTask {
    ModuleUpdateTask(PatchingTaskDescription description) {
        super(description);
    }

    @Override
    public boolean prepare(PatchingTaskContext context) throws IOException {
        this.backupHash = this.backup(context);
        byte[] contentHash = ((ModuleItem)this.contentItem).getContentHash();
        if (Arrays.equals(this.backupHash, contentHash)) {
            return true;
        }
        byte[] expected = this.description.getModification().getTargetHash();
        if (Arrays.equals(this.backupHash, expected)) {
            return !this.description.hasConflicts();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] apply(PatchingTaskContext context, PatchContentLoader loader) throws IOException {
        File targetDir = context.getTargetFile(this.contentItem);
        File sourceDir = loader.getFile(this.contentItem);
        if (!sourceDir.exists()) {
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                throw PatchLogger.ROOT_LOGGER.cannotCreateDirectory(targetDir.getAbsolutePath());
            }
            File moduleXml = new File(targetDir, "module.xml");
            ByteArrayInputStream is = new ByteArrayInputStream(PatchUtils.getAbsentModuleContent((ModuleItem)this.contentItem));
            try {
                byte[] byArray = IoUtils.copy(is, moduleXml);
                return byArray;
            }
            finally {
                IoUtils.safeClose(is);
            }
        }
        IoUtils.copyFile(sourceDir, targetDir);
        return HashUtils.hashFile(targetDir);
    }

    @Override
    ContentModification createRollbackEntry(ContentModification original, byte[] targetHash, byte[] itemHash) {
        ModuleItem item = ModuleUpdateTask.createContentItem((ModuleItem)this.contentItem, itemHash);
        ModificationType type = original.getType() != ModificationType.MODIFY && itemHash.length == 0 ? ModificationType.REMOVE : ModificationType.MODIFY;
        return new ContentModification(item, targetHash, type);
    }
}

