/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.patching.metadata.Identity;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.impl.IncompatibleWithCallback;
import org.jboss.as.patching.metadata.impl.RequiresCallback;

public class IdentityImpl
implements Identity,
RequiresCallback,
IncompatibleWithCallback,
Identity.IdentityUpgrade {
    private final String name;
    private final String version;
    private String resultingVersion;
    private Patch.PatchType patchType;
    private Collection<String> incompatibleWith = Collections.emptyList();
    private Collection<String> requires = Collections.emptyList();

    public IdentityImpl(String name, String version) {
        assert (name != null);
        assert (version != null);
        this.name = name;
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Patch.PatchType getPatchType() {
        return this.patchType;
    }

    @Override
    public String getResultingVersion() {
        return this.resultingVersion;
    }

    @Override
    public Collection<String> getRequires() {
        return this.requires;
    }

    @Override
    public Collection<String> getIncompatibleWith() {
        return this.incompatibleWith;
    }

    @Override
    public IdentityImpl require(String patchId) {
        assert (patchId != null);
        if (this.requires.isEmpty()) {
            this.requires = new ArrayList<String>();
        }
        this.requires.add(patchId);
        return this;
    }

    @Override
    public IncompatibleWithCallback incompatibleWith(String patchID) {
        assert (patchID != null);
        if (this.incompatibleWith.isEmpty()) {
            this.incompatibleWith = new ArrayList<String>();
        }
        this.incompatibleWith.add(patchID);
        return this;
    }

    public void setResultingVersion(String resultingVersion) {
        this.resultingVersion = resultingVersion;
    }

    public void setPatchType(Patch.PatchType patchType) {
        this.patchType = patchType;
    }

    @Override
    public <T extends Identity> T forType(Patch.PatchType patchType, Class<T> clazz) {
        assert (patchType == this.patchType);
        if (patchType == Patch.PatchType.CUMULATIVE) assert (this.resultingVersion != null);
        return (T)((Identity)clazz.cast(this));
    }
}

