/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.validation.PatchHistoryIterator;
import org.jboss.as.patching.validation.PatchHistoryValidations;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.as.patching.validation.PatchingArtifactStateHandler;
import org.jboss.as.patching.validation.PatchingArtifacts;
import org.jboss.as.patching.validation.PatchingFileArtifact;

public class PatchingGarbageLocator {
    private static final PatchLogger log = PatchLogger.ROOT_LOGGER;
    static final FilenameFilter ALL = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return true;
        }
    };
    private final InstalledIdentity installedIdentity;
    private Set<String> validHistory;
    private Set<File> referencedOverlayDirectories;

    public static PatchingGarbageLocator getIninitialized(InstalledIdentity installedIdentity) {
        return new PatchingGarbageLocator(installedIdentity);
    }

    protected PatchingGarbageLocator(InstalledIdentity installedIdentity) {
        this.installedIdentity = installedIdentity;
    }

    private void walk() throws PatchingException {
        this.validHistory = new HashSet<String>();
        this.referencedOverlayDirectories = new HashSet<File>();
        final HashSet<String> activeHistory = new HashSet<String>();
        try {
            PatchableTarget.TargetInfo info = this.installedIdentity.getIdentity().loadTargetInfo();
            activeHistory.addAll(info.getPatchIDs());
            activeHistory.add(info.getCumulativePatchID());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PatchHistoryIterator.Builder builder = PatchHistoryIterator.Builder.create(this.installedIdentity);
        builder.addStateHandler(PatchingArtifacts.MODULE_OVERLAY, new PatchingArtifactStateHandler<PatchingFileArtifact.DirectoryArtifactState>(){

            @Override
            public void handleValidatedState(PatchingFileArtifact.DirectoryArtifactState state) {
                PatchingGarbageLocator.this.referencedOverlayDirectories.add(state.getFile());
            }
        });
        builder.addStateHandler(PatchingArtifacts.BUNDLE_OVERLAY, new PatchingArtifactStateHandler<PatchingFileArtifact.DirectoryArtifactState>(){

            @Override
            public void handleValidatedState(PatchingFileArtifact.DirectoryArtifactState state) {
                PatchingGarbageLocator.this.referencedOverlayDirectories.add(state.getFile());
            }
        });
        PatchHistoryValidations.HistoryProcessor processor = new PatchHistoryValidations.HistoryProcessor(){
            boolean failed = false;

            @Override
            protected boolean includeCurrent() {
                return true;
            }

            @Override
            protected boolean canProceed() {
                return !activeHistory.isEmpty() || !this.failed;
            }

            @Override
            protected <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> boolean handleError(PatchingArtifact<P, S> artifact, S state) {
                this.failed = true;
                return artifact == PatchingArtifacts.PATCH_XML || artifact == PatchingArtifacts.ROLLBACK_XML || artifact == PatchingArtifacts.MISC_BACKUP;
            }

            @Override
            protected void processedPatch(String patch) {
                activeHistory.remove(patch);
                PatchingGarbageLocator.this.validHistory.add(patch);
            }
        };
        processor.process(builder.iterator());
    }

    public void reset() {
        this.validHistory = null;
        this.referencedOverlayDirectories = null;
    }

    public List<File> getInactiveHistory() throws PatchingException {
        File[] inactiveDirs;
        if (this.validHistory == null) {
            this.walk();
        }
        return (inactiveDirs = this.installedIdentity.getInstalledImage().getPatchesDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !PatchingGarbageLocator.this.validHistory.contains(pathname.getName());
            }
        })) == null ? Collections.emptyList() : Arrays.asList(inactiveDirs);
    }

    public List<File> getInactiveOverlays() throws PatchingException {
        if (this.referencedOverlayDirectories == null) {
            this.walk();
        }
        ArrayList<File> inactiveDirs = null;
        for (Layer layer : this.installedIdentity.getLayers()) {
            File overlaysDir = new File(layer.getDirectoryStructure().getModuleRoot(), ".overlays");
            File[] inactiveLayerDirs = overlaysDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !PatchingGarbageLocator.this.referencedOverlayDirectories.contains(pathname);
                }
            });
            if (inactiveLayerDirs == null || inactiveLayerDirs.length <= 0) continue;
            if (inactiveDirs == null) {
                inactiveDirs = new ArrayList<File>();
            }
            inactiveDirs.addAll(Arrays.asList(inactiveLayerDirs));
        }
        return inactiveDirs == null ? Collections.emptyList() : inactiveDirs;
    }

    public void deleteInactiveContent() throws PatchingException {
        List<File> dirs = this.getInactiveHistory();
        if (!dirs.isEmpty()) {
            for (File dir : dirs) {
                PatchingGarbageLocator.deleteDir(dir, ALL);
            }
        }
        if (!(dirs = this.getInactiveOverlays()).isEmpty()) {
            for (File dir : dirs) {
                PatchingGarbageLocator.deleteDir(dir, ALL);
            }
        }
    }

    protected static boolean deleteDir(File dir, FilenameFilter filter) {
        boolean success = true;
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isDirectory()) {
                    if (PatchingGarbageLocator.deleteDir(f, filter)) continue;
                    success = false;
                    log.debugf("Failed to delete dir: %s", f.getAbsolutePath());
                    continue;
                }
                if (f.delete()) continue;
                success = false;
                log.debugf("Failed to delete file: %s", f.getAbsolutePath());
            }
        }
        if (!dir.delete()) {
            success = false;
            log.debugf("Failed to delete dir: %s", dir.getAbsolutePath());
        }
        return success;
    }
}

