/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.IOException;
import org.jboss.as.patching.HashUtils;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ModificationType;
import org.jboss.as.patching.metadata.ModuleItem;
import org.jboss.as.patching.runner.AbstractModuleTask;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

class ModuleUpdateTask
extends AbstractModuleTask {
    ModuleUpdateTask(PatchingTaskDescription description) {
        super(description);
    }

    @Override
    byte[] apply(PatchingTaskContext context, PatchContentLoader loader) throws IOException {
        File targetDir = context.getTargetFile(this.contentItem);
        File sourceDir = loader.getFile(this.contentItem);
        IoUtils.copyFile(sourceDir, targetDir);
        return HashUtils.hashFile(targetDir);
    }

    @Override
    ContentModification createRollbackEntry(ContentModification original, byte[] targetHash, byte[] itemHash) {
        ModuleItem item = ModuleUpdateTask.createContentItem((ModuleItem)this.contentItem, itemHash);
        ModificationType type = original.getType() != ModificationType.MODIFY && itemHash.length == 0 ? ModificationType.REMOVE : ModificationType.MODIFY;
        return new ContentModification(item, targetHash, type);
    }
}

