/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.tool;

import java.io.File;
import java.io.IOException;
import org.jboss.as.patching.tool.ContentPolicyBuilderImpl;
import org.jboss.as.patching.tool.PatchOperationTarget;
import org.jboss.as.patching.tool.PatchTool;
import org.jboss.dmr.ModelNode;

public interface PatchOperationBuilder
extends PatchTool.ContentPolicyBuilder {
    public ModelNode execute(PatchOperationTarget var1) throws IOException;

    public static abstract class AbstractOperationBuilder
    extends ContentPolicyBuilderImpl
    implements PatchOperationBuilder {
    }

    public static class Factory {
        private Factory() {
        }

        public static PatchOperationBuilder info() {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws IOException {
                    return target.info();
                }
            };
        }

        public static PatchOperationBuilder info(final String patchId, final boolean verbose) {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws IOException {
                    return target.info(patchId, verbose);
                }
            };
        }

        public static PatchOperationBuilder history() {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws IOException {
                    return target.history();
                }
            };
        }

        public static PatchOperationBuilder rollback(final String patchId, final boolean rollbackTo, final boolean resetConfiguration) {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws IOException {
                    return target.rollback(patchId, this, rollbackTo, resetConfiguration);
                }
            };
        }

        public static PatchOperationBuilder rollbackLast(final boolean resetConfiguration) {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws IOException {
                    return target.rollbackLast(this, resetConfiguration);
                }
            };
        }

        public static PatchOperationBuilder patch(final File file) {
            return new AbstractOperationBuilder(){

                @Override
                public ModelNode execute(PatchOperationTarget target) throws IOException {
                    return target.applyPatch(file, this);
                }
            };
        }
    }
}

