/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.Builder;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.Identity;
import org.jboss.as.patching.metadata.ModificationBuilderTarget;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.metadata.PatchElementBuilder;
import org.jboss.as.patching.metadata.PatchIdentityBuilder;
import org.jboss.as.patching.metadata.PatchImpl;
import org.jboss.as.patching.metadata.PatchMetadataResolver;
import org.jboss.as.patching.metadata.impl.IdentityImpl;
import org.jboss.as.patching.metadata.impl.PatchElementProviderImpl;

public class PatchBuilder
extends ModificationBuilderTarget<PatchBuilder>
implements Builder,
PatchMetadataResolver {
    protected String patchId;
    private String description;
    private Identity identity;
    private Patch.PatchType patchType;
    private final List<ContentModification> modifications = new ArrayList<ContentModification>();
    private final List<PatchElementHolder> elements = new ArrayList<PatchElementHolder>();

    public static PatchBuilder create() {
        return new PatchBuilder();
    }

    protected PatchBuilder() {
    }

    public PatchBuilder setPatchId(String patchId) {
        if (!Patch.PATCH_NAME_PATTERN.matcher(patchId).matches()) {
            throw PatchLogger.ROOT_LOGGER.illegalPatchName(patchId);
        }
        this.patchId = patchId;
        return this;
    }

    public PatchBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public PatchIdentityBuilder upgradeIdentity(String name, String version, String resultingVersion) {
        PatchIdentityBuilder builder = new PatchIdentityBuilder(name, version, Patch.PatchType.CUMULATIVE, this);
        IdentityImpl identity = builder.getIdentity();
        identity.setResultingVersion(resultingVersion);
        this.identity = identity;
        this.patchType = Patch.PatchType.CUMULATIVE;
        return builder;
    }

    public PatchIdentityBuilder oneOffPatchIdentity(String name, String version) {
        PatchIdentityBuilder builder = new PatchIdentityBuilder(name, version, Patch.PatchType.ONE_OFF, this);
        IdentityImpl identity = builder.getIdentity();
        this.identity = identity;
        this.patchType = Patch.PatchType.ONE_OFF;
        return builder;
    }

    @Override
    protected PatchBuilder internalAddModification(ContentModification modification) {
        this.modifications.add(modification);
        return this;
    }

    public PatchElementBuilder upgradeElement(String patchId, String layerName, boolean addOn) {
        if (!Patch.PATCH_NAME_PATTERN.matcher(patchId).matches()) {
            throw PatchLogger.ROOT_LOGGER.illegalPatchName(patchId);
        }
        PatchElementBuilder builder = new PatchElementBuilder(patchId, layerName, addOn, this);
        builder.upgrade();
        this.elements.add(builder);
        return builder;
    }

    public PatchElementBuilder oneOffPatchElement(String patchId, String layerName, boolean addOn) {
        if (!Patch.PATCH_NAME_PATTERN.matcher(patchId).matches()) {
            throw PatchLogger.ROOT_LOGGER.illegalPatchName(patchId);
        }
        PatchElementBuilder builder = new PatchElementBuilder(patchId, layerName, addOn, this);
        builder.oneOffPatch();
        this.elements.add(builder);
        return builder;
    }

    public PatchElementBuilder addElement(String patchId, String layerName, boolean addOn) {
        if (!Patch.PATCH_NAME_PATTERN.matcher(patchId).matches()) {
            throw PatchLogger.ROOT_LOGGER.illegalPatchName(patchId);
        }
        PatchElementBuilder builder = new PatchElementBuilder(patchId, layerName, addOn, this);
        this.elements.add(builder);
        return builder;
    }

    public PatchBuilder addElement(final PatchElement element) {
        this.elements.add(new PatchElementHolder(){

            @Override
            public PatchElement createElement(Patch.PatchType patchType) {
                Patch.PatchType type = element.getProvider().getPatchType();
                if (type == null) {
                    if (patchType == Patch.PatchType.CUMULATIVE) {
                        ((PatchElementProviderImpl)element.getProvider()).upgrade();
                    } else {
                        ((PatchElementProviderImpl)element.getProvider()).oneOffPatch();
                    }
                } else if (patchType != PatchBuilder.this.patchType) {
                    throw PatchLogger.ROOT_LOGGER.patchTypesDontMatch();
                }
                return element;
            }
        });
        return this;
    }

    public List<ContentModification> getModifications() {
        return this.modifications;
    }

    @Override
    public Patch resolvePatch(String name, String version) throws PatchingException {
        return this.build();
    }

    @Override
    public Patch build() {
        assert (PatchBuilder.notNull(this.identity));
        assert (PatchBuilder.notNull(this.patchId));
        ArrayList<PatchElement> elements = new ArrayList<PatchElement>();
        for (PatchElementHolder holder : this.elements) {
            elements.add(holder.createElement(this.patchType));
        }
        return new PatchImpl(this.patchId, this.description, this.identity, Collections.unmodifiableList(elements), Collections.unmodifiableList(this.modifications));
    }

    @Override
    protected PatchBuilder returnThis() {
        return this;
    }

    static boolean notNull(Object o) {
        return o != null;
    }

    protected static interface PatchElementHolder {
        public PatchElement createElement(Patch.PatchType var1);
    }
}

