/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstallationManagerService;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

abstract class ElementProviderAttributeReadHandler
implements OperationStepHandler {
    ElementProviderAttributeReadHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        String name = element.getValue();
        ServiceController mgrService = context.getServiceRegistry(false).getRequiredService(InstallationManagerService.NAME);
        InstallationManager mgr = (InstallationManager)mgrService.getValue();
        PatchableTarget target = this.getProvider(name, mgr);
        ModelNode result = context.getResult();
        this.handle(result, target);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected abstract PatchableTarget getProvider(String var1, InstalledIdentity var2) throws OperationFailedException;

    abstract void handle(ModelNode var1, PatchableTarget var2) throws OperationFailedException;

    static abstract class LayerAttributeReadHandler
    extends ElementProviderAttributeReadHandler {
        LayerAttributeReadHandler() {
        }

        @Override
        protected Layer getProvider(String name, InstalledIdentity identity) throws OperationFailedException {
            Layer target = identity.getLayer(name);
            if (target == null) {
                throw new OperationFailedException(PatchLogger.ROOT_LOGGER.noSuchLayer(name).getLocalizedMessage());
            }
            return target;
        }
    }

    static abstract class AddOnAttributeReadHandler
    extends ElementProviderAttributeReadHandler {
        AddOnAttributeReadHandler() {
        }

        @Override
        protected PatchableTarget getProvider(String name, InstalledIdentity identity) throws OperationFailedException {
            AddOn target = identity.getAddOn(name);
            if (target == null) {
                throw new OperationFailedException(PatchLogger.ROOT_LOGGER.noSuchLayer(name).getLocalizedMessage());
            }
            return target;
        }
    }
}

