/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ClassLoaderDebugUtil {
    public static void outputClass(Class<?> clazz) {
        Method[] methods;
        Constructor<?>[] ctors;
        Field[] fields;
        System.out.println("****** Class " + String.valueOf(clazz) + " " + String.valueOf(clazz.getClassLoader()) + " *******");
        System.out.println("\nFields:");
        for (Field field : fields = clazz.getDeclaredFields()) {
            System.out.println("    --" + field.getName() + "-" + field.getType().getName() + " (" + String.valueOf(field.getType().getClassLoader()) + ")");
        }
        System.out.println("\nConstructors");
        for (Constructor<?> ctor : ctors = clazz.getDeclaredConstructors()) {
            System.out.println("    --constructor [");
            for (Class<?> param : ctor.getParameterTypes()) {
                System.out.println("          " + param.getClass().getName() + " (" + String.valueOf(param.getClass().getClassLoader()) + ")");
            }
            System.out.println("      ]");
        }
        System.out.println("\nMethods:");
        for (Method method : methods = clazz.getDeclaredMethods()) {
            System.out.println("      " + method.getName() + " [");
            for (Class<?> param : method.getParameterTypes()) {
                System.out.println("        --" + param.getClass().getName() + " (" + String.valueOf(param.getClass().getClassLoader()));
            }
            System.out.println("      ]");
            System.out.println("      " + method.getReturnType().getName() + " (" + String.valueOf(method.getReturnType().getClassLoader()) + ")");
        }
    }
}

