/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.model.test.OperationFixer;
import org.jboss.dmr.ModelNode;

public class ModelTestOperationValidatorFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean validateNone;
    private final List<OperationEntry> entries;

    private ModelTestOperationValidatorFilter(List<OperationEntry> entries) {
        this.entries = ModelTestOperationValidatorFilter.createStandardEntries(entries);
        this.validateNone = false;
    }

    private ModelTestOperationValidatorFilter(boolean validateNone) {
        this.validateNone = validateNone;
        this.entries = validateNone ? null : ModelTestOperationValidatorFilter.createStandardEntries(null);
    }

    private static List<OperationEntry> createStandardEntries(List<OperationEntry> provided) {
        if (provided == null) {
            provided = new ArrayList<OperationEntry>();
        }
        OperationEntry oe = new OperationEntry(PathAddress.EMPTY_ADDRESS, "boottime-controller-initializer-step", Action.NOCHECK, null);
        provided.add(oe);
        return provided;
    }

    public static ModelTestOperationValidatorFilter createValidateNone() {
        return new ModelTestOperationValidatorFilter(true);
    }

    public static ModelTestOperationValidatorFilter createValidateAll() {
        return new ModelTestOperationValidatorFilter(false);
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public ModelNode adjustForValidation(ModelNode op) {
        if (this.validateNone) {
            return null;
        }
        if (this.entries == null) {
            return op;
        }
        ModelNode addr = op.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)addr);
        String name = op.get("operation").asString();
        for (OperationEntry entry : this.entries) {
            if (!this.nameMatch(name, entry) || !this.addressMatch(address, entry)) continue;
            if (entry.action == Action.NOCHECK) {
                return null;
            }
            if (entry.action == Action.RESOLVE) {
                op = ModelTestOperationValidatorFilter.resolve(op);
                continue;
            }
            if (entry.operationFixer == null) continue;
            op = entry.operationFixer.fixOperation(op);
        }
        return op;
    }

    private static ModelNode resolve(ModelNode unresolved) {
        try {
            return ExpressionResolver.TEST_RESOLVER.resolveExpressions(unresolved);
        }
        catch (OperationFailedException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean nameMatch(String opName, OperationEntry entry) {
        if (entry.name.equals("*")) {
            return true;
        }
        return opName.equals(entry.name);
    }

    private boolean addressMatch(PathAddress opAddr, OperationEntry entry) {
        boolean match;
        boolean bl = match = entry.address.size() == opAddr.size();
        if (match) {
            for (int i = 0; i < opAddr.size(); ++i) {
                if (this.pathElementMatch(opAddr.getElement(i), entry.address.getElement(i))) continue;
                match = false;
                break;
            }
        }
        return match;
    }

    private boolean pathElementMatch(PathElement element, PathElement operationEntryElement) {
        if (!operationEntryElement.getKey().equals("*") && !operationEntryElement.getKey().equals(element.getKey())) {
            return false;
        }
        if (operationEntryElement.getValue().equals("*")) {
            return true;
        }
        return operationEntryElement.getValue().equals(element.getValue());
    }

    public static void main(String[] args) {
        System.out.println(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"*", (String)"*"), PathElement.pathElement((String)"x", (String)"*")}));
    }

    public static class OperationEntry
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private volatile PathAddress address;
        private volatile String name;
        private volatile Action action;
        private volatile OperationFixer operationFixer;

        public OperationEntry(PathAddress address, String name, Action action, OperationFixer operationFixer) {
            if (operationFixer != null && !(operationFixer instanceof Serializable)) {
                throw new IllegalArgumentException("operationFixer must be serializable");
            }
            this.address = address;
            this.name = name;
            this.action = action;
            this.operationFixer = operationFixer;
        }

        public OperationEntry() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.name);
            out.writeObject(this.address.toModelNode());
            out.writeObject((Object)this.action);
            out.writeObject(this.operationFixer);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = (String)in.readObject();
            this.address = PathAddress.pathAddress((ModelNode)((ModelNode)in.readObject()));
            this.action = (Action)((Object)in.readObject());
            this.operationFixer = (OperationFixer)in.readObject();
        }
    }

    public static enum Action {
        NOCHECK,
        RESOLVE;

    }

    public static class Builder {
        List<OperationEntry> entries = new ArrayList<OperationEntry>();

        private Builder() {
        }

        public Builder addOperation(PathAddress pathAddress, String name, Action action, OperationFixer operationFixer) {
            this.entries.add(new OperationEntry(pathAddress, name, action, operationFixer));
            return this;
        }

        public ModelTestOperationValidatorFilter build() {
            return new ModelTestOperationValidatorFilter(this.entries);
        }
    }
}

