/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.modules.filter.ClassFilter;

public class ChildFirstClassLoader
extends URLClassLoader {
    private final ClassLoader parent;
    private final Set<Pattern> parentFirst;
    private final Set<Pattern> childFirst;
    private final ClassFilter parentExclusionFilter;

    ChildFirstClassLoader(ClassLoader parent, Set<Pattern> parentFirst, Set<Pattern> childFirst, ClassFilter parentExclusionFilter, URL ... urls) {
        super(urls, parent);
        assert (parent != null) : "Null parent";
        assert (parentFirst != null) : "Null parent first";
        assert (childFirst != null) : "Null child first";
        this.parent = parent;
        this.childFirst = Collections.unmodifiableSet(childFirst);
        this.parentFirst = Collections.unmodifiableSet(parentFirst);
        this.parentExclusionFilter = parentExclusionFilter;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.loadFromParentOnly(name)) {
            return this.parent.loadClass(name);
        }
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            block7: {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (this.parentExclusionFilter == null || !this.parentExclusionFilter.accept(name)) break block7;
                    throw e;
                }
            }
            if (c == null) {
                c = this.parent.loadClass(name);
            }
            if (c == null) {
                this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url != null) {
            return url;
        }
        return super.getResource(name);
    }

    private boolean loadFromParentOnly(String className) {
        boolean parent = false;
        for (Pattern pattern : this.parentFirst) {
            if (!pattern.matcher(className).matches()) continue;
            parent = true;
            break;
        }
        if (parent) {
            for (Pattern pattern : this.childFirst) {
                if (!pattern.matcher(className).matches()) continue;
                return false;
            }
        }
        return parent;
    }
}

