/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.dmr.ModelNode;

public class ModelTestBootOperationsBuilder {
    private final Class<?> testClass;
    private final BootOperationParser xmlParser;
    private List<ModelNode> bootOperations = Collections.emptyList();
    private String subsystemXml;
    private String subsystemXmlResource;
    private boolean built;

    public ModelTestBootOperationsBuilder(Class<?> testClass, BootOperationParser xmlParser) {
        this.testClass = testClass;
        this.xmlParser = xmlParser;
    }

    public ModelTestBootOperationsBuilder setXmlResource(String resource) throws IOException, XMLStreamException {
        this.validateNotAlreadyBuilt();
        this.validateSubsystemConfig();
        this.subsystemXmlResource = resource;
        this.internalSetSubsystemXml(ModelTestUtils.readResource(this.testClass, resource));
        return this;
    }

    public ModelTestBootOperationsBuilder setXml(String subsystemXml) throws XMLStreamException {
        this.validateNotAlreadyBuilt();
        this.validateSubsystemConfig();
        this.subsystemXml = subsystemXml;
        this.bootOperations = this.xmlParser.parse(subsystemXml);
        return this;
    }

    public ModelTestBootOperationsBuilder setBootOperations(List<ModelNode> bootOperations) {
        this.validateNotAlreadyBuilt();
        this.validateSubsystemConfig();
        this.bootOperations = bootOperations;
        return this;
    }

    private void internalSetSubsystemXml(String subsystemXml) throws XMLStreamException {
        this.subsystemXml = subsystemXml;
        this.bootOperations = this.xmlParser.parse(subsystemXml);
    }

    private void validateSubsystemConfig() {
        if (this.subsystemXmlResource != null) {
            throw new IllegalArgumentException("Xml resource is already set");
        }
        if (this.subsystemXml != null) {
            throw new IllegalArgumentException("Xml string is already set");
        }
        if (this.bootOperations != Collections.EMPTY_LIST) {
            throw new IllegalArgumentException("Boot operations are already set");
        }
    }

    public void validateNotAlreadyBuilt() {
        if (this.built) {
            throw new IllegalStateException("Already built");
        }
    }

    public List<ModelNode> build() {
        this.built = true;
        return this.bootOperations;
    }

    public static interface BootOperationParser {
        public List<ModelNode> parse(String var1) throws XMLStreamException;
    }
}

