/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.ManagementSecurityIdentitySupplier;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.validation.OperationValidator;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestKernelServicesImpl;
import org.jboss.as.model.test.ModelTestOperationValidatorFilter;
import org.jboss.as.model.test.StringConfigurationPersister;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.junit.Assert;

public abstract class ModelTestModelControllerService
extends AbstractControllerService {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final StringConfigurationPersister persister;
    private final TransformerRegistry transformerRegistry;
    private final ModelTestOperationValidatorFilter validateOpsFilter;
    private final RunningModeControl runningModeControl;
    private volatile ManagementResourceRegistration rootRegistration;
    private volatile Throwable error;
    private volatile boolean bootSuccess;
    private static final String BOOT_ERROR_MESSAGE = "Failure while executing boot operations";

    protected ModelTestModelControllerService(ProcessType processType, RunningModeControl runningModeControl, TransformerRegistry transformerRegistry, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, ResourceDefinition rootResourceDefinition, ControlledProcessState processState, ExpressionResolver expressionResolver, CapabilityRegistry capabilityRegistry, Controller23x version) {
        super(processType, runningModeControl, (ConfigurationPersister)persister, processState == null ? new ControlledProcessState(true) : processState, rootResourceDefinition, null, expressionResolver, AuditLogger.NO_OP_LOGGER, new DelegatingConfigurableAuthorizer(), new ManagementSecurityIdentitySupplier(), capabilityRegistry);
        this.persister = persister;
        this.transformerRegistry = transformerRegistry;
        this.validateOpsFilter = validateOpsFilter;
        this.runningModeControl = runningModeControl;
    }

    protected ModelTestModelControllerService(ProcessType processType, RunningModeControl runningModeControl, TransformerRegistry transformerRegistry, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, ResourceDefinition resourceDefinition, ControlledProcessState processState, CapabilityRegistry capabilityRegistry, Controller23x version) {
        super(processType, runningModeControl, (ConfigurationPersister)persister, processState == null ? new ControlledProcessState(true) : processState, resourceDefinition, null, ExpressionResolver.TEST_RESOLVER, AuditLogger.NO_OP_LOGGER, new DelegatingConfigurableAuthorizer(), new ManagementSecurityIdentitySupplier(), capabilityRegistry);
        this.persister = persister;
        this.transformerRegistry = transformerRegistry;
        this.validateOpsFilter = validateOpsFilter;
        this.runningModeControl = runningModeControl;
    }

    protected ModelTestModelControllerService(ProcessType processType, RunningModeControl runningModeControl, TransformerRegistry transformerRegistry, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, ResourceDefinition rootResourceDefinition, ControlledProcessState processState, ExpressionResolver expressionResolver, CapabilityRegistry capabilityRegistry, Controller29x version) {
        super(null, null, processType, runningModeControl, (ConfigurationPersister)persister, processState == null ? new ControlledProcessState(true) : processState, rootResourceDefinition, null, expressionResolver, AuditLogger.NO_OP_LOGGER, new DelegatingConfigurableAuthorizer(), new ManagementSecurityIdentitySupplier(), capabilityRegistry, null);
        this.persister = persister;
        this.transformerRegistry = transformerRegistry;
        this.validateOpsFilter = validateOpsFilter;
        this.runningModeControl = runningModeControl;
    }

    protected ModelTestModelControllerService(ProcessType processType, RunningModeControl runningModeControl, TransformerRegistry transformerRegistry, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, ResourceDefinition resourceDefinition, ControlledProcessState processState, CapabilityRegistry capabilityRegistry, Controller29x version) {
        super(null, null, processType, runningModeControl, (ConfigurationPersister)persister, processState == null ? new ControlledProcessState(true) : processState, resourceDefinition, null, ExpressionResolver.TEST_RESOLVER, AuditLogger.NO_OP_LOGGER, new DelegatingConfigurableAuthorizer(), new ManagementSecurityIdentitySupplier(), capabilityRegistry, null);
        this.persister = persister;
        this.transformerRegistry = transformerRegistry;
        this.validateOpsFilter = validateOpsFilter;
        this.runningModeControl = runningModeControl;
    }

    protected ModelTestModelControllerService(ProcessType processType, RunningModeControl runningModeControl, TransformerRegistry transformerRegistry, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, DelegatingResourceDefinition rootResourceDefinition, ControlledProcessState processState, ExpressionResolver expressionResolver, CapabilityRegistry capabilityRegistry) {
        super(null, null, processType, Stability.DEFAULT, runningModeControl, (ConfigurationPersister)persister, processState == null ? new ControlledProcessState(true) : processState, (ResourceDefinition)rootResourceDefinition, null, expressionResolver, AuditLogger.NO_OP_LOGGER, new DelegatingConfigurableAuthorizer(), new ManagementSecurityIdentitySupplier(), capabilityRegistry, null);
        this.persister = persister;
        this.transformerRegistry = transformerRegistry;
        this.validateOpsFilter = validateOpsFilter;
        this.runningModeControl = runningModeControl;
    }

    protected ModelTestModelControllerService(ProcessType processType, Stability stability, RunningModeControl runningModeControl, TransformerRegistry transformerRegistry, StringConfigurationPersister persister, ModelTestOperationValidatorFilter validateOpsFilter, ResourceDefinition resourceDefinition, ExpressionResolver expressionResolver, ControlledProcessState processState, CapabilityRegistry capabilityRegistry) {
        super(null, null, processType, stability, runningModeControl, (ConfigurationPersister)persister, processState == null ? new ControlledProcessState(true) : processState, resourceDefinition, null, expressionResolver != null ? expressionResolver : ExpressionResolver.TEST_RESOLVER, AuditLogger.NO_OP_LOGGER, new DelegatingConfigurableAuthorizer(), new ManagementSecurityIdentitySupplier(), capabilityRegistry, null);
        this.persister = persister;
        this.transformerRegistry = transformerRegistry;
        this.validateOpsFilter = validateOpsFilter;
        this.runningModeControl = runningModeControl;
    }

    public boolean isSuccessfulBoot() {
        return this.bootSuccess;
    }

    public Throwable getBootError() {
        return this.error;
    }

    RunningMode getRunningMode() {
        return this.runningModeControl.getRunningMode();
    }

    ProcessType getProcessType() {
        return this.processType;
    }

    protected void initModel(ManagementModel managementModel, Resource modelControllerResource) {
        this.rootRegistration = managementModel.getRootResourceRegistration();
        this.initCoreModel(managementModel, modelControllerResource);
        this.initExtraModel(managementModel);
    }

    protected void initCoreModel(ManagementModel managementModel, Resource modelControllerResource) {
        ManagementResourceRegistration rootRegistration = managementModel.getRootResourceRegistration();
        GlobalOperationHandlers.registerGlobalOperations((ManagementResourceRegistration)rootRegistration, (ProcessType)ProcessType.STANDALONE_SERVER);
        rootRegistration.registerOperationHandler(CompositeOperationHandler.DEFINITION, (OperationStepHandler)CompositeOperationHandler.INSTANCE);
    }

    protected void initExtraModel(ManagementModel managementModel) {
    }

    TransformerRegistry getTransformersRegistry() {
        return this.transformerRegistry;
    }

    protected ModelControllerClientFactory getModelControllerClientFactory() {
        return super.getModelControllerClientFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) throws ConfigurationPersistenceException {
        try {
            this.preBoot(bootOperations, rollbackOnRuntimeFailure);
            ArrayList<ModelNode> validationList = new ArrayList<ModelNode>();
            for (ModelNode op : bootOperations) {
                ModelNode toValidate = this.validateOpsFilter.adjustForValidation(op.clone());
                if (toValidate == null) continue;
                validationList.add(toValidate);
            }
            this.bootSuccess = super.boot(this.persister.getBootOperations(), rollbackOnRuntimeFailure);
            OperationValidator validator = new OperationValidator((ImmutableManagementResourceRegistration)this.rootRegistration);
            for (ModelNode op : validationList) {
                validator.validateOperation(op);
            }
            if (!this.bootSuccess) {
                this.error = new BootOperationFailedException(BOOT_ERROR_MESSAGE, super.getBootErrors());
            }
            boolean bl = this.bootSuccess;
            return bl;
        }
        catch (Exception e) {
            this.error = e;
        }
        catch (Throwable t) {
            this.error = new Exception(t);
        }
        finally {
            this.postBoot();
        }
        return false;
    }

    protected void preBoot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) {
    }

    protected void postBoot() {
    }

    protected void bootThreadDone() {
        try {
            super.bootThreadDone();
        }
        finally {
            this.countdownDoneLatch();
        }
    }

    protected void countdownDoneLatch() {
        this.latch.countDown();
    }

    public void start(StartContext context) throws StartException {
        try {
            super.start(context);
        }
        catch (StartException e) {
            this.error = e;
            e.printStackTrace();
            this.latch.countDown();
            throw e;
        }
        catch (Throwable t) {
            this.error = t;
            this.latch.countDown();
            throw new StartException(t);
        }
    }

    public void waitForSetup() throws Exception {
        this.latch.await();
        if (this.error != null) {
            if (this.error instanceof Exception) {
                throw (Exception)this.error;
            }
            throw new RuntimeException(this.error);
        }
    }

    public ManagementResourceRegistration getRootRegistration() {
        return this.rootRegistration;
    }

    public static Resource grabRootResource(ModelTestKernelServices<?> kernelServices) {
        AtomicReference resourceRef = new AtomicReference();
        ModelNode fakeOP = new ModelNode();
        fakeOP.get("operation").set("fake");
        ((ModelTestKernelServicesImpl)kernelServices).internalExecute(fakeOP, (context, operation) -> {
            resourceRef.set(context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            context.getResult().setEmptyObject();
        });
        Resource rootResource = (Resource)resourceRef.get();
        Assert.assertNotNull((Object)rootResource);
        return rootResource;
    }

    protected ModelNode internalExecute(ModelNode operationNode, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler prepareStep) {
        Operation operation = attachments == null ? Operation.Factory.create((ModelNode)operationNode) : Operation.Factory.create((ModelNode)operationNode, (List)attachments.getInputStreams(), (boolean)attachments.isAutoCloseStreams());
        return super.internalExecute(operation, handler, control, prepareStep).getResponseNode();
    }

    public static class Controller29x {
        public static Controller29x INSTANCE = new Controller29x();

        private Controller29x() {
        }
    }

    public static class Controller23x {
        public static Controller23x INSTANCE = new Controller23x();

        private Controller23x() {
        }
    }

    private static class BootOperationFailedException
    extends OperationFailedException {
        public BootOperationFailedException(String msg, ModelNode description) {
            super(msg, description);
        }
    }

    public static class DelegatingResourceDefinition
    implements ResourceDefinition {
        private volatile ResourceDefinition delegate;

        public void setDelegate(ResourceDefinition delegate) {
            this.delegate = delegate;
        }

        public void registerOperations(ManagementResourceRegistration resourceRegistration) {
            this.delegate.registerOperations(resourceRegistration);
        }

        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
            this.delegate.registerChildren(resourceRegistration);
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            this.delegate.registerAttributes(resourceRegistration);
        }

        public void registerNotifications(ManagementResourceRegistration resourceRegistration) {
            this.delegate.registerNotifications(resourceRegistration);
        }

        public PathElement getPathElement() {
            return this.delegate.getPathElement();
        }

        public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration resourceRegistration) {
            return this.delegate.getDescriptionProvider(resourceRegistration);
        }

        public List<AccessConstraintDefinition> getAccessConstraints() {
            if (this.delegate == null) {
                return Collections.emptyList();
            }
            return this.delegate.getAccessConstraints();
        }

        public boolean isRuntime() {
            return this.delegate.isRuntime();
        }

        public boolean isOrderedChild() {
            if (this.delegate == null) {
                return false;
            }
            return this.delegate.isOrderedChild();
        }

        public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
            this.delegate.registerCapabilities(resourceRegistration);
        }

        public Stability getStability() {
            return Optional.ofNullable(this.delegate).map(Feature::getStability).orElse(Stability.DEFAULT);
        }
    }
}

