/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transfer.TransferResource;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;

class MavenUtil {
    private static final String AETHER_API_NAME = File.separatorChar == '/' ? "/org/eclipse/aether/aether-api/" : "\\org\\eclipse\\aether\\aether-api\\";
    private final RepositorySystem REPOSITORY_SYSTEM;
    private final List<RemoteRepository> remoteRepositories;
    private static String mavenRepository;

    private MavenUtil(RepositorySystem repositorySystem, List<RemoteRepository> remoteRepositories) {
        this.REPOSITORY_SYSTEM = repositorySystem;
        this.remoteRepositories = remoteRepositories;
    }

    static MavenUtil create(boolean useEapRepository) {
        return new MavenUtil(MavenUtil.newRepositorySystem(), MavenUtil.createRemoteRepositories(useEapRepository));
    }

    URL createMavenGavURL(String artifactGav) throws MalformedURLException {
        DefaultArtifact artifact = new DefaultArtifact(artifactGav);
        if (artifact.getVersion() == null) {
            throw new IllegalArgumentException("Null version");
        }
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        try {
            versionScheme.parseVersion(artifact.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            versionScheme.parseVersionRange(artifact.getVersion());
            throw new IllegalArgumentException(artifact.getVersion() + " is a version range. A specific version is needed");
        }
        catch (InvalidVersionSpecificationException expected) {
            ArtifactResult artifactResult;
            RepositorySystemSession session = this.newRepositorySystemSession();
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)artifact);
            for (RemoteRepository remoteRepo : this.remoteRepositories) {
                artifactRequest.addRepository(remoteRepo);
            }
            try {
                artifactResult = this.REPOSITORY_SYSTEM.resolveArtifact(session, artifactRequest);
            }
            catch (ArtifactResolutionException e) {
                throw new RuntimeException(e);
            }
            File file = artifactResult.getArtifact().getFile().getAbsoluteFile();
            System.out.println(file);
            return file.toURI().toURL();
        }
    }

    List<URL> createMavenGavRecursiveURLs(String artifactGav, String ... excludes) throws MalformedURLException, DependencyCollectionException, DependencyResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(artifactGav);
        if (artifact.getVersion() == null) {
            throw new IllegalArgumentException("Null version");
        }
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        try {
            versionScheme.parseVersion(artifact.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            versionScheme.parseVersionRange(artifact.getVersion());
            throw new IllegalArgumentException(artifact.getVersion() + " is a version range. A specific version is needed");
        }
        catch (InvalidVersionSpecificationException expected) {
            ArtifactResult artifactResult;
            RepositorySystemSession session = this.newRepositorySystemSession();
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)artifact);
            for (RemoteRepository remoteRepo : this.remoteRepositories) {
                artifactRequest.addRepository(remoteRepo);
            }
            try {
                artifactResult = this.REPOSITORY_SYSTEM.resolveArtifact(session, artifactRequest);
            }
            catch (ArtifactResolutionException e) {
                throw new RuntimeException(e);
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(MavenUtil.artifactToUrl(artifactResult.getArtifact()));
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new Dependency((Artifact)artifact, "compile"));
            for (RemoteRepository remoteRepo : this.remoteRepositories) {
                collectRequest.addRepository(remoteRepo);
            }
            DependencyNode node = this.REPOSITORY_SYSTEM.collectDependencies(session, collectRequest).getRoot();
            ExclusionsDependencyFilter filter = new ExclusionsDependencyFilter(Arrays.asList(excludes));
            DependencyRequest dependencyRequest = new DependencyRequest(node, (DependencyFilter)filter);
            this.REPOSITORY_SYSTEM.resolveDependencies(session, dependencyRequest);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            for (Artifact cur : nlg.getArtifacts(false)) {
                urls.add(MavenUtil.artifactToUrl(cur));
            }
            System.out.println("--------------------");
            System.out.println(nlg.getClassPath());
            System.out.println("--------------------");
            return urls;
        }
    }

    private static List<RemoteRepository> createRemoteRepositories(boolean useEapRepository) {
        String remoteReposFromSysProp = System.getProperty("org.jboss.model.test.maven.repository.urls");
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        if (remoteReposFromSysProp == null || remoteReposFromSysProp.trim().length() == 0 || remoteReposFromSysProp.startsWith("${")) {
            if (useEapRepository) {
                remoteRepositories.add(new RemoteRepository.Builder("product-repository", "default", "https://maven.repository.redhat.com/nexus/content/groups/product-techpreview/").build());
            }
            remoteRepositories.add(new RemoteRepository.Builder("jboss-developer", "default", "http://repository.jboss.org/nexus/content/groups/developer/").build());
        } else {
            int i = 0;
            for (String repoUrl : remoteReposFromSysProp.split(",")) {
                remoteRepositories.add(new RemoteRepository.Builder("repo" + i, "default", repoUrl.trim()).build());
                ++i;
            }
        }
        return remoteRepositories;
    }

    private RepositorySystemSession newRepositorySystemSession() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(MavenUtil.determineLocalMavenRepositoryHack());
        session.setLocalRepositoryManager(this.REPOSITORY_SYSTEM.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)new ConsoleTransferListener());
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        return session;
    }

    private static String determineLocalMavenRepositoryHack() {
        if (mavenRepository == null) {
            String localRepositoryRoot;
            String classPath = System.getProperty("java.class.path");
            int end = classPath.indexOf(AETHER_API_NAME) + 1;
            int start = classPath.lastIndexOf(File.pathSeparatorChar, end) + 1;
            mavenRepository = localRepositoryRoot = classPath.substring(start, end);
        }
        return mavenRepository;
    }

    private static URL artifactToUrl(Artifact artifact) throws MalformedURLException {
        return artifact.getFile().toURI().toURL();
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        locator.addService(MetadataGeneratorFactory.class, SnapshotMetadataGeneratorFactory.class);
        locator.addService(MetadataGeneratorFactory.class, VersionsMetadataGeneratorFactory.class);
        locator.setErrorHandler((DefaultServiceLocator.ErrorHandler)new MyErrorHandler());
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static class ConsoleTransferListener
    extends AbstractTransferListener {
        private PrintStream out;
        private Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
        private int lastLength;

        public ConsoleTransferListener() {
            this(null);
        }

        public ConsoleTransferListener(PrintStream out) {
            this.out = out != null ? out : System.out;
        }

        public void transferInitiated(TransferEvent event) {
            String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
            this.out.println(message + ": " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
        }

        public void transferProgressed(TransferEvent event) {
            TransferResource resource = event.getResource();
            this.downloads.put(resource, event.getTransferredBytes());
            StringBuilder buffer = new StringBuilder(64);
            for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
                long total = entry.getKey().getContentLength();
                long complete = entry.getValue();
                buffer.append(this.getStatus(complete, total)).append("  ");
            }
            int pad = this.lastLength - buffer.length();
            this.lastLength = buffer.length();
            this.pad(buffer, pad);
            buffer.append('\r');
            this.out.print(buffer);
        }

        private String getStatus(long complete, long total) {
            if (total >= 1024L) {
                return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
            }
            if (total >= 0L) {
                return complete + "/" + total + " B ";
            }
            if (complete >= 1024L) {
                return this.toKB(complete) + " KB ";
            }
            return complete + " B ";
        }

        private void pad(StringBuilder buffer, int spaces) {
            String block = "                                        ";
            while (spaces > 0) {
                int n = Math.min(spaces, block.length());
                buffer.append(block, 0, n);
                spaces -= n;
            }
        }

        public void transferSucceeded(TransferEvent event) {
            this.transferCompleted(event);
            TransferResource resource = event.getResource();
            long contentLength = event.getTransferredBytes();
            if (contentLength >= 0L) {
                String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
                String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
                String throughput = "";
                long duration = System.currentTimeMillis() - resource.getTransferStartTime();
                if (duration > 0L) {
                    DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                    double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
                    throughput = " at " + format.format(kbPerSec) + " KB/sec";
                }
                this.out.println(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + throughput + ")");
            }
        }

        public void transferFailed(TransferEvent event) {
            this.transferCompleted(event);
            event.getException().printStackTrace(this.out);
        }

        private void transferCompleted(TransferEvent event) {
            this.downloads.remove(event.getResource());
            StringBuilder buffer = new StringBuilder(64);
            this.pad(buffer, this.lastLength);
            buffer.append('\r');
            this.out.print(buffer);
        }

        public void transferCorrupted(TransferEvent event) {
            event.getException().printStackTrace(this.out);
        }

        protected long toKB(long bytes) {
            return (bytes + 1023L) / 1024L;
        }
    }

    private static class ConsoleRepositoryListener
    extends AbstractRepositoryListener {
        private PrintStream out;

        public ConsoleRepositoryListener() {
            this(null);
        }

        public ConsoleRepositoryListener(PrintStream out) {
            this.out = out != null ? out : System.out;
        }

        public void artifactDeployed(RepositoryEvent event) {
            this.out.println("Deployed " + event.getArtifact() + " to " + event.getRepository());
        }

        public void artifactDeploying(RepositoryEvent event) {
            this.out.println("Deploying " + event.getArtifact() + " to " + event.getRepository());
        }

        public void artifactDescriptorInvalid(RepositoryEvent event) {
            this.out.println("Invalid artifact descriptor for " + event.getArtifact() + ": " + event.getException().getMessage());
        }

        public void artifactDescriptorMissing(RepositoryEvent event) {
            this.out.println("Missing artifact descriptor for " + event.getArtifact());
        }

        public void artifactInstalled(RepositoryEvent event) {
            this.out.println("Installed " + event.getArtifact() + " to " + event.getFile());
        }

        public void artifactInstalling(RepositoryEvent event) {
            this.out.println("Installing " + event.getArtifact() + " to " + event.getFile());
        }

        public void artifactResolved(RepositoryEvent event) {
            this.out.println("Resolved artifact " + event.getArtifact() + " from " + event.getRepository());
        }

        public void artifactDownloading(RepositoryEvent event) {
            this.out.println("Downloading artifact " + event.getArtifact() + " from " + event.getRepository());
        }

        public void artifactDownloaded(RepositoryEvent event) {
            this.out.println("Downloaded artifact " + event.getArtifact() + " from " + event.getRepository());
        }

        public void artifactResolving(RepositoryEvent event) {
            this.out.println("Resolving artifact " + event.getArtifact());
        }

        public void metadataDeployed(RepositoryEvent event) {
            this.out.println("Deployed " + event.getMetadata() + " to " + event.getRepository());
        }

        public void metadataDeploying(RepositoryEvent event) {
            this.out.println("Deploying " + event.getMetadata() + " to " + event.getRepository());
        }

        public void metadataInstalled(RepositoryEvent event) {
            this.out.println("Installed " + event.getMetadata() + " to " + event.getFile());
        }

        public void metadataInstalling(RepositoryEvent event) {
            this.out.println("Installing " + event.getMetadata() + " to " + event.getFile());
        }

        public void metadataInvalid(RepositoryEvent event) {
            this.out.println("Invalid metadata " + event.getMetadata());
        }

        public void metadataResolved(RepositoryEvent event) {
            this.out.println("Resolved metadata " + event.getMetadata() + " from " + event.getRepository());
        }

        public void metadataResolving(RepositoryEvent event) {
            this.out.println("Resolving metadata " + event.getMetadata() + " from " + event.getRepository());
        }
    }

    protected static class MyErrorHandler
    extends DefaultServiceLocator.ErrorHandler {
        protected MyErrorHandler() {
        }

        public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
            System.out.println("Could not create type: " + type + " impl: " + impl);
            exception.printStackTrace();
        }
    }
}

