/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class MavenSettings {
    private static final Object settingLoaderMutex = new Object();
    private static volatile MavenSettings mavenSettings;
    private Path localRepository = null;
    private final List<String> remoteRepositories = new LinkedList<String>();
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();
    private final List<String> activeProfileNames = new LinkedList<String>();

    MavenSettings() {
        this.configureDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MavenSettings getSettings() {
        if (mavenSettings != null) {
            return mavenSettings;
        }
        Object object = settingLoaderMutex;
        synchronized (object) {
            if (mavenSettings != null) {
                return mavenSettings;
            }
            mavenSettings = MavenSettings.doIo(() -> {
                String mavenHome;
                MavenSettings settings = new MavenSettings();
                Path m2 = Paths.get(System.getProperty("user.home"), ".m2");
                Path settingsPath = m2.resolve("settings.xml");
                if (Files.notExists(settingsPath, new LinkOption[0]) && (mavenHome = System.getenv("M2_HOME")) != null) {
                    settingsPath = Paths.get(mavenHome, "conf", "settings.xml");
                }
                if (Files.exists(settingsPath, new LinkOption[0])) {
                    MavenSettings.parseSettingsXml(settingsPath, settings);
                }
                if (settings.getLocalRepository() == null) {
                    Path repository = m2.resolve("repository");
                    settings.setLocalRepository(repository);
                }
                settings.resolveActiveSettings();
                return settings;
            });
            return mavenSettings;
        }
    }

    private static <T> T doIo(PrivilegedExceptionAction<T> action) throws RuntimeException {
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getCause();
            }
            catch (IOException | Error | RuntimeException e1) {
                throw new RuntimeException(e1);
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
    }

    static MavenSettings parseSettingsXml(Path settings, MavenSettings mavenSettings) throws IOException {
        try {
            int eventType;
            InputStream source = Files.newInputStream(settings, StandardOpenOption.READ);
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(source);
            while ((eventType = reader.next()) != 8) {
                switch (eventType) {
                    case 1: {
                        switch (reader.getLocalName()) {
                            case "settings": {
                                MavenSettings.parseSettings(reader, mavenSettings);
                            }
                        }
                    }
                }
            }
            return mavenSettings;
        }
        catch (XMLStreamException e) {
            throw new IOException("Could not parse maven settings.xml", e);
        }
    }

    private static void parseSettings(XMLStreamReader reader, MavenSettings mavenSettings) throws XMLStreamException, IOException {
        int eventType;
        block26: while ((eventType = reader.nextTag()) != 8) {
            switch (eventType) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "localRepository": {
                            String localRepository = reader.getElementText();
                            if (localRepository == null || localRepository.trim().isEmpty()) continue block26;
                            mavenSettings.setLocalRepository(Paths.get(localRepository, new String[0]));
                            continue block26;
                        }
                        case "profiles": {
                            while ((eventType = reader.nextTag()) != 8 && eventType == 1) {
                                switch (reader.getLocalName()) {
                                    case "profile": {
                                        MavenSettings.parseProfile(reader, mavenSettings);
                                    }
                                }
                            }
                            continue block26;
                        }
                        case "activeProfiles": {
                            while ((eventType = reader.nextTag()) != 8 && eventType == 1) {
                                switch (reader.getLocalName()) {
                                    case "activeProfile": {
                                        mavenSettings.addActiveProfile(reader.getElementText());
                                    }
                                }
                            }
                            continue block26;
                        }
                    }
                    MavenSettings.skip(reader);
                    continue block26;
                }
            }
            throw new XMLStreamException("Unexpected content", reader.getLocation());
        }
        throw new XMLStreamException("Unexpected end of document", reader.getLocation());
    }

    private static void parseProfile(XMLStreamReader reader, MavenSettings mavenSettings) throws XMLStreamException, IOException {
        int eventType;
        Profile profile = new Profile();
        block14: while ((eventType = reader.nextTag()) != 8 && eventType == 1) {
            switch (reader.getLocalName()) {
                case "id": {
                    profile.setId(reader.getElementText());
                    continue block14;
                }
                case "repositories": {
                    while ((eventType = reader.nextTag()) != 8 && eventType == 1) {
                        switch (reader.getLocalName()) {
                            case "repository": {
                                MavenSettings.parseRepository(reader, profile);
                            }
                        }
                    }
                    continue block14;
                }
            }
            MavenSettings.skip(reader);
        }
        mavenSettings.addProfile(profile);
    }

    private static void parseRepository(XMLStreamReader reader, Profile profile) throws XMLStreamException, IOException {
        int eventType;
        block6: while ((eventType = reader.nextTag()) != 8 && eventType == 1) {
            switch (reader.getLocalName()) {
                case "url": {
                    profile.addRepository(reader.getElementText());
                    continue block6;
                }
            }
            MavenSettings.skip(reader);
        }
    }

    private static void skip(XMLStreamReader parser) throws XMLStreamException, IOException {
        if (parser.getEventType() != 1) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.next()) {
                case 2: {
                    --depth;
                    break;
                }
                case 1: {
                    ++depth;
                }
            }
        }
    }

    private void configureDefaults() {
        String remoteRepository;
        this.remoteRepositories.add("https://repo1.maven.org/maven2/");
        String localRepositoryPath = System.getProperty("localRepository");
        if (localRepositoryPath != null && !localRepositoryPath.trim().isEmpty()) {
            this.localRepository = Paths.get(localRepositoryPath, new String[0]);
        }
        if ((localRepositoryPath = System.getProperty("maven.repo.local")) != null && !localRepositoryPath.trim().isEmpty()) {
            this.localRepository = Paths.get(localRepositoryPath, new String[0]);
        }
        if ((remoteRepository = System.getProperty("remote.maven.repo")) != null) {
            for (String repo : remoteRepository.split(",")) {
                if (!repo.endsWith("/")) {
                    repo = repo + "/";
                }
                this.remoteRepositories.add(repo);
            }
        }
    }

    private void setLocalRepository(Path localRepository) {
        this.localRepository = localRepository;
    }

    Path getLocalRepository() {
        return this.localRepository;
    }

    List<String> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    private void addProfile(Profile profile) {
        this.profiles.put(profile.getId(), profile);
    }

    private void addActiveProfile(String profileName) {
        this.activeProfileNames.add(profileName);
    }

    private void resolveActiveSettings() {
        for (String name : this.activeProfileNames) {
            Profile p = this.profiles.get(name);
            if (p == null) continue;
            this.remoteRepositories.addAll(p.getRepositories());
        }
    }

    static final class Profile {
        private String id;
        final List<String> repositories = new LinkedList<String>();

        Profile() {
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        void addRepository(String url) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            this.repositories.add(url);
        }

        List<String> getRepositories() {
            return this.repositories;
        }
    }
}

