/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.management.client.content;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.management.client.content.ContentStorageException;
import org.jboss.as.management.client.content.ManagedDMRContentLogger;
import org.jboss.as.management.client.content.ManagedDMRContentResource;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.vfs.VirtualFile;

public class ManagedDMRContentTypeResource
implements Resource.ResourceEntry {
    private final PathAddress address;
    private final String childType;
    private final ContentRepository contentRepository;
    private final Map<String, ManagedContent> content = new TreeMap<String, ManagedContent>();
    private final ModelNode model = new ModelNode();
    private final MessageDigest messageDigest;

    @Deprecated
    public ManagedDMRContentTypeResource(PathElement pathElement, String childType, byte[] initialHash, ContentRepository contentRepository) {
        this(PathAddress.pathAddress((PathElement[])new PathElement[]{pathElement}), childType, initialHash, contentRepository);
    }

    public ManagedDMRContentTypeResource(PathAddress address, String childType, byte[] initialHash, ContentRepository contentRepository) {
        this.childType = childType;
        this.contentRepository = contentRepository;
        this.address = address;
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw ManagedDMRContentLogger.ROOT_LOGGER.messageDigestAlgorithmNotAvailable(e);
        }
        this.model.get("hash");
        if (initialHash != null) {
            this.loadContent(initialHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedDMRContentTypeResource(ManagedDMRContentTypeResource toCopy) {
        this.childType = toCopy.childType;
        this.contentRepository = toCopy.contentRepository;
        this.messageDigest = toCopy.messageDigest;
        this.address = toCopy.address;
        Map<String, ManagedContent> map = toCopy.content;
        synchronized (map) {
            for (Map.Entry<String, ManagedContent> entry : toCopy.content.entrySet()) {
                ManagedContent value = entry.getValue();
                this.content.put(entry.getKey(), new ManagedContent(value.getContent(), value.getHash()));
            }
        }
        this.model.set(toCopy.model);
    }

    public ModelNode getModel() {
        return this.model.clone();
    }

    public void writeModel(ModelNode newModel) {
        byte[] initialHash;
        if (this.model.hasDefined("hash")) {
            throw ControllerLogger.ROOT_LOGGER.immutableResource();
        }
        byte[] byArray = initialHash = newModel.hasDefined("hash") ? newModel.get("hash").asBytes() : null;
        if (initialHash != null) {
            this.loadContent(initialHash);
        }
    }

    public boolean isModelDefined() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getChild(PathElement element) {
        if (this.hasChildren(element.getKey())) {
            Map<String, ManagedContent> map = this.content;
            synchronized (map) {
                String name = element.getValue();
                ManagedContent managedContent = this.content.get(name);
                if (managedContent != null) {
                    return this.getChildEntry(name);
                }
            }
        }
        return null;
    }

    public Resource requireChild(PathElement address) {
        Resource resource = this.getChild(address);
        if (resource == null) {
            throw new Resource.NoSuchResourceException(address);
        }
        return resource;
    }

    public Resource navigate(PathAddress address) {
        if (address.size() == 0) {
            return this;
        }
        Resource child = this.requireChild(address.getElement(0));
        return address.size() == 1 ? child : child.navigate(address.subAddress(1));
    }

    public Set<String> getChildTypes() {
        return Collections.singleton(this.childType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if (!this.hasChildren(childType)) {
            return Collections.emptySet();
        }
        HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
        Map<String, ManagedContent> map = this.content;
        synchronized (map) {
            for (String name : this.content.keySet()) {
                result.add(this.getChildEntry(name));
            }
        }
        return result;
    }

    public final boolean hasChildren(String childType) {
        return this.childType.equals(childType);
    }

    public boolean hasChild(PathElement element) {
        return this.getChildrenNames(element.getKey()).contains(element.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getChildrenNames(String childType) {
        if (this.hasChildren(childType)) {
            Map<String, ManagedContent> map = this.content;
            synchronized (map) {
                return new HashSet<String>(this.content.keySet());
            }
        }
        return Collections.emptySet();
    }

    public void registerChild(PathElement address, Resource resource) {
        if (!this.childType.equals(address.getKey())) {
            throw ManagedDMRContentLogger.ROOT_LOGGER.illegalChildType(address.getKey(), this.childType);
        }
        if (!(resource instanceof ManagedDMRContentResource)) {
            throw ManagedDMRContentLogger.ROOT_LOGGER.illegalChildClass(resource.getClass());
        }
        ManagedDMRContentResource child = (ManagedDMRContentResource)ManagedDMRContentResource.class.cast(resource);
        child.setParent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource removeChild(PathElement address) {
        Resource toRemove = this.getChild(address);
        if (toRemove != null) {
            Map<String, ManagedContent> map = this.content;
            synchronized (map) {
                this.content.remove(address.getValue());
            }
            try {
                this.storeContent();
            }
            catch (IOException e) {
                throw new ContentStorageException(e);
            }
        }
        return toRemove;
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean isProxy() {
        return false;
    }

    public Resource clone() {
        return new ManagedDMRContentTypeResource(this);
    }

    public String getName() {
        return this.address.getLastElement().getValue();
    }

    public PathElement getPathElement() {
        return this.address.getLastElement();
    }

    ManagedContent getManagedContent(String name) {
        return this.content.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] storeManagedContent(String name, ModelNode content) throws IOException {
        byte[] hash = this.hashContent(content);
        Map<String, ManagedContent> map = this.content;
        synchronized (map) {
            this.content.put(name, new ManagedContent(content, hash));
        }
        this.storeContent();
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadContent(byte[] initialHash) {
        VirtualFile vf = this.contentRepository.getContent(initialHash);
        if (vf == null) {
            throw ManagedDMRContentLogger.ROOT_LOGGER.noContentFoundWithHash(HashUtil.bytesToHexString((byte[])initialHash));
        }
        InputStream is = null;
        try {
            is = vf.openStream();
            ModelNode node = ModelNode.fromStream((InputStream)is);
            if (node.isDefined()) {
                for (Property prop : node.asPropertyList()) {
                    ModelNode value = prop.getValue();
                    byte[] hash = this.hashContent(value);
                    Map<String, ManagedContent> map = this.content;
                    synchronized (map) {
                        this.content.put(prop.getName(), new ManagedContent(value, hash));
                    }
                }
            }
            this.model.get("hash").set(initialHash);
            this.contentRepository.addContentReference(new ContentReference(this.address.toCLIStyleString(), initialHash));
        }
        catch (IOException e) {
            throw new ContentStorageException(e);
        }
        finally {
            ManagedDMRContentTypeResource.safeClose(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeContent() throws IOException {
        boolean hasContent;
        ModelNode node = new ModelNode();
        ContentReference oldReference = null;
        if (this.model.hasDefined("hash")) {
            oldReference = new ContentReference(this.address.toCLIStyleString(), this.model.get("hash").asBytes());
        }
        Map<String, ManagedContent> map = this.content;
        synchronized (map) {
            boolean bl = hasContent = !this.content.isEmpty();
            if (hasContent) {
                for (Map.Entry<String, ManagedContent> entry : this.content.entrySet()) {
                    node.get(entry.getKey()).set(entry.getValue().content);
                }
            }
        }
        if (hasContent) {
            ByteArrayInputStream bais = new ByteArrayInputStream(node.toString().getBytes());
            byte[] ourHash = this.contentRepository.addContent((InputStream)bais);
            this.model.get("hash").set(ourHash);
            this.contentRepository.addContentReference(new ContentReference(this.address.toCLIStyleString(), ourHash));
        } else {
            this.model.get("hash").clear();
        }
        if (oldReference != null) {
            this.contentRepository.removeContent(oldReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] hashContent(ModelNode content) throws IOException {
        byte[] sha1Bytes;
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            int read;
            this.messageDigest.reset();
            DigestOutputStream dos = new DigestOutputStream(os, this.messageDigest);
            ByteArrayInputStream bis = new ByteArrayInputStream(content.toString().getBytes());
            byte[] bytes = new byte[8192];
            while ((read = bis.read(bytes)) > -1) {
                dos.write(bytes, 0, read);
            }
            sha1Bytes = this.messageDigest.digest();
        }
        return sha1Bytes;
    }

    private Resource.ResourceEntry getChildEntry(String name) {
        return new ManagedDMRContentResource(PathElement.pathElement((String)this.childType, (String)name), this);
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class ManagedContent {
        private final ModelNode content;
        private final byte[] hash;

        ManagedContent(ModelNode content, byte[] hash) {
            this.content = content;
            this.hash = hash;
        }

        ModelNode getContent() {
            return this.content.clone();
        }

        byte[] getHash() {
            return Arrays.copyOf(this.hash, this.hash.length);
        }
    }
}

