/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

abstract class LoggingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    static final PathAddress SUBSYSTEM_ADDRESS = PathAddress.pathAddress((PathElement[])new PathElement[]{LoggingResourceDefinition.SUBSYSTEM_PATH});

    LoggingSubsystemParser() {
    }

    static void addOperationAddress(ModelNode operation, PathAddress base, String key, String value) {
        operation.get("address").set(base.append(key, value).toModelNode());
    }

    static String readNameAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        return ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
    }

    static String readValueAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        return ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
    }

    static void parsePropertyElement(ModelNode operation, XMLExtendedStreamReader reader) throws XMLStreamException {
        while (reader.nextTag() != 2) {
            int cnt = reader.getAttributeCount();
            String name = null;
            String value = null;
            block5: for (int i = 0; i < cnt; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block5;
                    }
                    case VALUE: {
                        value = attrValue;
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME.getLocalName()));
            }
            operation.get(CommonAttributes.PROPERTIES.getName()).add(name, value == null ? new ModelNode() : new ModelNode(value));
            if (reader.nextTag() == 2) continue;
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseFilter(ModelNode operation, XMLExtendedStreamReader reader) throws XMLStreamException {
        StringBuilder filter = new StringBuilder();
        LoggingSubsystemParser.parseFilterChildren(filter, false, reader);
        operation.get(CommonAttributes.FILTER_SPEC.getName()).set(filter.toString());
    }

    private static void parseFilterChildren(StringBuilder filter, boolean useDelimiter, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        int delimiter = 44;
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACCEPT: {
                    filter.append("accept");
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    break;
                }
                case ALL: {
                    filter.append("all").append('(');
                    LoggingSubsystemParser.parseFilterChildren(filter, true, reader);
                    int index = filter.length() - 1;
                    if (filter.charAt(index) == ',') {
                        filter.setCharAt(index, ')');
                        break;
                    }
                    filter.append(')');
                    break;
                }
                case ANY: {
                    filter.append("any").append('(');
                    LoggingSubsystemParser.parseFilterChildren(filter, true, reader);
                    int index = filter.length() - 1;
                    if (filter.charAt(index) == ',') {
                        filter.setCharAt(index, ')');
                        break;
                    }
                    filter.append(')');
                    break;
                }
                case CHANGE_LEVEL: {
                    filter.append("levelChange").append('(').append(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.NEW_LEVEL.getName())).append(')');
                    break;
                }
                case DENY: {
                    filter.append("deny");
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    break;
                }
                case LEVEL: {
                    filter.append("levels").append('(').append(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.NAME.getName())).append(')');
                    break;
                }
                case LEVEL_RANGE: {
                    filter.append("levelRange");
                    boolean minInclusive = Boolean.parseBoolean(reader.getAttributeValue(null, CommonAttributes.MIN_INCLUSIVE.getName()));
                    boolean maxInclusive = Boolean.parseBoolean(reader.getAttributeValue(null, CommonAttributes.MAX_INCLUSIVE.getName()));
                    if (minInclusive) {
                        filter.append('[');
                    } else {
                        filter.append('(');
                    }
                    filter.append(reader.getAttributeValue(null, CommonAttributes.MIN_LEVEL.getName())).append(',');
                    filter.append(reader.getAttributeValue(null, CommonAttributes.MAX_LEVEL.getName()));
                    if (maxInclusive) {
                        filter.append(']');
                    } else {
                        filter.append(')');
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    break;
                }
                case MATCH: {
                    filter.append("match").append("(\"").append(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.FILTER_PATTERN.getName())).append("\")");
                    break;
                }
                case NOT: {
                    filter.append("not").append('(');
                    LoggingSubsystemParser.parseFilterChildren(filter, true, reader);
                    int index = filter.length() - 1;
                    if (filter.charAt(index) == ',') {
                        filter.setCharAt(index, ')');
                        break;
                    }
                    filter.append(')');
                    break;
                }
                case REPLACE: {
                    boolean replaceAll = Boolean.valueOf(reader.getAttributeValue(null, CommonAttributes.REPLACE_ALL.getName()));
                    if (replaceAll) {
                        filter.append("substituteAll");
                    } else {
                        filter.append("substitute");
                    }
                    filter.append("(\"").append(reader.getAttributeValue(null, CommonAttributes.FILTER_PATTERN.getName())).append('\"').append(',').append('\"').append(reader.getAttributeValue(null, CommonAttributes.REPLACEMENT.getName())).append("\")");
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            if (!useDelimiter) continue;
            filter.append(',');
        }
    }
}

