/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingProfileContextSelector;
import org.jboss.as.logging.LoggingProfileOperations;
import org.jboss.as.logging.filters.Filters;
import org.jboss.as.logging.loggers.LoggerAttributes;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.logmanager.ConfigurationPersistence;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class LoggingOperations {
    static void addCommitStep(OperationContext context, ConfigurationPersistence configurationPersistence) {
        LoggingOperations.addCommitStep(context, configurationPersistence, null);
    }

    static void addCommitStep(OperationContext context, ConfigurationPersistence configurationPersistence, OperationStepHandler afterPrepare) {
        if (context.getProcessType().isServer()) {
            context.addStep((OperationStepHandler)new CommitOperationStepHandler(configurationPersistence, afterPrepare), OperationContext.Stage.RUNTIME);
        }
    }

    private static ConfigurationPersistence getOrCreateConfigurationPersistence(OperationContext context) {
        ConfigurationPersistence configurationPersistence;
        PathAddress address = context.getCurrentAddress();
        if (LoggingProfileOperations.isLoggingProfileAddress(address)) {
            LogContext logContext = LoggingProfileContextSelector.getInstance().getOrCreate(LoggingProfileOperations.getLoggingProfileName(address));
            configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence(logContext);
        } else {
            configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence();
        }
        return configurationPersistence;
    }

    private static ConfigurationPersistence getConfigurationPersistence(OperationContext context) {
        PathAddress address = context.getCurrentAddress();
        LogContext logContext = LoggingProfileOperations.isLoggingProfileAddress(address) ? LoggingProfileContextSelector.getInstance().get(LoggingProfileOperations.getLoggingProfileName(address)) : LogContext.getLogContext();
        return ConfigurationPersistence.getConfigurationPersistence(logContext);
    }

    public static abstract class LoggingWriteAttributeHandler
    extends AbstractWriteAttributeHandler<ConfigurationPersistence> {
        protected final boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<ConfigurationPersistence> handbackHolder) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            ConfigurationPersistence configurationPersistence = LoggingOperations.getOrCreateConfigurationPersistence(context);
            LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
            handbackHolder.setHandback((Object)configurationPersistence);
            LoggingLogger.ROOT_LOGGER.tracef("Writing attribute \"%s\" with current value of \"%s\" to value \"%s\".", attributeName, currentValue.asString(), resolvedValue.asString());
            boolean restartRequired = this.applyUpdate(context, attributeName, name, resolvedValue, logContextConfiguration);
            OperationStepHandler afterPrepare = this.afterPrepare(logContextConfiguration, attributeName, resolvedValue, currentValue);
            LoggingOperations.addCommitStep(context, configurationPersistence, afterPrepare);
            return restartRequired;
        }

        protected OperationStepHandler afterPrepare(LogContextConfiguration logContextConfiguration, String attributeName, ModelNode resolvedValue, ModelNode currentValue) {
            return null;
        }

        protected abstract boolean applyUpdate(OperationContext var1, String var2, String var3, ModelNode var4, LogContextConfiguration var5) throws OperationFailedException;

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, ConfigurationPersistence configurationPersistence) throws OperationFailedException {
            LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
            logContextConfiguration.forget();
        }

        protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
            ModelNode submodel = model.getModel();
            if (submodel.hasDefined(CommonAttributes.FILTER.getName())) {
                String filterSpec = Filters.filterToFilterSpec(CommonAttributes.FILTER.resolveModelAttribute(context, submodel));
                submodel.remove(CommonAttributes.FILTER.getName());
                submodel.get(LoggerAttributes.FILTER_SPEC.getName()).set(filterSpec.isEmpty() ? new ModelNode() : new ModelNode(filterSpec));
            }
        }
    }

    public static abstract class LoggingRemoveOperationStepHandler
    extends AbstractRemoveStepHandler {
        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ConfigurationPersistence configurationPersistence = LoggingOperations.getOrCreateConfigurationPersistence(context);
            LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
            this.performRuntime(context, operation, model, logContextConfiguration);
            LoggingOperations.addCommitStep(context, configurationPersistence);
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ConfigurationPersistence configurationPersistence = LoggingOperations.getConfigurationPersistence(context);
            if (configurationPersistence != null) {
                configurationPersistence.rollback();
                this.revertRuntime(context, operation, model, configurationPersistence);
            }
        }

        protected void revertRuntime(OperationContext context, ModelNode operation, ModelNode model, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
        }

        protected abstract void performRuntime(OperationContext var1, ModelNode var2, ModelNode var3, LogContextConfiguration var4) throws OperationFailedException;
    }

    public static abstract class LoggingUpdateOperationStepHandler
    implements OperationStepHandler {
        private final AttributeDefinition[] attributes;

        protected LoggingUpdateOperationStepHandler(AttributeDefinition ... attributes) {
            this.attributes = attributes;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ModelNode model = resource.getModel();
            this.updateModel(context, operation, model);
            if (context.isNormalServer()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final ConfigurationPersistence configurationPersistence = LoggingOperations.getOrCreateConfigurationPersistence(context);
                        LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
                        this.performRuntime(context, operation, model, logContextConfiguration);
                        LoggingOperations.addCommitStep(context, configurationPersistence);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                configurationPersistence.rollback();
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        public void updateModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode submodel = resource.getModel();
            for (AttributeDefinition attribute : this.attributes) {
                String attributeName = attribute.getName();
                ModelNode currentValue = submodel.get(attributeName).clone();
                if (CommonAttributes.FILTER.equals((Object)attribute)) {
                    ModelNode filter = CommonAttributes.FILTER.validateOperation(operation);
                    if (filter.isDefined()) {
                        String value = Filters.filterToFilterSpec(filter);
                        model.get(LoggerAttributes.FILTER_SPEC.getName()).set(value.isEmpty() ? new ModelNode() : new ModelNode(value));
                    }
                } else if (operation.has(attribute.getName())) {
                    attribute.validateAndSet(operation, model);
                }
                ModelNode newValue = model.get(attributeName).clone();
                this.recordCapabilitiesAndRequirements(context, resource, attribute, newValue, currentValue);
            }
        }

        public abstract void performRuntime(OperationContext var1, ModelNode var2, ModelNode var3, LogContextConfiguration var4) throws OperationFailedException;

        protected AttributeDefinition[] getAttributes() {
            return this.attributes;
        }

        protected void recordCapabilitiesAndRequirements(OperationContext context, Resource resource, AttributeDefinition attributeDefinition, ModelNode newValue, ModelNode oldValue) {
            attributeDefinition.removeCapabilityRequirements(context, resource, oldValue);
            attributeDefinition.addCapabilityRequirements(context, resource, newValue);
        }
    }

    public static abstract class LoggingAddOperationStepHandler
    extends AbstractAddStepHandler {
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            super.execute(context, operation);
            context.completeStep(new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    ConfigurationPersistence configurationPersistence = LoggingOperations.getConfigurationPersistence(context);
                    if (configurationPersistence != null) {
                        configurationPersistence.rollback();
                    }
                }
            });
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            ConfigurationPersistence configurationPersistence = LoggingOperations.getOrCreateConfigurationPersistence(context);
            OperationStepHandler additionalStep = this.additionalModelStep(configurationPersistence);
            if (additionalStep != null) {
                context.addStep(additionalStep, OperationContext.Stage.MODEL);
            }
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ConfigurationPersistence configurationPersistence = LoggingOperations.getOrCreateConfigurationPersistence(context);
            LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
            this.performRuntime(context, operation, model, logContextConfiguration);
            LoggingOperations.addCommitStep(context, configurationPersistence, this.afterPrepare(logContextConfiguration, model));
        }

        protected OperationStepHandler afterPrepare(LogContextConfiguration logContextConfiguration, ModelNode model) {
            return null;
        }

        protected OperationStepHandler additionalModelStep(LogContextConfiguration logContextConfiguration) {
            return null;
        }

        public abstract void performRuntime(OperationContext var1, ModelNode var2, ModelNode var3, LogContextConfiguration var4) throws OperationFailedException;
    }

    public static class ReadFilterOperationStepHandler
    implements OperationStepHandler {
        public static final ReadFilterOperationStepHandler INSTANCE = new ReadFilterOperationStepHandler();

        private ReadFilterOperationStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode filter = LoggerAttributes.FILTER_SPEC.resolveModelAttribute(context, model);
            if (filter.isDefined()) {
                context.getResult().set(Filters.filterSpecToFilter(filter.asString()));
            }
        }
    }

    private static final class CommitOperationStepHandler
    implements OperationStepHandler {
        private static final OperationContext.AttachmentKey<Boolean> WRITTEN_KEY = OperationContext.AttachmentKey.create(Boolean.class);
        private final ConfigurationPersistence configurationPersistence;
        private final OperationStepHandler afterPrepare;
        private final boolean persistConfig;

        CommitOperationStepHandler(ConfigurationPersistence configurationPersistence, OperationStepHandler afterPrepare) {
            this.configurationPersistence = configurationPersistence;
            this.afterPrepare = afterPrepare;
            this.persistConfig = Boolean.parseBoolean(WildFlySecurityManager.getPropertyPrivileged((String)"jboss.server.persist.config", (String)Boolean.toString(true)));
        }

        public void execute(OperationContext context, ModelNode operation) {
            context.addStep((c, o) -> {
                this.configurationPersistence.prepare();
                LoggingLogger.ROOT_LOGGER.tracef("Prepared the configuration for commit on operation: %s", o);
                if (this.afterPrepare != null) {
                    c.addStep(this.afterPrepare, OperationContext.Stage.RUNTIME);
                }
                c.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP) {
                            configurationPersistence.commit();
                            if (!LoggingProfileOperations.isLoggingProfileAddress(context.getCurrentAddress()) && context.getAttachment(WRITTEN_KEY) == null) {
                                context.attachIfAbsent(WRITTEN_KEY, (Object)Boolean.TRUE);
                                if (persistConfig) {
                                    configurationPersistence.writeConfiguration(context);
                                }
                            }
                        } else if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                            configurationPersistence.rollback();
                        }
                    }
                });
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

