/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggingResourceDefinition;
import org.jboss.as.logging.LoggingSubsystemParser_5_0;
import org.jboss.as.logging.handlers.SocketHandlerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class LoggingSubsystemParser_6_0
extends LoggingSubsystemParser_5_0 {
    LoggingSubsystemParser_6_0() {
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode subsystemAddOp = Util.createAddOperation((PathAddress)SUBSYSTEM_ADDRESS);
        operations.add(subsystemAddOp);
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> formatterOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        HashSet<String> formatterNames = new HashSet<String>();
        boolean rootDefined = false;
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADD_LOGGING_API_DEPENDENCIES: {
                    String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                    LoggingResourceDefinition.ADD_LOGGING_API_DEPENDENCIES.parseAndSetParameter(value, subsystemAddOp, (XMLStreamReader)reader);
                    continue block17;
                }
                case USE_DEPLOYMENT_LOGGING_CONFIG: {
                    String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                    LoggingResourceDefinition.USE_DEPLOYMENT_LOGGING_CONFIG.parseAndSetParameter(value, subsystemAddOp, (XMLStreamReader)reader);
                    continue block17;
                }
                case LOGGER: {
                    this.parseLoggerElement(reader, SUBSYSTEM_ADDRESS, loggerOperations, loggerNames);
                    continue block17;
                }
                case ROOT_LOGGER: {
                    if (rootDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    rootDefined = true;
                    this.parseRootLoggerElement(reader, SUBSYSTEM_ADDRESS, loggerOperations);
                    continue block17;
                }
                case CONSOLE_HANDLER: {
                    this.parseConsoleHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block17;
                }
                case FILE_HANDLER: {
                    this.parseFileHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block17;
                }
                case CUSTOM_HANDLER: {
                    this.parseCustomHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block17;
                }
                case PERIODIC_ROTATING_FILE_HANDLER: {
                    this.parsePeriodicRotatingFileHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block17;
                }
                case PERIODIC_SIZE_ROTATING_FILE_HANDLER: {
                    this.parsePeriodicSizeRotatingHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block17;
                }
                case SIZE_ROTATING_FILE_HANDLER: {
                    this.parseSizeRotatingHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block17;
                }
                case SOCKET_HANDLER: {
                    this.parseSocketHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block17;
                }
                case ASYNC_HANDLER: {
                    this.parseAsyncHandlerElement(reader, SUBSYSTEM_ADDRESS, asyncHandlerOperations, handlerNames);
                    continue block17;
                }
                case SYSLOG_HANDLER: {
                    this.parseSyslogHandler(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block17;
                }
                case LOGGING_PROFILES: {
                    this.parseLoggingProfilesElement(reader, operations);
                    continue block17;
                }
                case FORMATTER: {
                    this.parseFormatter(reader, SUBSYSTEM_ADDRESS, formatterOperations, formatterNames);
                    continue block17;
                }
            }
            reader.handleAny(operations);
        }
        operations.addAll(formatterOperations);
        operations.addAll(handlerOperations);
        operations.addAll(asyncHandlerOperations);
        operations.addAll(loggerOperations);
    }

    @Override
    void parseLoggingProfileElement(XMLExtendedStreamReader reader, List<ModelNode> operations, Set<String> profileNames) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block17: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!profileNames.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        PathAddress profileAddress = SUBSYSTEM_ADDRESS.append("logging-profile", name);
        operations.add(Util.createAddOperation((PathAddress)profileAddress));
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> formatterOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        HashSet<String> formatterNames = new HashSet<String>();
        boolean gotRoot = false;
        block18: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGGER: {
                    this.parseLoggerElement(reader, profileAddress, loggerOperations, loggerNames);
                    continue block18;
                }
                case ROOT_LOGGER: {
                    if (gotRoot) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    gotRoot = true;
                    this.parseRootLoggerElement(reader, profileAddress, loggerOperations);
                    continue block18;
                }
                case CONSOLE_HANDLER: {
                    this.parseConsoleHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block18;
                }
                case FILE_HANDLER: {
                    this.parseFileHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block18;
                }
                case CUSTOM_HANDLER: {
                    this.parseCustomHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block18;
                }
                case PERIODIC_ROTATING_FILE_HANDLER: {
                    this.parsePeriodicRotatingFileHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block18;
                }
                case PERIODIC_SIZE_ROTATING_FILE_HANDLER: {
                    this.parsePeriodicSizeRotatingHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block18;
                }
                case SIZE_ROTATING_FILE_HANDLER: {
                    this.parseSizeRotatingHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block18;
                }
                case SOCKET_HANDLER: {
                    this.parseSocketHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block18;
                }
                case ASYNC_HANDLER: {
                    this.parseAsyncHandlerElement(reader, profileAddress, asyncHandlerOperations, handlerNames);
                    continue block18;
                }
                case SYSLOG_HANDLER: {
                    this.parseSyslogHandler(reader, profileAddress, handlerOperations, handlerNames);
                    continue block18;
                }
                case FORMATTER: {
                    this.parseFormatter(reader, profileAddress, formatterOperations, formatterNames);
                    continue block18;
                }
            }
            reader.handleAny(operations);
        }
        operations.addAll(formatterOperations);
        operations.addAll(handlerOperations);
        operations.addAll(asyncHandlerOperations);
        operations.addAll(loggerOperations);
    }

    void parseSocketHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> handlerNames) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.OUTBOUND_SOCKET_BINDING_REF);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block15;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case BLOCK_ON_RECONNECT: {
                    SocketHandlerResourceDefinition.BLOCK_ON_RECONNECT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case OUTBOUND_SOCKET_BINDING_REF: {
                    SocketHandlerResourceDefinition.OUTBOUND_SOCKET_BINDING_REF.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case SSL_CONTEXT: {
                    SocketHandlerResourceDefinition.SSL_CONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!handlerNames.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_6_0.addOperationAddress(operation, address, "socket-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.NAMED_FORMATTER);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block16: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_6_0.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_6_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case FILTER_SPEC: {
                    SocketHandlerResourceDefinition.FILTER_SPEC.parseAndSetParameter(LoggingSubsystemParser_6_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case NAMED_FORMATTER: {
                    SocketHandlerResourceDefinition.NAMED_FORMATTER.parseAndSetParameter(LoggingSubsystemParser_6_0.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case PROTOCOL: {
                    SocketHandlerResourceDefinition.PROTOCOL.parseAndSetParameter(LoggingSubsystemParser_6_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block16;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }
}

