/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.LoggingProfileContextSelector;
import org.jboss.as.logging.LoggingResource;
import org.jboss.as.logging.logmanager.ConfigurationPersistence;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.config.LogContextConfiguration;

public class LoggingProfileOperations {
    static OperationStepHandler REMOVE_PROFILE = new AbstractRemoveStepHandler(){

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            final String loggingProfile = LoggingProfileOperations.getLoggingProfileName(address);
            final LoggingProfileContextSelector contextSelector = LoggingProfileContextSelector.getInstance();
            final LogContext logContext = contextSelector.get(loggingProfile);
            if (logContext != null) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        final ConfigurationPersistence configuration = ConfigurationPersistence.getConfigurationPersistence(logContext);
                        if (configuration != null) {
                            LogContextConfiguration logContextConfiguration = configuration.getLogContextConfiguration();
                            for (String loggerName : logContextConfiguration.getLoggerNames()) {
                                logContextConfiguration.removeLoggerConfiguration(loggerName);
                            }
                            for (String handlerName : logContextConfiguration.getHandlerNames()) {
                                logContextConfiguration.removeHandlerConfiguration(handlerName);
                            }
                            for (String filterName : logContextConfiguration.getFilterNames()) {
                                logContextConfiguration.removeFilterConfiguration(filterName);
                            }
                            for (String formatterName : logContextConfiguration.getFormatterNames()) {
                                logContextConfiguration.removeFormatterConfiguration(formatterName);
                            }
                            for (String errorManager : logContextConfiguration.getErrorManagerNames()) {
                                logContextConfiguration.removeErrorManagerConfiguration(errorManager);
                            }
                            LoggingOperations.addCommitStep(context, configuration);
                            context.reloadRequired();
                        }
                        context.completeStep(new OperationContext.ResultHandler(){

                            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                if (resultAction == OperationContext.ResultAction.KEEP) {
                                    contextSelector.remove(loggingProfile);
                                } else if (configuration != null) {
                                    context.revertReloadRequired();
                                }
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        }
    };

    static boolean isLoggingProfileAddress(PathAddress address) {
        return LoggingProfileOperations.getLoggingProfileName(address) != null;
    }

    static String getLoggingProfileName(PathAddress address) {
        for (PathElement pathElement : address) {
            if (!"logging-profile".equals(pathElement.getKey())) continue;
            return pathElement.getValue();
        }
        return null;
    }

    static class LoggingProfileAdd
    extends AbstractAddStepHandler {
        private final PathManager pathManager;

        LoggingProfileAdd(PathManager pathManager) {
            this.pathManager = pathManager;
        }

        protected Resource createResource(OperationContext context) {
            if (this.pathManager == null) {
                return super.createResource(context);
            }
            LoggingResource resource = new LoggingResource(this.pathManager);
            context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
            return resource;
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            model.setEmptyObject();
        }
    }
}

