/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments.resources;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.logging.deployments.LoggingConfigurationService;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.msc.service.ServiceController;

abstract class LoggingConfigurationReadStepHandler
implements OperationStepHandler {
    private static final OperationContext.AttachmentKey<LogContextConfiguration> CONFIGURATION_KEY = OperationContext.AttachmentKey.create(LogContextConfiguration.class);

    LoggingConfigurationReadStepHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServiceController controller;
        LogContextConfiguration configuration = (LogContextConfiguration)context.getAttachment(CONFIGURATION_KEY);
        if (configuration == null && (controller = context.getServiceRegistry(false).getService(LoggingConfigurationService.forDeployment(context.getCurrentAddress()))) != null) {
            configuration = (LogContextConfiguration)controller.getValue();
            context.attachIfAbsent(CONFIGURATION_KEY, (Object)configuration);
        }
        if (configuration != null) {
            String name = context.getCurrentAddressValue();
            ModelNode result = context.getResult();
            this.updateModel(configuration, name, result);
        }
    }

    protected abstract void updateModel(LogContextConfiguration var1, String var2, ModelNode var3);

    static void addProperties(PropertyConfigurable configuration, ModelNode model) {
        configuration.getPropertyNames().forEach(name -> LoggingConfigurationReadStepHandler.setModelValue(model.get(name), configuration.getPropertyValueString(name)));
    }

    static void setModelValue(ModelNode model, String value) {
        if (value != null) {
            model.set(value);
        }
    }

    static void setModelValue(ModelNode model, Boolean value) {
        if (value != null) {
            model.set(value.booleanValue());
        }
    }
}

