/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.HandlersAttributeMarshaller;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.resolvers.HandlerResolver;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.config.PropertyConfigurable;

public class LogHandlerListAttributeDefinition
extends SimpleListAttributeDefinition
implements ConfigurationProperty<Set<String>> {
    private final String propertyName;
    private final HandlerResolver resolver = HandlerResolver.INSTANCE;

    private LogHandlerListAttributeDefinition(Builder builder) {
        super((ListAttributeDefinition.Builder)builder, (AttributeDefinition)CommonAttributes.HANDLER);
        this.propertyName = builder.propertyName;
    }

    @Override
    public ModelNodeResolver<Set<String>> resolver() {
        return this.resolver;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Set<String> resolvePropertyValue(OperationContext context, ModelNode model) throws OperationFailedException {
        Object result = Collections.emptySet();
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            result = this.resolver.resolveValue(context, value);
        }
        return result;
    }

    @Override
    public void setPropertyValue(OperationContext context, ModelNode model, PropertyConfigurable configuration) throws OperationFailedException {
        throw LoggingLogger.ROOT_LOGGER.unsupportedMethod("setPropertyValue", this.getClass().getName());
    }

    public static class Builder
    extends ListAttributeDefinition.Builder<Builder, LogHandlerListAttributeDefinition> {
        private String propertyName;

        Builder(String name) {
            super(name);
            this.setElementValidator(CommonAttributes.HANDLER.getValidator());
        }

        public static Builder of(String name) {
            return new Builder(name);
        }

        public LogHandlerListAttributeDefinition build() {
            if (this.propertyName == null) {
                this.propertyName = this.name;
            }
            if (this.attributeMarshaller == null) {
                this.attributeMarshaller = HandlersAttributeMarshaller.INSTANCE;
            }
            return new LogHandlerListAttributeDefinition(this);
        }

        public Builder setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }
    }
}

