/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.JBossLogManagerFacade;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.as.logging.deployments.AbstractLoggingDeploymentProcessor;
import org.jboss.as.logging.deployments.LoggingConfigurationService;
import org.jboss.as.logging.deployments.LoggingDeploymentResourceProcessor;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.logmanager.WildFlyLogContextSelector;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LoggingConfigDeploymentProcessor
extends AbstractLoggingDeploymentProcessor
implements DeploymentUnitProcessor {
    @Deprecated
    public static final String PER_DEPLOYMENT_LOGGING = "org.jboss.as.logging.per-deployment";
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final String LOG4J_XML = "log4j.xml";
    private static final String JBOSS_LOG4J_XML = "jboss-log4j.xml";
    private static final String DEFAULT_PROPERTIES = "logging.properties";
    private static final String JBOSS_PROPERTIES = "jboss-logging.properties";
    private final String attributeName;
    private final boolean process;

    public LoggingConfigDeploymentProcessor(WildFlyLogContextSelector logContextSelector, String attributeName, boolean process) {
        super(logContextSelector);
        this.attributeName = attributeName;
        this.process = process;
    }

    @Override
    protected void processDeployment(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, ResourceRoot root) throws DeploymentUnitProcessingException {
        boolean process = this.process;
        Properties systemProps = WildFlySecurityManager.getSystemPropertiesPrivileged();
        if (systemProps.containsKey(PER_DEPLOYMENT_LOGGING)) {
            LoggingLogger.ROOT_LOGGER.perDeploymentPropertyDeprecated(PER_DEPLOYMENT_LOGGING, this.attributeName);
            if (process) {
                process = Boolean.valueOf(WildFlySecurityManager.getPropertyPrivileged((String)PER_DEPLOYMENT_LOGGING, (String)Boolean.toString(true)));
            } else {
                LoggingLogger.ROOT_LOGGER.perLoggingDeploymentIgnored(PER_DEPLOYMENT_LOGGING, this.attributeName, deploymentUnit.getName());
            }
        }
        LoggingConfigurationService loggingConfigurationService = null;
        if (process) {
            LoggingLogger.ROOT_LOGGER.trace("Scanning for logging configuration files.");
            List<DeploymentUnit> subDeployments = LoggingConfigDeploymentProcessor.getSubDeployments(deploymentUnit);
            VirtualFile configFile = this.findConfigFile(root);
            if (configFile != null) {
                Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
                LogContext logContext = LoggingConfigDeploymentProcessor.isLog4jConfiguration(configFile.getName()) ? LogContext.create((boolean)true) : LogContext.create();
                boolean processSubdeployments = true;
                loggingConfigurationService = this.configure(root, configFile, (ClassLoader)module.getClassLoader(), logContext);
                if (loggingConfigurationService != null) {
                    this.registerLogContext(deploymentUnit, module, logContext);
                } else {
                    processSubdeployments = false;
                }
                if (processSubdeployments) {
                    for (DeploymentUnit subDeployment : subDeployments) {
                        if (subDeployment.hasAttachment(Attachments.DEPLOYMENT_ROOT)) {
                            this.processDeployment(phaseContext, subDeployment, (ResourceRoot)subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT));
                        }
                        if (!LoggingConfigDeploymentProcessor.hasRegisteredLogContext(subDeployment)) {
                            Module subDeploymentModule = (Module)subDeployment.getAttachment(Attachments.MODULE);
                            this.registerLogContext(subDeployment, subDeploymentModule, logContext);
                        }
                        if (subDeployment.hasAttachment(LoggingDeploymentResourceProcessor.LOGGING_CONFIGURATION_SERVICE_KEY)) continue;
                        subDeployment.putAttachment(LoggingDeploymentResourceProcessor.LOGGING_CONFIGURATION_SERVICE_KEY, (Object)loggingConfigurationService);
                    }
                }
            } else {
                for (DeploymentUnit subDeployment : subDeployments) {
                    if (!subDeployment.hasAttachment(Attachments.DEPLOYMENT_ROOT)) continue;
                    this.processDeployment(phaseContext, subDeployment, (ResourceRoot)subDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT));
                }
            }
        }
        if (loggingConfigurationService != null) {
            deploymentUnit.putAttachment(LoggingDeploymentResourceProcessor.LOGGING_CONFIGURATION_SERVICE_KEY, loggingConfigurationService);
        }
    }

    private VirtualFile findConfigFile(ResourceRoot resourceRoot) throws DeploymentUnitProcessingException {
        VirtualFile root = resourceRoot.getRoot();
        VirtualFile file = root.getChild("META-INF");
        VirtualFile result = this.findConfigFile(file);
        if (result == null) {
            file = root.getChild("WEB-INF/classes");
            result = this.findConfigFile(file);
        }
        return result;
    }

    private VirtualFile findConfigFile(VirtualFile file) throws DeploymentUnitProcessingException {
        VirtualFile result = null;
        try {
            List configFiles = file.getChildren((VirtualFileFilter)ConfigFilter.INSTANCE);
            for (VirtualFile configFile : configFiles) {
                String fileName = configFile.getName();
                if (DEFAULT_PROPERTIES.equals(fileName) || JBOSS_PROPERTIES.equals(fileName)) {
                    if (result != null) {
                        LoggingLogger.ROOT_LOGGER.debugf("The previously found configuration file '%s' is being ignored in favour of '%s'", result, configFile);
                    }
                    return configFile;
                }
                if (!LOG4J_PROPERTIES.equals(fileName) && !LOG4J_XML.equals(fileName) && !JBOSS_LOG4J_XML.equals(fileName)) continue;
                result = configFile;
            }
        }
        catch (IOException e) {
            throw LoggingLogger.ROOT_LOGGER.errorProcessingLoggingConfiguration(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggingConfigurationService configure(ResourceRoot root, VirtualFile configFile, ClassLoader classLoader, LogContext logContext) throws DeploymentUnitProcessingException {
        InputStream configStream;
        block13: {
            LoggingConfigurationService loggingConfigurationService;
            block11: {
                configStream = null;
                LoggingLogger.ROOT_LOGGER.debugf("Found logging configuration file: %s", configFile);
                String fileName = configFile.getName();
                configStream = configFile.openStream();
                if (!LoggingConfigDeploymentProcessor.isLog4jConfiguration(fileName)) break block11;
                LoggingLogger.ROOT_LOGGER.usageOfLog4j1Config(configFile.getPathName(), root.getRootName());
                ClassLoader current = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                LogContext old = this.logContextSelector.setLocalContext(logContext);
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)classLoader);
                    if (LOG4J_XML.equals(fileName) || JBOSS_LOG4J_XML.equals(fileName)) {
                        new DOMConfigurator().doConfigure(configStream, JBossLogManagerFacade.getLoggerRepository((LogContext)logContext));
                    } else {
                        Properties properties = new Properties();
                        properties.load(new InputStreamReader(configStream, ENCODING));
                        new org.apache.log4j.PropertyConfigurator().doConfigure(properties, JBossLogManagerFacade.getLoggerRepository((LogContext)logContext));
                    }
                }
                finally {
                    this.logContextSelector.setLocalContext(old);
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)current);
                }
                LoggingConfigurationService loggingConfigurationService2 = new LoggingConfigurationService(null, LoggingConfigDeploymentProcessor.resolveRelativePath(root, configFile));
                LoggingConfigDeploymentProcessor.safeClose(configStream);
                return loggingConfigurationService2;
            }
            try {
                Properties properties = new Properties();
                properties.load(new InputStreamReader(configStream, ENCODING));
                if (LoggingConfigDeploymentProcessor.isJulConfiguration(properties)) {
                    LoggingLogger.ROOT_LOGGER.julConfigurationFileFound(configFile.getName());
                    break block13;
                }
                PropertyConfigurator propertyConfigurator = new PropertyConfigurator(logContext);
                propertyConfigurator.configure(properties);
                loggingConfigurationService = new LoggingConfigurationService(propertyConfigurator.getLogContextConfiguration(), LoggingConfigDeploymentProcessor.resolveRelativePath(root, configFile));
            }
            catch (Exception e) {
                try {
                    throw LoggingLogger.ROOT_LOGGER.failedToConfigureLogging(e, configFile.getName());
                }
                catch (Throwable throwable) {
                    LoggingConfigDeploymentProcessor.safeClose(configStream);
                    throw throwable;
                }
            }
            LoggingConfigDeploymentProcessor.safeClose(configStream);
            return loggingConfigurationService;
        }
        LoggingConfigDeploymentProcessor.safeClose(configStream);
        return null;
    }

    private static boolean isLog4jConfiguration(String fileName) {
        return LOG4J_PROPERTIES.equals(fileName) || LOG4J_XML.equals(fileName) || JBOSS_LOG4J_XML.equals(fileName);
    }

    private static boolean isJulConfiguration(Properties properties) {
        String prop;
        if (properties.containsKey(".level")) {
            return true;
        }
        if (properties.containsKey("handlers") && (prop = properties.getProperty("handlers", "")) != null && !prop.trim().isEmpty()) {
            String[] handlers;
            for (String handler : handlers = prop.split("\\s*,\\s*")) {
                String key = String.format("handler.%s", handler);
                if (properties.containsKey(key)) continue;
                return true;
            }
        }
        return false;
    }

    private static String resolveRelativePath(ResourceRoot root, VirtualFile configFile) {
        VirtualFile deployment = root.getRoot().getParent();
        if (deployment != null) {
            return configFile.getPathNameRelativeTo(deployment);
        }
        return configFile.getPathNameRelativeTo(root.getRoot());
    }

    private static class ConfigFilter
    implements VirtualFileFilter {
        static final ConfigFilter INSTANCE = new ConfigFilter();
        private final Set<String> configFiles = new HashSet<String>(Arrays.asList("log4j.properties", "log4j.xml", "jboss-log4j.xml", "jboss-logging.properties", "logging.properties"));

        private ConfigFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return this.configFiles.contains(file.getName());
        }
    }
}

