/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.validators;

import java.text.SimpleDateFormat;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SuffixValidator
extends ModelTypeValidator {
    private final boolean denySeconds;

    public SuffixValidator() {
        this(false, true);
    }

    public SuffixValidator(boolean nullable, boolean denySeconds) {
        super(ModelType.STRING, nullable);
        this.denySeconds = denySeconds;
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            String suffix = value.asString();
            if (suffix.endsWith(".zip")) {
                suffix = suffix.substring(0, suffix.length() - 4);
            } else if (suffix.endsWith(".gz")) {
                suffix = suffix.substring(0, suffix.length() - 3);
            }
            try {
                new SimpleDateFormat(suffix);
                if (this.denySeconds) {
                    for (int i = 0; i < suffix.length(); ++i) {
                        char c = suffix.charAt(i);
                        if (c == '\'') {
                            c = suffix.charAt(++i);
                            while (c != '\'') {
                                c = suffix.charAt(++i);
                            }
                        }
                        if (c != 's' && c != 'S') continue;
                        throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.suffixContainsMillis(suffix));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.invalidSuffix(suffix));
            }
        }
    }
}

