/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import org.apache.log4j.Appender;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.Filters;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.PatternFormatterResourceDefinition;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.logmanager.Log4jAppenderHandler;
import org.jboss.as.logging.logmanager.PropertySorter;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.config.PojoConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

final class HandlerOperations {
    private static final Logger.AttachmentKey<Map<String, String>> DISABLED_HANDLERS_KEY = new Logger.AttachmentKey();
    private static final Object HANDLER_LOCK = new Object();
    static final OperationStepHandler CHANGE_LEVEL = new HandlerUpdateOperationStepHandler(PropertySorter.NO_OP, new AttributeDefinition[]{CommonAttributes.LEVEL});
    static final OperationStepHandler REMOVE_HANDLER = new LoggingOperations.LoggingRemoveOperationStepHandler(){

        @Override
        public void performRemove(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            List loggerNames = logContextConfiguration.getLoggerNames();
            ArrayList<String> assigned = new ArrayList<String>();
            for (String loggerName : loggerNames) {
                LoggerConfiguration c = logContextConfiguration.getLoggerConfiguration(loggerName);
                if (c == null || !c.getHandlerNames().contains(name)) continue;
                if ("".equals(loggerName)) {
                    assigned.add("ROOT");
                    continue;
                }
                assigned.add(loggerName);
            }
            if (!assigned.isEmpty()) {
                context.setRollbackOnly();
                throw LoggingLogger.ROOT_LOGGER.handlerAttachedToLoggers(name, assigned);
            }
            List handlerNames = logContextConfiguration.getHandlerNames();
            for (String handlerName : handlerNames) {
                HandlerConfiguration c = logContextConfiguration.getHandlerConfiguration(handlerName);
                if (c == null || !c.getHandlerNames().contains(name)) continue;
                assigned.add(handlerName);
            }
            if (!assigned.isEmpty()) {
                context.setRollbackOnly();
                throw LoggingLogger.ROOT_LOGGER.handlerAttachedToHandlers(name, assigned);
            }
            logContextConfiguration.removeHandlerConfiguration(name);
            if (logContextConfiguration.getFormatterNames().contains(name)) {
                logContextConfiguration.removeFormatterConfiguration(name);
            }
            if (logContextConfiguration.getPojoNames().contains(name)) {
                logContextConfiguration.removePojoConfiguration(name);
            }
        }
    };
    static final OperationStepHandler ADD_SUBHANDLER = new HandlerUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            model.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()).add(operation.get(CommonAttributes.HANDLER_NAME.getName()));
        }

        @Override
        public void performRuntime(OperationContext context, HandlerConfiguration configuration, ModelNode operation, String name, ModelNode model) throws OperationFailedException {
            String handlerName = CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, operation).asString();
            if (name.equals(handlerName)) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.cannotAddHandlerToSelf(configuration.getName()));
            }
            if (configuration.getHandlerNames().contains(handlerName)) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.handlerAlreadyDefined(handlerName));
            }
            configuration.addHandlerName(handlerName);
        }
    };
    static final OperationStepHandler REMOVE_SUBHANDLER = new HandlerUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            String handlerName = operation.get(CommonAttributes.HANDLER_NAME.getName()).asString();
            boolean found = false;
            List handlers = model.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()).asList();
            ArrayList<ModelNode> newHandlers = new ArrayList<ModelNode>(handlers.size());
            for (ModelNode handler : handlers) {
                if (handlerName.equals(handler.asString())) {
                    found = true;
                    continue;
                }
                newHandlers.add(handler);
            }
            if (found) {
                model.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()).set(newHandlers);
            }
        }

        @Override
        public void performRuntime(OperationContext context, HandlerConfiguration configuration, ModelNode operation, String name, ModelNode model) throws OperationFailedException {
            configuration.removeHandlerName(CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, operation).asString());
        }
    };
    static final OperationStepHandler CHANGE_FILE = new HandlerUpdateOperationStepHandler(PropertySorter.NO_OP, new AttributeDefinition[]{CommonAttributes.FILE});
    static final LoggingOperations.LoggingUpdateOperationStepHandler ENABLE_HANDLER = new LoggingOperations.LoggingUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            model.get(CommonAttributes.ENABLED.getName()).set(true);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            HandlerOperations.enableHandler(configuration, name);
        }
    };
    static final LoggingOperations.LoggingUpdateOperationStepHandler DISABLE_HANDLER = new LoggingOperations.LoggingUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            model.get(CommonAttributes.ENABLED.getName()).set(false);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            HandlerOperations.disableHandler(configuration, name);
        }
    };

    HandlerOperations() {
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration) throws OperationFailedException {
        HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration, true);
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration, boolean resolveValue) throws OperationFailedException {
        if (attribute.getName().equals(CommonAttributes.ENABLED.getName())) {
            boolean value;
            boolean bl = value = resolveValue ? CommonAttributes.ENABLED.resolveModelAttribute(context, model).asBoolean() : model.asBoolean();
            if (value) {
                HandlerOperations.enableHandler(logContextConfiguration, configuration.getName());
            } else {
                HandlerOperations.disableHandler(logContextConfiguration, configuration.getName());
            }
        } else if (attribute.getName().equals(CommonAttributes.ENCODING.getName())) {
            String resolvedValue = resolveValue ? CommonAttributes.ENCODING.resolvePropertyValue(context, model) : (model.isDefined() ? model.asString() : null);
            configuration.setEncoding(resolvedValue);
        } else if (attribute.getName().equals(AbstractHandlerDefinition.FORMATTER.getName())) {
            String formatterName = configuration.getName();
            if (model.hasDefined(AbstractHandlerDefinition.NAMED_FORMATTER.getName())) {
                ModelNode valueNode = resolveValue ? AbstractHandlerDefinition.NAMED_FORMATTER.resolveModelAttribute(context, model) : model;
                String resolvedValue = valueNode.isDefined() ? valueNode.asString() : null;
                configuration.setFormatterName(resolvedValue);
                if (!formatterName.equals(resolvedValue) && logContextConfiguration.getFormatterNames().contains(formatterName)) {
                    logContextConfiguration.removeFormatterConfiguration(formatterName);
                }
            } else {
                FormatterConfiguration fmtConfig = logContextConfiguration.getFormatterNames().contains(formatterName) ? logContextConfiguration.getFormatterConfiguration(formatterName) : logContextConfiguration.addFormatterConfiguration(null, PatternFormatter.class.getName(), formatterName, new String[]{PatternFormatterResourceDefinition.PATTERN.getPropertyName()});
                String resolvedValue = resolveValue ? AbstractHandlerDefinition.FORMATTER.resolvePropertyValue(context, model) : model.asString();
                fmtConfig.setPropertyValueString(PatternFormatterResourceDefinition.PATTERN.getPropertyName(), resolvedValue);
                configuration.setFormatterName(formatterName);
            }
        } else if (attribute.getName().equals(AbstractHandlerDefinition.NAMED_FORMATTER.getName())) {
            ModelNode valueNode;
            String formatterName = configuration.getName();
            ModelNode modelNode = valueNode = resolveValue ? AbstractHandlerDefinition.NAMED_FORMATTER.resolveModelAttribute(context, model) : model;
            if (valueNode.isDefined()) {
                String resolvedValue = valueNode.asString();
                configuration.setFormatterName(resolvedValue);
                if (!formatterName.equals(resolvedValue) && logContextConfiguration.getFormatterNames().contains(formatterName)) {
                    logContextConfiguration.removeFormatterConfiguration(formatterName);
                }
            } else if (!formatterName.equals(configuration.getFormatterName())) {
                FormatterConfiguration fmtConfig = logContextConfiguration.getFormatterNames().contains(formatterName) ? logContextConfiguration.getFormatterConfiguration(formatterName) : logContextConfiguration.addFormatterConfiguration(null, PatternFormatter.class.getName(), formatterName, new String[]{PatternFormatterResourceDefinition.PATTERN.getPropertyName()});
                fmtConfig.setPropertyValueString(PatternFormatterResourceDefinition.PATTERN.getPropertyName(), AbstractHandlerDefinition.FORMATTER.resolvePropertyValue(context, model));
                configuration.setFormatterName(formatterName);
            }
        } else if (attribute.getName().equals(CommonAttributes.FILTER_SPEC.getName())) {
            ModelNode valueNode = resolveValue ? CommonAttributes.FILTER_SPEC.resolveModelAttribute(context, model) : model;
            String resolvedValue = valueNode.isDefined() ? valueNode.asString() : null;
            configuration.setFilter(resolvedValue);
        } else if (attribute.getName().equals(CommonAttributes.LEVEL.getName())) {
            String resolvedValue = resolveValue ? CommonAttributes.LEVEL.resolvePropertyValue(context, model) : CommonAttributes.LEVEL.resolver().resolveValue(context, model);
            configuration.setLevel(resolvedValue);
        } else if (attribute.getName().equals(AsyncHandlerResourceDefinition.SUBHANDLERS.getName())) {
            Set<String> resolvedValue;
            Set<String> set = resolvedValue = resolveValue ? AsyncHandlerResourceDefinition.SUBHANDLERS.resolvePropertyValue(context, model) : AsyncHandlerResourceDefinition.SUBHANDLERS.resolver().resolveValue(context, model);
            if (resolvedValue.contains(configuration.getName())) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.cannotAddHandlerToSelf(configuration.getName()));
            }
            configuration.setHandlerNames(resolvedValue);
        } else if (!attribute.getName().equals(CommonAttributes.HANDLER_NAME.getName())) {
            if (attribute.getName().equals(CommonAttributes.PROPERTIES.getName())) {
                HandlerConfiguration propertyConfigurable;
                PojoConfiguration pojoConfiguration = logContextConfiguration.getPojoConfiguration(configuration.getName());
                if (pojoConfiguration == null) {
                    propertyConfigurable = configuration;
                } else {
                    propertyConfigurable = pojoConfiguration;
                    configuration.setPropertyValueString("dummy", "");
                }
                if (model.hasDefined(CommonAttributes.PROPERTIES.getName())) {
                    ModelNode resolvedValue = resolveValue ? CommonAttributes.PROPERTIES.resolveModelAttribute(context, model) : model;
                    for (Property property : resolvedValue.asPropertyList()) {
                        propertyConfigurable.setPropertyValueString(property.getName(), property.getValue().asString());
                    }
                }
            } else if (attribute instanceof ConfigurationProperty) {
                ConfigurationProperty configurationProperty = (ConfigurationProperty)attribute;
                if (resolveValue) {
                    configurationProperty.setPropertyValue(context, model, (PropertyConfigurable)configuration);
                } else {
                    String resolvedValue;
                    ModelNodeResolver resolver = configurationProperty.resolver();
                    String string = resolver == null ? (model.isDefined() ? model.asString() : null) : (resolvedValue = (String)resolver.resolveValue(context, model));
                    if (resolvedValue == null) {
                        configuration.setPropertyValueString(configurationProperty.getPropertyName(), null);
                        configuration.removeProperty(configurationProperty.getPropertyName());
                    } else {
                        configuration.setPropertyValueString(configurationProperty.getPropertyName(), resolvedValue);
                    }
                }
            } else {
                LoggingLogger.ROOT_LOGGER.invalidPropertyAttribute(attribute.getName());
            }
        }
    }

    private static boolean equalValue(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration) throws OperationFailedException {
        boolean result;
        if (attribute.getName().equals(CommonAttributes.ENABLED.getName())) {
            boolean resolvedValue = CommonAttributes.ENABLED.resolveModelAttribute(context, model).asBoolean();
            boolean currentValue = configuration.hasProperty(CommonAttributes.ENABLED.getPropertyName()) ? Boolean.parseBoolean(configuration.getPropertyValueString(CommonAttributes.ENABLED.getPropertyName())) : HandlerOperations.isDisabledHandler(logContextConfiguration.getLogContext(), configuration.getName());
            result = resolvedValue == currentValue;
        } else if (attribute.getName().equals(CommonAttributes.ENCODING.getName())) {
            String resolvedValue = CommonAttributes.ENCODING.resolvePropertyValue(context, model);
            String currentValue = configuration.getEncoding();
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
        } else if (attribute.getName().equals(AbstractHandlerDefinition.FORMATTER.getName())) {
            if (model.hasDefined(AbstractHandlerDefinition.NAMED_FORMATTER.getName())) {
                result = true;
            } else {
                String formatterName = configuration.getName();
                if (formatterName.equals(configuration.getFormatterNameValueExpression().getResolvedValue())) {
                    if (logContextConfiguration.getFormatterNames().contains(formatterName)) {
                        FormatterConfiguration fmtConfig = logContextConfiguration.getFormatterConfiguration(formatterName);
                        String resolvedValue = AbstractHandlerDefinition.FORMATTER.resolvePropertyValue(context, model);
                        String currentValue = fmtConfig.getPropertyValueString(PatternFormatterResourceDefinition.PATTERN.getName());
                        result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
                    } else {
                        result = false;
                    }
                } else {
                    result = false;
                }
            }
        } else if (attribute.getName().equals(AbstractHandlerDefinition.NAMED_FORMATTER.getName())) {
            ModelNode valueNode = AbstractHandlerDefinition.NAMED_FORMATTER.resolveModelAttribute(context, model);
            if (valueNode.isDefined()) {
                String resolvedValue = valueNode.asString();
                String currentValue = configuration.getFormatterName();
                result = resolvedValue.equals(currentValue);
            } else {
                result = true;
            }
        } else if (attribute.getName().equals(CommonAttributes.FILTER_SPEC.getName())) {
            ModelNode valueNode = CommonAttributes.FILTER_SPEC.resolveModelAttribute(context, model);
            String resolvedValue = valueNode.isDefined() ? valueNode.asString() : null;
            String currentValue = configuration.getFilter();
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
        } else if (attribute.getName().equals(CommonAttributes.LEVEL.getName())) {
            String resolvedValue = CommonAttributes.LEVEL.resolvePropertyValue(context, model);
            String currentValue = configuration.getLevel();
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(configuration.getLevel());
        } else if (attribute.getName().equals(AsyncHandlerResourceDefinition.SUBHANDLERS.getName())) {
            Object resolvedValue = AsyncHandlerResourceDefinition.SUBHANDLERS.resolvePropertyValue(context, model);
            List currentValue = configuration.getHandlerNames();
            result = resolvedValue == null ? currentValue == null : resolvedValue.containsAll(currentValue);
        } else if (attribute.getName().equals(CommonAttributes.PROPERTIES.getName())) {
            result = true;
            PojoConfiguration pojoConfiguration = logContextConfiguration.getPojoConfiguration(configuration.getName());
            Object propertyConfigurable = pojoConfiguration == null ? configuration : pojoConfiguration;
            if (model.hasDefined(CommonAttributes.PROPERTIES.getName())) {
                for (Property property : CommonAttributes.PROPERTIES.resolveModelAttribute(context, model).asPropertyList()) {
                    String resolvedValue = property.getValue().asString();
                    String currentValue = propertyConfigurable.getPropertyValueString(property.getName());
                    if (resolvedValue != null ? resolvedValue.equals(currentValue) : currentValue == null) continue;
                    return false;
                }
            } else if (model.has(CommonAttributes.PROPERTIES.getName())) {
                List propertyNames = propertyConfigurable.getPropertyNames();
                for (String propertyName : propertyNames) {
                    String propertyValue = propertyConfigurable.getPropertyValueString(propertyName);
                    if (propertyValue == null) continue;
                    return false;
                }
            }
        } else if (attribute instanceof ConfigurationProperty) {
            ConfigurationProperty propAttribute = (ConfigurationProperty)attribute;
            String resolvedValue = String.valueOf(propAttribute.resolvePropertyValue(context, model));
            String currentValue = configuration.getPropertyValueString(propAttribute.getPropertyName());
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
        } else {
            result = false;
        }
        return result;
    }

    static boolean isDisabledHandler(LogContext logContext, String handlerName) {
        Map disableHandlers = (Map)logContext.getAttachment("", DISABLED_HANDLERS_KEY);
        return disableHandlers != null && disableHandlers.containsKey(handlerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void enableHandler(LogContextConfiguration configuration, String handlerName) {
        HandlerConfiguration handlerConfiguration = configuration.getHandlerConfiguration(handlerName);
        try {
            handlerConfiguration.setPropertyValueString("enabled", "true");
            return;
        }
        catch (IllegalArgumentException e) {
            Map disableHandlers = (Map)configuration.getLogContext().getAttachment("", DISABLED_HANDLERS_KEY);
            if (disableHandlers != null && disableHandlers.containsKey(handlerName)) {
                Object object = HANDLER_LOCK;
                synchronized (object) {
                    String filter = (String)disableHandlers.get(handlerName);
                    handlerConfiguration.setFilter(filter);
                    disableHandlers.remove(handlerName);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableHandler(LogContextConfiguration configuration, String handlerName) {
        HandlerConfiguration handlerConfiguration = configuration.getHandlerConfiguration(handlerName);
        try {
            handlerConfiguration.setPropertyValueString("enabled", "false");
            return;
        }
        catch (IllegalArgumentException e) {
            Logger root = configuration.getLogContext().getLogger("");
            Map<String, String> disableHandlers = (HashMap<String, String>)root.getAttachment(DISABLED_HANDLERS_KEY);
            Object object = HANDLER_LOCK;
            synchronized (object) {
                Map current;
                if (disableHandlers == null && (current = (Map)root.attachIfAbsent(DISABLED_HANDLERS_KEY, disableHandlers = new HashMap<String, String>())) != null) {
                    disableHandlers = current;
                }
                if (!disableHandlers.containsKey(handlerName)) {
                    disableHandlers.put(handlerName, handlerConfiguration.getFilter());
                    handlerConfiguration.setFilter(CommonAttributes.DENY.getName());
                }
            }
            return;
        }
    }

    private static void addOrderPropertiesStep(OperationContext context, final PropertySorter propertySorter, final PropertyConfigurable configuration) {
        if (propertySorter.isReorderRequired(configuration)) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    propertySorter.sort(configuration);
                    context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    static class LogHandlerWriteAttributeHandler
    extends LoggingOperations.LoggingWriteAttributeHandler {
        private final PropertySorter propertySorter;

        protected LogHandlerWriteAttributeHandler(AttributeDefinition ... attributes) {
            this(PropertySorter.NO_OP, attributes);
        }

        protected LogHandlerWriteAttributeHandler(PropertySorter propertySorter, AttributeDefinition ... attributes) {
            super(attributes);
            this.propertySorter = propertySorter;
        }

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            boolean restartRequired = false;
            if (logContextConfiguration.getHandlerNames().contains(addressName)) {
                HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(addressName);
                if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, value, logContextConfiguration, configuration, false);
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.FILTER_SPEC, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.FILTER_SPEC.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.FILTER_SPEC, context, value, logContextConfiguration, configuration, false);
                } else if (AbstractHandlerDefinition.FORMATTER.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)AbstractHandlerDefinition.FORMATTER, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.ENCODING.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.ENCODING, context, value, logContextConfiguration, configuration, false);
                } else if (AsyncHandlerResourceDefinition.SUBHANDLERS.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)AsyncHandlerResourceDefinition.SUBHANDLERS, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.PROPERTIES.getName().equals(attributeName)) {
                    HandlerConfiguration propertyConfigurable;
                    PojoConfiguration pojoConfiguration = logContextConfiguration.getPojoConfiguration(configuration.getName());
                    if (pojoConfiguration == null) {
                        propertyConfigurable = configuration;
                    } else {
                        propertyConfigurable = pojoConfiguration;
                        configuration.setPropertyValueString("dummy", "");
                    }
                    if (value.isDefined()) {
                        for (Property property : value.asPropertyList()) {
                            propertyConfigurable.setPropertyValueString(property.getName(), property.getValue().asString());
                        }
                    } else {
                        List propertyNames = propertyConfigurable.getPropertyNames();
                        for (String propertyName : propertyNames) {
                            if (propertyName.equals("enabled")) continue;
                            propertyConfigurable.removeProperty(propertyName);
                            restartRequired = true;
                        }
                    }
                } else if (AsyncHandlerResourceDefinition.QUEUE_LENGTH.getName().equals(attributeName)) {
                    restartRequired = true;
                } else {
                    for (AttributeDefinition attribute : this.getAttributes()) {
                        if (!attribute.getName().equals(attributeName)) continue;
                        HandlerOperations.handleProperty(attribute, context, value, logContextConfiguration, configuration, false);
                        restartRequired = Logging.requiresReload(attribute.getFlags());
                        break;
                    }
                }
                HandlerOperations.addOrderPropertiesStep(context, this.propertySorter, (PropertyConfigurable)configuration);
            }
            return restartRequired;
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
            ModelNode m;
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
            if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                String filterSpec = Filters.filterToFilterSpec(newValue);
                ModelNode filterSpecValue = filterSpec == null ? new ModelNode() : new ModelNode(filterSpec);
                model.getModel().get(CommonAttributes.FILTER_SPEC.getName()).set(filterSpecValue);
            }
            if (AbstractHandlerDefinition.NAMED_FORMATTER.getName().equals(attributeName)) {
                m = model.getModel();
                if (m.hasDefined(AbstractHandlerDefinition.FORMATTER.getName())) {
                    m.get(AbstractHandlerDefinition.FORMATTER.getName()).clear();
                }
            } else if (AbstractHandlerDefinition.FORMATTER.getName().equals(attributeName) && (m = model.getModel()).hasDefined(AbstractHandlerDefinition.NAMED_FORMATTER.getName())) {
                m.get(AbstractHandlerDefinition.NAMED_FORMATTER.getName()).clear();
            }
        }
    }

    static class HandlerAddOperationStepHandler
    extends LoggingOperations.LoggingAddOperationStepHandler {
        private final String[] constructionProperties;
        private final AttributeDefinition[] attributes;
        private final Class<? extends Handler> type;
        private final PropertySorter propertySorter;

        protected HandlerAddOperationStepHandler(Class<? extends Handler> type, AttributeDefinition[] attributes) {
            this.type = type;
            this.constructionProperties = null;
            this.attributes = attributes;
            this.propertySorter = PropertySorter.NO_OP;
        }

        protected HandlerAddOperationStepHandler(PropertySorter propertySorter, Class<? extends Handler> type, AttributeDefinition[] attributes, ConfigurationProperty<?> ... constructionProperties) {
            this.type = type;
            this.attributes = attributes;
            ArrayList<String> names = new ArrayList<String>();
            for (ConfigurationProperty<?> prop : constructionProperties) {
                names.add(prop.getPropertyName());
            }
            this.constructionProperties = names.toArray(new String[names.size()]);
            this.propertySorter = propertySorter;
        }

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                if (CommonAttributes.FILTER.equals(attribute)) {
                    ModelNode filter = CommonAttributes.FILTER.validateOperation(operation);
                    if (!filter.isDefined()) continue;
                    String value = Filters.filterToFilterSpec(filter);
                    model.get(CommonAttributes.FILTER_SPEC.getName()).set(value);
                    continue;
                }
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            boolean exists;
            String moduleName;
            String className;
            if (this.type == null) {
                className = CommonAttributes.CLASS.resolveModelAttribute(context, model).asString();
                moduleName = CommonAttributes.MODULE.resolveModelAttribute(context, model).asString();
            } else {
                className = this.type.getName();
                moduleName = null;
            }
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            boolean replaceHandler = false;
            boolean bl = exists = configuration != null;
            if (exists && !context.isBooting()) {
                context.setRollbackOnly();
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.handlerAlreadyDefined(name));
            }
            if (!exists) {
                LoggingLogger.ROOT_LOGGER.tracef("Adding handler '%s' at '%s'", name, LoggingOperations.getAddress(operation));
                try {
                    configuration = this.createHandlerConfiguration(className, moduleName, name, logContextConfiguration);
                }
                catch (IllegalArgumentException | OperationFailedException e) {
                    context.setRollbackOnly();
                    throw e;
                }
            } else if (Log4jAppenderHandler.class.getName().equals(configuration.getClassName())) {
                PojoConfiguration log4jPojo = logContextConfiguration.getPojoConfiguration(name);
                replaceHandler = log4jPojo != null && !className.equals(log4jPojo.getClassName()) || (moduleName == null ? log4jPojo.getModuleName() != null : !moduleName.equals(log4jPojo.getModuleName()));
            } else if (!className.equals(configuration.getClassName()) || (moduleName == null ? configuration.getModuleName() != null : !moduleName.equals(configuration.getModuleName()))) {
                replaceHandler = true;
            }
            if (replaceHandler) {
                LoggingLogger.ROOT_LOGGER.replacingNamedHandler(name);
                LoggingLogger.ROOT_LOGGER.debugf("Removing handler %s of type '%s' in module '%s' and replacing with type '%s' in module '%s'", new Object[]{name, configuration.getClassName(), configuration.getModuleName(), className, moduleName});
                logContextConfiguration.removeHandlerConfiguration(name);
                if (logContextConfiguration.getPojoNames().contains(name)) {
                    logContextConfiguration.removePojoConfiguration(name);
                }
                try {
                    configuration = this.createHandlerConfiguration(className, moduleName, name, logContextConfiguration);
                }
                catch (IllegalArgumentException | OperationFailedException e) {
                    context.setRollbackOnly();
                    throw e;
                }
            }
            for (AttributeDefinition attribute : this.attributes) {
                boolean skip;
                if (attribute.equals(CommonAttributes.CLASS) || attribute.equals(CommonAttributes.MODULE) || attribute.equals(CommonAttributes.FILTER)) {
                    skip = true;
                } else {
                    boolean bl2 = skip = exists && HandlerOperations.equalValue(attribute, context, model, logContextConfiguration, configuration);
                }
                if (skip) continue;
                HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration);
            }
            HandlerOperations.addOrderPropertiesStep(context, this.propertySorter, (PropertyConfigurable)configuration);
        }

        protected HandlerConfiguration createHandlerConfiguration(String className, String moduleName, String name, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            HandlerConfiguration configuration;
            if (moduleName != null) {
                ModuleLoader moduleLoader = ModuleLoader.forClass(HandlerOperations.class);
                ModuleIdentifier id = ModuleIdentifier.create((String)moduleName);
                try {
                    Class<?> actualClass = Class.forName(className, false, (ClassLoader)moduleLoader.loadModule(id).getClassLoader());
                    if (Appender.class.isAssignableFrom(actualClass)) {
                        PojoConfiguration pojoConfiguration = this.constructionProperties == null ? logContextConfiguration.addPojoConfiguration(moduleName, className, name, new String[0]) : logContextConfiguration.addPojoConfiguration(moduleName, className, name, this.constructionProperties);
                        pojoConfiguration.setPropertyValueString("name", name);
                        configuration = logContextConfiguration.addHandlerConfiguration("org.jboss.as.logging", Log4jAppenderHandler.class.getName(), name, new String[0]);
                        configuration.addPostConfigurationMethod("activate");
                        configuration.setPropertyValueString("appender", name);
                    }
                    if (this.constructionProperties == null) {
                        configuration = logContextConfiguration.addHandlerConfiguration(moduleName, className, name, new String[0]);
                    }
                    configuration = logContextConfiguration.addHandlerConfiguration(moduleName, className, name, this.constructionProperties);
                }
                catch (ClassNotFoundException e) {
                    throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.classNotFound(e, className));
                }
                catch (ModuleLoadException e) {
                    throw LoggingLogger.ROOT_LOGGER.cannotLoadModule(e, moduleName, "handler", name);
                }
            } else {
                configuration = this.constructionProperties == null ? logContextConfiguration.addHandlerConfiguration(moduleName, className, name, new String[0]) : logContextConfiguration.addHandlerConfiguration(moduleName, className, name, this.constructionProperties);
            }
            return configuration;
        }
    }

    static class HandlerUpdateOperationStepHandler
    extends LoggingOperations.LoggingUpdateOperationStepHandler {
        private final AttributeDefinition[] attributes;
        private final PropertySorter propertySorter;

        protected HandlerUpdateOperationStepHandler() {
            this(PropertySorter.NO_OP, new AttributeDefinition[0]);
        }

        protected HandlerUpdateOperationStepHandler(PropertySorter propertySorter, AttributeDefinition ... attributes) {
            this.attributes = attributes;
            this.propertySorter = propertySorter;
        }

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                if (CommonAttributes.FILTER.equals(attribute)) {
                    ModelNode filter = CommonAttributes.FILTER.validateOperation(operation);
                    if (!filter.isDefined()) continue;
                    String value = Filters.filterToFilterSpec(filter);
                    model.get(CommonAttributes.FILTER_SPEC.getName()).set(value);
                    continue;
                }
                if (!operation.has(attribute.getName())) continue;
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public final void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.handlerConfigurationNotFound(name));
            }
            if (this.attributes != null) {
                boolean restartRequired = false;
                boolean reloadRequired = false;
                for (AttributeDefinition attribute : this.attributes) {
                    if (!operation.has(attribute.getName())) continue;
                    HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration);
                    restartRequired = restartRequired || Logging.requiresRestart(attribute.getFlags());
                    reloadRequired = reloadRequired || Logging.requiresReload(attribute.getFlags());
                }
                if (restartRequired) {
                    context.restartRequired();
                } else if (reloadRequired) {
                    context.reloadRequired();
                }
            }
            this.performRuntime(context, configuration, operation, name, model);
            HandlerOperations.addOrderPropertiesStep(context, this.propertySorter, (PropertyConfigurable)configuration);
        }

        public void performRuntime(OperationContext context, HandlerConfiguration configuration, ModelNode operation, String name, ModelNode model) throws OperationFailedException {
        }
    }
}

