/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.core.launcher.AbstractCommandBuilder;
import org.wildfly.core.launcher.Arguments;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Environment;
import org.wildfly.core.launcher.Jvm;
import org.wildfly.core.launcher.logger.LauncherMessages;

public class BootableJarCommandBuilder
implements CommandBuilder {
    private final Arguments javaOpts;
    private String debugArg;
    private String modulesLocklessArg;
    private String modulesMetricsArg;
    private final Map<String, String> securityProperties;
    private final Path bootableJar;
    private Jvm jvm;
    private final Arguments serverArgs;

    private BootableJarCommandBuilder(Path bootableJar) {
        this.bootableJar = bootableJar;
        this.javaOpts = new Arguments();
        this.javaOpts.addAll(AbstractCommandBuilder.DEFAULT_VM_ARGUMENTS);
        this.securityProperties = new LinkedHashMap<String, String>();
        this.serverArgs = new Arguments();
        this.jvm = Jvm.current();
    }

    public BootableJarCommandBuilder setInstallDir(Path installDir) {
        this.setSingleServerArg("--install-dir", installDir.toString());
        return this;
    }

    public List<String> getServerArguments() {
        return this.serverArgs.asList();
    }

    public BootableJarCommandBuilder addServerArguments(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.addServerArgument(arg);
            }
        }
        return this;
    }

    public BootableJarCommandBuilder addServerArguments(Iterable<String> args) {
        if (args != null) {
            for (String arg : args) {
                this.addServerArgument(arg);
            }
        }
        return this;
    }

    public BootableJarCommandBuilder addServerArgument(String arg) {
        if (arg != null) {
            this.serverArgs.add(Arguments.parse(arg));
        }
        return this;
    }

    public BootableJarCommandBuilder setBindAddressHint(String address) {
        this.setSingleServerArg("-b", address);
        return this;
    }

    public BootableJarCommandBuilder setBindAddressHint(String interfaceName, String address) {
        if (interfaceName == null) {
            throw LauncherMessages.MESSAGES.nullParam("interfaceName");
        }
        this.setSingleServerArg("-b" + interfaceName, address);
        return this;
    }

    public BootableJarCommandBuilder setMulticastAddressHint(String address) {
        this.setSingleServerArg("-u", address);
        return this;
    }

    private void setSingleServerArg(String key, String value) {
        this.serverArgs.set(key, value);
    }

    public static BootableJarCommandBuilder of(Path bootableJar) {
        return new BootableJarCommandBuilder(Environment.validateJar(bootableJar));
    }

    public static BootableJarCommandBuilder of(String bootableJar) {
        return new BootableJarCommandBuilder(Environment.validateJar(bootableJar));
    }

    public BootableJarCommandBuilder addJavaOption(String jvmArg) {
        if (jvmArg != null && !jvmArg.trim().isEmpty()) {
            Arguments.Argument argument = Arguments.parse(jvmArg);
            this.javaOpts.add(argument);
        }
        return this;
    }

    public BootableJarCommandBuilder addJavaOptions(String ... javaOpts) {
        if (javaOpts != null) {
            for (String javaOpt : javaOpts) {
                this.addJavaOption(javaOpt);
            }
        }
        return this;
    }

    public BootableJarCommandBuilder addJavaOptions(Iterable<String> javaOpts) {
        if (javaOpts != null) {
            for (String javaOpt : javaOpts) {
                this.addJavaOption(javaOpt);
            }
        }
        return this;
    }

    public BootableJarCommandBuilder setJavaOptions(Iterable<String> javaOpts) {
        this.javaOpts.clear();
        return this.addJavaOptions(javaOpts);
    }

    public BootableJarCommandBuilder setJavaOptions(String ... javaOpts) {
        this.javaOpts.clear();
        return this.addJavaOptions(javaOpts);
    }

    public List<String> getJavaOptions() {
        return this.javaOpts.asList();
    }

    public BootableJarCommandBuilder setDebug() {
        return this.setDebug(false, 8787);
    }

    public BootableJarCommandBuilder setDebug(int port) {
        return this.setDebug(false, port);
    }

    public BootableJarCommandBuilder setDebug(boolean suspend, int port) {
        this.debugArg = String.format("-agentlib:jdwp=transport=dt_socket,server=y,suspend=%s,address=%d", suspend ? "y" : "n", port);
        return this;
    }

    public BootableJarCommandBuilder setJavaHome(String javaHome) {
        this.jvm = Jvm.of(javaHome);
        return this;
    }

    public BootableJarCommandBuilder setJavaHome(Path javaHome) {
        this.jvm = Jvm.of(javaHome);
        return this;
    }

    public BootableJarCommandBuilder setModulesLockless(boolean b) {
        this.modulesLocklessArg = b ? "-Djboss.modules.lockless=true" : null;
        return this;
    }

    public BootableJarCommandBuilder setModulesMetrics(boolean b) {
        this.modulesMetricsArg = b ? "-Djboss.modules.metrics=true" : null;
        return this;
    }

    public BootableJarCommandBuilder addSecurityProperty(String key) {
        this.securityProperties.put(key, null);
        return this;
    }

    public BootableJarCommandBuilder addSecurityProperty(String key, String value) {
        this.securityProperties.put(key, value);
        return this;
    }

    public BootableJarCommandBuilder addSecurityProperties(Map<String, String> properties) {
        this.securityProperties.putAll(properties);
        return this;
    }

    @Override
    public List<String> buildArguments() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.addAll(this.getJavaOptions());
        if (this.jvm.enhancedSecurityManagerAvailable()) {
            cmd.add("-Djava.security.manager=allow");
        }
        if (this.modulesLocklessArg != null) {
            cmd.add(this.modulesLocklessArg);
        }
        if (this.modulesMetricsArg != null) {
            cmd.add(this.modulesMetricsArg);
        }
        if (this.debugArg != null) {
            cmd.add(this.debugArg);
        }
        cmd.add("-jar");
        cmd.add(this.bootableJar.toString());
        StringBuilder sb = new StringBuilder(64);
        for (Map.Entry<String, String> entry : this.securityProperties.entrySet()) {
            sb.append("-S").append(entry.getKey());
            if (entry.getValue() != null) {
                sb.append('=').append(entry.getValue());
            }
            cmd.add(sb.toString());
            sb.setLength(0);
        }
        cmd.addAll(this.getServerArguments());
        return cmd;
    }

    @Override
    public List<String> build() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.jvm.getCommand());
        cmd.addAll(this.buildArguments());
        return cmd;
    }

    public Path getJavaHome() {
        return this.jvm.getPath();
    }
}

