/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    AUDIT_LOG("audit-log"),
    EXPOSE_RESOLVED_MODEL("expose-resolved-model"),
    EXPOSE_EXPRESSION_MODEL("expose-expression-model"),
    HANDLER("handler"),
    HANDLERS("handlers"),
    JMX_CONNECTOR("jmx-connector"),
    SENSITIVITY("sensitivity"),
    SHOW_MODEL("show-model"),
    REMOTING_CONNECTOR("remoting-connector");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

