/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.jmx.SecurityActions;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.security.UserInfo;
import org.jboss.remotingjmx.ServerMessageInterceptor;
import org.jboss.remotingjmx.ServerMessageInterceptorFactory;

class ServerInterceptorFactory
implements ServerMessageInterceptorFactory {
    ServerInterceptorFactory() {
    }

    public ServerMessageInterceptor create(Channel channel) {
        return new Interceptor(channel);
    }

    private static class Interceptor
    implements ServerMessageInterceptor {
        private final Channel channel;

        private Interceptor(Channel channel) {
            this.channel = channel;
        }

        public void handleEvent(final ServerMessageInterceptor.Event event) throws IOException {
            UserInfo userInfo = this.channel.getConnection().getUserInfo();
            Subject subject = userInfo instanceof SubjectUserInfo ? ((SubjectUserInfo)userInfo).getSubject() : new Subject();
            try {
                AccessAuditContext.doAs((Subject)subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        SecurityActions.currentAccessAuditContext().setAccessMechanism(AccessMechanism.JMX);
                        event.run();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception cause = e.getException();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new IOException(cause);
            }
        }
    }
}

