/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.net.CidrAddressTable;
import org.wildfly.extension.io.logging.IOLogger;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class WorkerService
implements Service<XnioWorker> {
    private final XnioWorker.Builder builder;
    final InjectedValue<ExecutorService> injectedExecutor = new InjectedValue();
    private final Object stopLock = new Object();
    private XnioWorker worker;
    private volatile StopContext stopContext;

    public WorkerService(OptionMap optionMap) {
        this(Xnio.getInstance().createWorkerBuilder().populateFromOptions(optionMap));
    }

    public WorkerService(XnioWorker.Builder builder) {
        this.builder = builder;
    }

    public void start(StartContext startContext) throws StartException {
        this.builder.setTerminationTask(this::stopDone);
        this.worker = this.builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        this.stopContext = context;
        ExecutorService executorService = (ExecutorService)this.injectedExecutor.getValue();
        Runnable asyncStop = () -> {
            XnioWorker localWorker = this.worker;
            this.worker = null;
            localWorker.shutdown();
            boolean interrupted = false;
            try {
                Object object = this.stopLock;
                synchronized (object) {
                    if (this.stopContext != null) {
                        try {
                            this.stopLock.wait(100L);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                if (this.stopContext != null) {
                    List tasks = localWorker.shutdownNow();
                    for (Runnable task : tasks) {
                        IOLogger.ROOT_LOGGER.debugf("Worker was shut down forcibly. Submitting task %s to the management executor", task);
                        executorService.submit(task);
                    }
                }
            }
            finally {
                this.stopDone();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        try {
            try {
                executorService.execute(asyncStop);
            }
            catch (RejectedExecutionException e) {
                asyncStop.run();
            }
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDone() {
        Object object = this.stopLock;
        synchronized (object) {
            StopContext stopContext = this.stopContext;
            this.stopContext = null;
            if (stopContext != null) {
                stopContext.complete();
            }
            this.stopLock.notifyAll();
        }
    }

    CidrAddressTable<InetSocketAddress> getBindingsTable() {
        return this.builder.getBindAddressConfigurations();
    }

    public XnioWorker getValue() throws IllegalStateException, IllegalArgumentException {
        return this.worker;
    }
}

